/*
 * This OS/2 port was hacked by Harald Kipp from the
 *
 *      Network News Transfer Protocol server
 *
 *      Phil Lapsley
 *      University of California, Berkeley
 *      Stan Barber
 *      Baylor College of Medicine
 *
 * Bug reports related to THIS modified version should be sent to
 *
 *  harald@os2point.ping.de
 *  harald@haport.sesam.com
 *  Fido: 2:2448/434
 *
 */
#define OS2
#include <os2.h>

#include <types.h>
#include <netinet\in.h>
#include <sys\socket.h>
#include <netlib.h>

#undef min
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <process.h>

#include <tcpconn.h>

#include "globals.h"
#include "nntp.h"
#include "changi.h"

long group_artnum = 0;

static char *verbiage[]=
{
    "head and body follow",
    "head follows",
    "body follows",
    "request text separately"
};

/*
 * {ARTICLE,HEAD,BODY,STAT} <messageid>|articlenum
 *
 * Retrieve article, head, body, or stat, depending on the
 * command we were invoked with.
 */

void ahbs(PNEWSCLIENT pnc, int argc, char *argv[])
{
    char artbuf[MAXPATHLEN];
    char art_id[MAXBUFLEN];
    int method;
    FILE *fp;				/* For Message-ID retrieval only */

    if (argc > 2) {
	so_printf(pnc -> s, "%d Usage: %s <message-id>|article_number.\r\n",
		  ERR_CMDSYN, argv[0]);
	return;
    }

    switch(toupper(*argv[0])) {
    case 'A':
        method = ARTICLE;
        break;
    case 'H':
        method = HEAD;
        break;
    case 'S':
        method = STAT;
        break;
    default:
        method = BODY;
        break;
    }

    /*
     * Retrieve article by message id
     */
    if (argc == 2 && *argv[1] == '<') {
        if((fp = openartbyid(pnc, argv[1])) == NULL) {
	    so_printf(pnc -> s, "%d No article with message-id %s.\r\n",
		      ERR_NOART, argv[1]);
	    return;
	}
	if (check_ngperm(fp) == 0) {
	    so_printf(pnc -> s, "%d Can't give that to you, sorry.\r\n",
		      ERR_ACCESS);
	    fclose(fp);
	    return;
	}
	if (so_printf(pnc -> s, "%d %ld %s Article retrieved, %s.\r\n",
		      OK_ARTICLE + method, group_artnum, argv[1],
		      verbiage[method]) != -1)
	    spew(pnc -> s, fp, method);
	fclose(fp);
	return;
    }

    if (!pnc -> canread) {
	so_printf(pnc -> s, "%d You only have permission to transfer, sorry.\r\n",
		  ERR_ACCESS);
	return;
    }

    if (!pnc -> ingroup) {
	so_printf(pnc -> s, "%d You are not currently in a newsgroup.\r\n",
		  ERR_NCING);
	return;
    }

    if (argc == 1) {
	if (pnc -> art_ptr < 0 || pnc -> art_ptr >= pnc -> num_arts) {
	    so_printf(pnc -> s, "%d No article is currently selected.\r\n",
		      ERR_NOCRNT);
	    return;
	}
        sprintf(artbuf, "%ld", pnc -> art_array[pnc -> art_ptr]);
    }
    else
	strcpy(artbuf, argv[1]);

    if (!atol(artbuf)) {
	so_printf(pnc -> s, "%d Invalid article number: %s.\r\n",
		  ERR_NOARTIG, artbuf);
	return;
    }

    while ((pnc -> art_fp = open_valid_art(pnc, artbuf, art_id)) == NULL) {
	if (argc > 1) {
	    so_printf(pnc -> s, "%d Invalid article number: %s.\r\n",
		      ERR_NOARTIG, artbuf);
	    return;
	}
	else {
	    if (++(pnc -> art_ptr) >= pnc -> num_arts) {
		so_printf(pnc -> s, "%d Invalid article number.\r\n",
			  ERR_NOARTIG);
		return;
	    }
            sprintf(artbuf, "%ld", pnc -> art_array[pnc -> art_ptr]);
	}
    }

    if (so_printf(pnc -> s, "%d %s %s Article retrieved; %s.\r\n",
	       OK_ARTICLE + method, artbuf, art_id, verbiage[method]) != -1)
	spew(pnc -> s, pnc -> art_fp, method);

    if (argc > 1)
	pnc -> art_ptr = findart(artbuf, pnc -> art_array, pnc -> num_arts);
}
