/******************************  PSP.C  *****************************
*  DESC:       Program to print text files on PostScript printers.  *
*  AUTHOR:     Marv Luse, Ithaca Street Software, Inc.              *
*  DATE:       December, 1989                                       *
*  COPYRIGHT:  Use freely as long as authorship is acknowledged.    *
********************************************************************/

#include "stdlib.h"
#include "stdio.h"
#include "string.h"
#include "time.h"

/*
 *   Notes:  (1) Program creates an 8-1/2" x 11" page with 3/4"
 *               margins all around.  Top 1/4" and bottom 1/4"
 *               of active page area used for header and footer.
 *
 *           (2) All page coords are in points (72 points = 1 inch)
 *
 *           (3) Page origin (0,0) located at bottom left, yielding:
 *
 *               Ŀ
 *                                                     
 *                   + (54,738)         (558,738) +    
 *                                                     
 *                                                     
 *               /                                      /
 *               .         Page Coordinate Space        .
 *               .              in Points               .
 *               /                                      /
 *                                                     
 *                                                     
 *                   + (54,54)           (558,54) +    
 *                                                     
 *               
 *
 *           (4) Control char handling:
 *
 *               Carriage Return (0Dh) causes end-of-line
 *               Line Feed (0Ah) ignored
 *               Form Feed (0Ch) causes end-of-line and end-of-page
 *               Tab Char (09h) expands to TAB_SIZE blanks
 *               All other codes treated as text.
 *
 *           (5) To handle files with ASCII values above 127
 *               the program should be compiled with default
 *               char type of unsigned (/J on MSC, -K on TurboC).
 */

#define MAX_LEN     80     /* File Names Buffer Length */
#define HDR_HGT     18     /* Page header space in points */
#define FTR_HGT     18     /* Page footer space in points */
#define LINE_SIZE  132     /* I/O buffer length */
#define TAB_SIZE     5     /* number of blanks per tab */

/* special characters */
#define TAB_CH       9
#define FF_CH       12
#define CR_CH       13
#define LF_CH       10

/* macro to test for end-of-line */
#define eoln( c )  ( ((c==CR_CH) || (c==FF_CH) || (c==0) ) ? 1 : 0 )

/* macro to test for end-of-page */
#define eopg( c, n )  ( ((c==FF_CH) || (n>=LnPerPg)) ? 1 : 0 )

/* if not using RIPS Image 4000, undefine RIPS */
#define RIPS 1

char FileToPrint[MAX_LEN+1] = "",            /* file to be printed */
     PrintDevice[MAX_LEN+1] = "LPT2",              /* printer port */
     DateAndTime[28],                             /* time and date */
     FontName[MAX_LEN+1]    = "Courier";            /* font to use */

int  PtSize  = 11,                           /* text hgt in points */
     LnSize  = 12,                           /* line hgt in points */
     LnPerPg = 0,                                /* lines per page */
     LineNo  = 0,                           /* current line number */
     PageNo  = 0;                           /* current page number */

int  XLft, XRgt, XCur,                /* page coordinate variables */
     YTop, YBot, YCur;

time_t currentT;                                   /* current time */

FILE   *fTxt,                                      /* text file in */
       *fPrt;                                       /* printer out */

/*-----------------------------------------------------------------*/

/* display a message and exit */

void exit_pgm( char *msg, int retv )
{
    printf( "\n%s", msg );
    exit( retv );
}

/*-----------------------------------------------------------------*/

/* explain program usage */

void explain_pgm( void )
{
    printf( "\n" );
    printf( "\nPSP - Program to print text files on PostScript printers" );
    printf( "\n" );
    printf( "\nusage:  PSP  file_to_print  [printer_port]" );
    printf( "\n             file_to_print : path to an ASCII text file" );
    printf( "\n             printer_port  : path to printer [def=LPT2]" );
    printf( "\n" );
}

/*-----------------------------------------------------------------*/

/* initialize for processing */

void start_up( char *f_in, char *f_out )
{
    int i;

    fTxt = fopen( f_in, "rt" );
    if( fTxt == NULL )  exit_pgm( "Could not locate input file", 8);

    fPrt = fopen( f_out, "wt" );
    if( fPrt == NULL )  exit_pgm( "Error opening printer", 8);

    time( &currentT );
    strcpy( DateAndTime, ctime( &currentT ) );
    /* get rid of trailing newline character copied from ctime */
    i = 0;
    while( DateAndTime[i] >= ' ' ) i++;
    DateAndTime[i] = 0;
}

/*-----------------------------------------------------------------*/

/* clean up before returning to DOS */

void shut_dn( void )
{
    fclose( fTxt );
    fclose( fPrt );
    printf( "\nTotal page(s) printed = %d", PageNo );
}

/*-----------------------------------------------------------------*/

/* function to write font-select code */

void set_font( void )
{
    fprintf( fPrt, "\n/%s findfont", FontName );
    fprintf( fPrt, "\n%d scalefont", PtSize );
    fprintf( fPrt, "\nsetfont" );
}

/*-----------------------------------------------------------------*/

/* function to draw a line between passed endpoints */

void draw_