// MENUS.CPP : demonstration of drop-menus
// by Bruce Eckel. (c) The C Gazette

#include "dropmenu.hpp"
#include <stdio.h>
#include <stdlib.h>

// Create a bunch of functions using a preprocessor macro:
#define FN(arg) int function_##arg() { puts("function " #arg); return 1; }
FN(1) FN(2) FN(3) FN(4) FN(5) FN(6) FN(7) FN(8) FN(9)
FN(s1) FN(s2) FN(s3)
// An exit function:
int quit() { exit(0); return 0; }

dm_item * sub1[] = {
  new dm_item("^one", function_s1),
  new dm_item("^two", function_s2),
  new dm_item("t^hree", function_s3),
  new dm_item("e^xit", quit),
  new dm_item("", function_1)  // empty string indicates end
};

drop_menu submenu1(sub1);

// note the use of other menus inside menus:
dm_item * sub2[] = {
  new dm_item("^one",   &submenu1),
  new dm_item("^two",   &submenu1),
  new dm_item("t^hree", &submenu1),
  new dm_item("", function_1)
};

drop_menu submenu2(sub2);

dm_item * dm1[] = {
  new dm_item("^one",  &submenu2),
  new dm_item("^two",  &submenu2),
  new dm_item("t^hree", &submenu2),
  new dm_item("^four",  &submenu2),
  new dm_item("f^ive",  &submenu2),
  new dm_item("^six",  &submenu2),
  new dm_item("^yow",  &submenu2),
  new dm_item("", function_1)
};

drop_menu menu1(dm1);

main() {
  while(1)
    menu1.activate(5,15);
}