// DROPMENU.HPP : Drop-down menus
// by Bruce Eckel (C) C Gazette

class drop_menu; // class name declarations
class screen_box;

class dm_item {
    char * name;
    char activation_letter;
    unsigned actual_line; // physical start when printed
    int (*fptr)(void);  // when activating a function
    drop_menu * mptr;   // when activating a menu
    void find_activation_letter();
 public:
    // an item can call a function or a menu:
    dm_item(char * nm, int (*fp)(void));
    dm_item(char * nm, drop_menu * submenu);
    char * nm() { return name; }
    void print(int line, screen_box & box);
    void test_and_execute(unsigned keypress, drop_menu & menu);
};

class drop_menu {
    dm_item ** items;
    unsigned mheight, mwidth;
    unsigned default_x, default_y;  // default starting positions
    unsigned actual_x, actual_y;    // actual starting positions
public:
    drop_menu(dm_item ** dm, unsigned xpos = 0, unsigned ypos = 0);
    void activate(unsigned y = 0, unsigned x = 0);
    void test_keypress(unsigned keypress);
    unsigned y() { return actual_y; }
    unsigned x() { return actual_x; }
    unsigned width() { return mwidth; }
};