/*********************  BUILD.C --  LISTING 2  **********************
*  Build the translation tables for COMPRESS.ASM.
*
*  Author : Bob Zigon
*  Date   : June 9, 1988
*
*  Compiler: Turbo C 2.0, MSC 5.1
*  Memory model: any
*  Compile switches: none
*
********************************************************************/

#include <stdio.h>

#define TABLEWIDTH 8

/* The following table defines the mapping function in the compressed
   file.  Each of the 256 possible ASCII characters is represented. If
   the value is zero, then that character cannot be compressed and will
   be unpacked as a space. The characters that one wants to be able to
   compress and uncompress should be given numbers between 1 and 39. To
   take a case in point, 'A' is ASCII 65 and is mapped to 0x01. Its
   lower case counterpart, 'a' is ASCII 95, and it too is mapped to 0x01.
 */

unsigned short int AsciiTable[256] = {
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   /*   0 -   7 */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   /*   8 -  15 */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   /*  16 -  23 */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   /*  24 -  31 */
      0x00, 0x00, 0x00, 0x00, 0x27, 0x00, 0x00, 0x00,   /*  32 -  39 */
      0x00, 0x00, 0x00, 0x00, 0x26, 0x00, 0x25, 0x00,   /*  40 -  47 */
      0x1B, 0x1C, 0x1D, 0x1E, 0x1F, 0x20, 0x21, 0x22,   /*  48 -  55 */
      0x23, 0x24, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   /*  56 -  63 */
      0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,   /*  64 -  71 */
      0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F,   /*  72 -  79 */
      0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,   /*  80 -  87 */
      0x18, 0x19, 0x1A, 0x00, 0x00, 0x00, 0x00, 0x00,   /*  88 -  95 */
      0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07,   /*  96 - 103 */
      0x08, 0x09, 0x0A, 0x0B, 0x0C, 0x0D, 0x0E, 0x0F,   /* 104 - 111 */
      0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17,   /* 112 - 119 */
      0x18, 0x19, 0x1A, 0x00, 0x00, 0x00, 0x00, 0x00,   /* 120 - 127 */

      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   /* 128 - 135 */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   /* 136 - 143 */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   /* 144 - 151 */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   /* 152 - 159 */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   /* 160 - 167 */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   /* 168 - 175 */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   /* 176 - 183 */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   /* 184 - 191 */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   /* 192 - 199 */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   /* 200 - 207 */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   /* 208 - 215 */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   /* 216 - 223 */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   /* 224 - 231 */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   /* 232 - 239 */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,   /* 240 - 247 */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00    /* 248 - 255 */
   };

FILE *fp;

/********************************************************************
*                    Function Prototypes
********************************************************************/

void BuildXlateTable(char *, unsigned short int *, unsigned short int);
void CheckTable(char *, unsigned short int *);

void main()
{

    fp = fopen("COMPRESS.TBL", "w");

    fprintf(fp, "\n;");
    fprintf(fp, "\n; Translation tables for Pack3 routine.");
    fprintf(fp, "\n;\n");

    BuildXlateTable("Xlate0", AsciiTable, 1);
    BuildXlateTable("Xlate1", AsciiTable, 40);
    BuildXlateTable("Xlate2", AsciiTable, 1600);

    fprintf(fp, "\n;");
    fprintf(fp, "\n; Translation table for UnPack3 routine.");
    fprintf(fp, "\n;\n");

    CheckTable("ToAscii", AsciiTable);

    fputc('\n', fp);
    fputc(0x1A, fp);
    fclose(fp);
}

void CheckTable(char *TableName, unsigned short int Table[])
{
    unsigned MinVal = 0xFFFF, MaxVal = 0;
    short int i, ValCount, AscMatch;

    for (i = 0; i < 256; i++) 
    {
        if (Table[i] < MinVal) MinVal = Table[i];
        if (Table[i] > MaxVal) MaxVal = Table[i];
    }

    printf("\nAnalysis of Ascii Mappings");
    printf("\n--------------------------\n");
    printf("\nMinimum Value : %4d", MinVal);
    printf("\nMaximum Value : %4d\n", MaxVal);

    printf("\nTranslated    Ascii");
    printf("\n  Value       Value");
    printf("\n-------------------");

    fprintf(fp, "%-10s", TableName);

    for ( ; MinVal <= MaxVal; MinVal++) 
    {
        /* Format and Output the Translated Value. */

        ValCount = AscMatch = 0;
        printf("\n%3d          ", MinVal);

        /* Now search every entry in TABLE[] for a match against
           the current Translated Value.  */

        for (i = 0; i < 256; i++)
            if (Table[i] == MinVal) 
            {
                if (AscMatch == 0) 
                {
                    /* The Encoding for 0 is special;
                       I have assigned a space to it. */

                    if (MinVal == 0)
                        fprintf(fp,"dw %04Xh   ; %3d\n          ", 32, MinVal);
                    else
                        fprintf(fp,"dw %04Xh   ; %3d\n          ", i, MinVal);
                    AscMatch = 1;
                }

                if (++ValCount > 1 && ValCount != 12)
                    printf(", ");
                else
                if (ValCount == 12) 
                {
                   printf("\n             ");
                   ValCount = 1;
                }
                printf("%3d", i);
            }
    }
    printf("\n\n");
}

void BuildXlateTable(char *TableName,
                     unsigned short int Table[],
                     unsigned short int Scale)
{
    short int i, j;

    /*  Output the Table Name.  */

    fprintf(fp, "\n%-10s", TableName);

    /*  Loop over every character in the input table. */

    for (i = 0; i < 256/TABLEWIDTH; i++) 
    {
        if (i)
            fprintf(fp, "          ");

        for (j = 0; j < TABLEWIDTH; j++) 
        {
            if (j == 0)
                fprintf(fp, "dw ");
            fprintf(fp, "%05Xh", Table[i*TABLEWIDTH+j]*Scale);

            /* Append a comma after every table entry 
               except the last one on each row.  */

            if (j != TABLEWIDTH-1)
                fprintf(fp, ", ");
        }
        fprintf(fp, "\n");
    }
}
