// LLIST.HXX
// Generic Linked-list container class.
// Inherit this class into a class which specifies the type of
// object to be stored in the list by re-defining the arguments
// and return values (see LLTEST.CXX for an example).
//   Notice that the linked-list maintains the order of the list,
// and allows you to sort the list, etc., while a "bag" container
// like a DynArray ignores order.
//   This class works as a container only for pointers to different
// kinds of objects.  You need templates to be able to contain
// the objects themselves (a feature which will be added in a
// release after 2.0).
#ifndef _LLIST_HXX
#define _LLIST_HXX

struct llist_el {
  void * data;  // pointer to the object stored in the list
  llist_el * next;  // This is a singly-linked list.
};

class llist {
  llist_el * head;
  llist_el * tail;
  llist_el * cursor;
  llist_el * previous;  // element before cursor (for linking & unlinking)
protected:
  // to properly delete the data element:
  virtual void delete_data(void *) {};
  // When you inherit this class, you must re-define this 
  // function like so:
  // void delete_data(void * dp) {
  //   delete (my_data_type *)dp;
  // }
  // Where my_data_type is the type of object to be contained
  // in the derived class.
public:
  llist();
  void append(void *); // add to end of list
  void insert(void *); // insert before cursor
  void push_to_end(); // move current element to end of list
  // nonzero return value indicates failure:
  int remove(); // delete current link
  void reset();  // reset cursor to beginning of list
  int next();  // nonzero return value means cursor moved
  int end(); // nonzero value means you are at the end of the list
  void * value(); // pointer of the current data value
  ~llist();  // remove all elements from the list
};

#endif // _LLIST_HXX
