/**********************************************************************
 * blowstk.c - demonstrate stack overflow checking
 *
 * Author: John Rex
 * Date: July, 1989
 * Compilers: Turbo C 2.0, MSC 5.1
 * Memory model: any
 * Compile time switches:
 *    SAFETY_MARGIN - minimum number of bytes that we are willing to
 *                    leave free on the stack for system interrupts,
 *                    calls to error handling routines, etc.
 *
 * Usage: Just compile and invoke.  It runs a recursive routine to blow
 *        the stack.  The number of successful calls is reported.
 *
 * Sources: This code was derived from study of the Turbo C and Microsoft
 *          C run-time libraries and startup code.
 *
 * Source code and object code may be used freely.
 ********************************************************************/

#define SAFETY_MARGIN 500

#if defined(__TURBOC__)
    #if defined(__SMALL__) || defined(__MEDIUM__) || defined(__TINY__)
        #define TURBOSMALL
    #else
        #define TURBOLARGE
    #endif
#else
    #define MSC
#endif

int count;  /* set to max # of calls we were able to make */

void blowstack(int i)
{
    /* stack check protocols */

#if defined(TURBOSMALL)
    extern unsigned __brklvl;

    if (_SP < (__brklvl + SAFETY_MARGIN)) { /* true if blown */
        count = i;
        return;
    }
#endif

#if defined(TURBOLARGE)
    if (_SP < SAFETY_MARGIN) { /* true if blown */
        count = i;
        return;
    }
#endif

#if defined(MSC)
    unsigned getsp();
    extern int end;

    if ( getsp() < (((unsigned) &end) + SAFETY_MARGIN)) { /* true if blown */
        count = i;
        return;
    }
#endif

    /* otherwise, recurse! */
    blowstack(i+1);
}

#include <stdio.h>
void main()
{
    blowstack(1);
    printf("Blowstack() made %d calls\n", count);
}
