/************************** DIFPROTO.H *************************
*   Prototypes of functions defined in dif.c
*   (c) Copyright Victor Volkman, 1989. See dif.c for terms.
***************************************************************/

int add_dif_numeric_to_db3_record(int, dif_elt_p, db3_hdr_p);
int add_dif_string_to_db3_record(int, dif_elt_p, db3_hdr_p);
int add_dif_to_db3_record(int, dif_elt_p, db3_hdr_p);

int build_db3_name_from_label(char *, char *);
int build_db3_name_from_label(char *, char *);

int calculate_db3_header(dif_hdr_p, db3_hdr_p);
char *mcalloc(int, int);

int check_dif_type_numeric(dif_elt_p, db3_hdr_elt_p);
int check_dif_type_string(dif_elt_p, db3_hdr_elt_p);

int dif_to_db3(char *, char *);
int dump_db3_hdr(db3_hdr_p);
int dump_db3_hdr_elt(db3_hdr_elt_p);
int error_msg(char *, char *);

int format_db3_date_from_string(char *, char *);
int format_db3_logical_from_string(char *, char *);
int free_dif_hdr(dif_hdr_p);
int free_db3_hdr(db3_hdr_p);

int is_date(char *);
int is_logical(char *);

int lookup_val_strs(char *, enum dif_val_vals *);
int main(int, char **);
int mfree(char *);

int read_dif_cell(FILE *, dif_elt_p);
int read_dif_data_and_write_db3(FILE *, int, db3_hdr_p);
int read_dif_data_for_types(FILE *, db3_hdr_p);
int read_dif_hdr_elt(FILE *, dif_elt_p, enum dif_hdr_vals *);
int read_dif_line(FILE *, char *);
int read_opt_dif_header(FILE *, dif_hdr_p);
int read_reqd_dif_header(FILE *, dif_hdr_p, db3_hdr_p);
int write_db3_header(int, dif_hdr_p, db3_hdr_p);
