/***** RSE.C - Redirect standard error to standard out *************
 * Author: Larry Reid                                              *
 * Compilers: Microsoft, Turbo C. Watcom compiles but does not run *
 *            correctly; DeSmet, Lattice, Zortech cannot compile.  *
 * Memory Models: all                                              *
 *                                                                 *
 * Usage: if you ordinarily invoke your program with               *
 *                                                                 *
 *      C>program arg1 arg2 arg3 ...                               *
 *                                                                 *
 *  then invoke it with                                            *
 *                                                                 *
 *      C>rse program arg1 arg2 arg3 ...                           *
 *                                                                 *
 * Source code may be freely used if source is acknowledged.       *
 * Executable form may be freely used. (c) 1988 The C Gazette      *
 *                                                                 *
 *******************************************************************/

#include <stdio.h>
#include <process.h>
#include <io.h>

extern unsigned char _osmajor;

void main(int argc, char **argv)
{

    if (_osmajor < 2) {
        fputs("RSE: can't run under DOS 1.x!\n", stderr);
        exit(1);
    }

    if (argc < 2) {
        fputs("RSE: nothing to execute!\n", stderr);
        exit(0);
    }

    /* Here is the trick: dup2() forces DOS to route references
       to stderr to stdout. The fileno() function returns the
       handle associated with each file.
     */

    if (dup2(fileno(stdout),fileno(stderr)) != 0) {
        fputs("RSE: couldn't redirect stderr!\n", stderr);
        exit(1);
    }

    /* and now invoke the "real" program with
       what is left of the command line.       */

    spawnvp(P_OVERLAY, argv[1], argv+1);
}
