/* ************************************* */
/* Ŀ */
/*  Ŀ    ĿĿĿĿĿ  */
/*           Ŀ          */
/*               */
/*    CF2FFF v1.0    */
/*                                     */
/* CF2FFF is a AdeptXBBS utility to    */
/* converts fast and easy:             */
/*     Filebone.na -> File_Areas       */
/*     Filebone.na -> File.Control     */
/*     Filebone.na -> Fgroup?.asc      */
/*                                     */
/* Optionaly creates TIC directories   */
/* on your HardDisk!                   */
/*                                     */
/*  By Koen Koster  */
/* Any comments, questions, thanks msgs? */
/* Send them to:     kkoster@cistron.nl  */
/*                   2:281/602.0@FidoNet */
/*                   55:66/0.0@AdeptNet  */
/* ************************************* */

/* ********************************************************************** */
/* ********* Begin of the Sysop definable Configuration section ********* */
/* ********************************************************************** */

STARTNR = '100'                   /*  nr of area to start with            */

AFANOUT   = 'FgroupZ.Asc'         /* Name of AFAN Fgroup?.asc file        */
AREAFILE  = 'filebone.na'         /* Name of Fido filebone.na file        */
FOUTFILE  = 'file_areas'          /* Name of the File_Areas output file   */

/* ************************* FILE AREA SETTINGS ************************* */

FULPATH  = 'e:\upload'            /*  Your upload path                    */
FRSEC1   = '10'                   /*  Read  Security 1                    */
FRSEC2   = '10'                   /*  Read  Security 2                    */
FWSEC1   = '10'                   /*  Write Security 1                    */
FWSEC2   = '10'                   /*  Write Security 2                    */
FSSEC1   = '100'                  /*  Sysop Security 1                    */
FSSEC2   = '100'                  /*  Sysop Security 2                    */
FFLAGS   = '3072'                 /*  File Area Flags                     */

/* *************************** TIC SECTION ****************************** */

AOUTFILE  = 'file.control'   /* Name of the File.Control output file      */
MAKEDIR  = '0'               /* 1 = make dirs  and 0 = is don't make dirs */
TICDIR   = 'd:\filebone\'
TFLAGS   = 'DLDIR NOTICCRC'                          /* Tic Area Flags    */
NODENR   = '2:281/631.0@FidoNet'                     /* Export Nodenummer */
PASSWORD = 'SECRET'                                  /* Tic Password      */
ACCESS   = 'R'                                       /* Tic Acceslevel    */

/* ********************************************************************** */
/* ********* *END* of the Sysop definable Configuration section ********* */
/* ********************************************************************** */

 call RxFuncAdd 'SysFileTree','RexxUtil','SysFileTree'
 call RxFuncAdd 'SysMkDir','RexxUtil','SysMkDir'
 Call SysCls

rc = stream( areafile, 'c', 'open read' )
rc = stream( foutfile, 'c', 'open write' )
rc = stream( aoutfile, 'c', 'open write' )

oldstartnr = startnr
starttime = time('E')

checklines:
   check = lines(areafile)
    do while check > 0
    line = LineIn(areafile)
   if substr(line,1,4) = 'Area' then do
     aname = substr(line,6,8)
     adesc = substr(line,29,50)
     Call LineOut aoutfile,';'
     Call LineOut aoutfile,'FILEAREA 'startnr' 'aname
     Call LineOut aoutfile,'FLAGS 'tflags
     Call LineOut aoutfile,nodenr' 'password' 'access
     Call LineOut foutfile,'AREABEGIN'
     Call LineOut foutfile,'  NAME     'aname
     Call LineOut foutfile,'  NUMBER   'startnr
     Call LineOut foutfile,'  DESC     'adesc
     Call LineOut foutfile,'  DLPATH   'ticdir''aname
     Call LineOut foutfile,'  ULPATH   'fulpath
     Call LineOut foutfile,'  RSEC1    'frsec1
     Call LineOut foutfile,'  RSEC2    'frsec2
     Call LineOut foutfile,'  WSEC1    'fwsec1
     Call LineOut foutfile,'  WSEC2    'fwsec2
     Call LineOut foutfile,'  SSEC1    'fssec1
     Call LineOut foutfile,'  SSEC2    'fssec2
     Call LineOut foutfile,'  FLAGS    'fflags
     Call LineOut foutfile,'AREAEND'
     Call LineOut afanout, Left(startnr,6)'- 'adesc
     Say 'Writing Out File Area -> 'startnr
     tempdir = ticdir||aname
     call SysFileTree tempdir,'dir','DO'
   if (makedir = 1 & dir.0 = 0) then
      call SysMkDir tempdir
     startnr = startnr + 1
    end
  if substr(line,1,4) < 'Area' then do
    nop
   end
     check = lines(areafile)
 end

Back:
totalnr = (startnr - oldstartnr)
curtime = time('R')
newtime = format(curtime,,2)
Say ' '
Say ' '
Say 'Total of 'totalnr' Areas processed in 'newtime' seconds by CF2FFF.'
Say ' '
Say 'OutPut File.control : 'aoutfile
Say 'OutPut File_Areas   : 'foutfile
Say 'OutPut Fgroup?.Asc  : 'afanout
Say ' '
Say 'Thanks for using CF2FFF and have a Nice Day!'
rc = stream( areafile, 'c', 'close' )
rc = stream( aoutfile, 'c', 'close' )
rc = stream( foutfile, 'c', 'close' )
rc = stream( afanout, 'c', 'close' )
