# MSDOS Microsoft C makefile for Cephes library
CFLAGS=/c
# For large memory model:
#CFLAGS=/c /AL
# Add /FPa to the CFLAGS if you want to use the fast software FPa arithmetic.
#
# Use the following with /FPa if you do not want to use the 80x87 coprocessor
# or software emulator.
#polevl.obj: polevl.c mconf.h
#	cl /c /Ox polevl.c
#
# Use the following instead if you want to use an 80x87 chip or
# software emulator for maximum accuracy computation of the
# polynomial expansions:
polevl.obj: polevl.asm mconf.h
	masm polevl.asm/r;

#floor.obj: floor.asm
#	masm floor.asm;

floor.obj: floor.c mconf.h
	cl $(CFLAGS) floor.c

acosh.obj: acosh.c mconf.h
	cl $(CFLAGS) acosh.c

asin.obj: asin.c  mconf.h
	cl $(CFLAGS) asin.c

asinh.obj: asinh.c mconf.h
	cl $(CFLAGS) asinh.c

atan.obj: atan.c mconf.h
	cl $(CFLAGS) atan.c

atanh.obj: atanh.c mconf.h
	cl $(CFLAGS) atanh.c

asinh.obj: asinh.c mconf.h
	cl $(CFLAGS) asinh.c

cbrt.obj: cbrt.c mconf.h
	cl $(CFLAGS) cbrt.c

chbevl.obj: chbevl.c mconf.h
	cl $(CFLAGS) chbevl.c

cmplx.obj: cmplx.c mconf.h
	cl $(CFLAGS) cmplx.c

clog.obj: clog.c mconf.h
	cl $(CFLAGS) clog.c

const.obj: const.c mconf.h
	cl $(CFLAGS) const.c

cosh.obj: cosh.c mconf.h
	cl $(CFLAGS) cosh.c

drand.obj: drand.c mconf.h
	cl $(CFLAGS) drand.c

exp.obj: exp.c mconf.h
	cl $(CFLAGS) exp.c

exp10.obj: exp10.c mconf.h
	cl $(CFLAGS) exp10.c

exp2.obj: exp2.c mconf.h
	cl $(CFLAGS) exp2.c

fabs.obj: fabs.c mconf.h
	cl $(CFLAGS) fabs.c

log.obj: log.c mconf.h
	cl $(CFLAGS) log.c

log2.obj: log2.c mconf.h
	cl $(CFLAGS) log2.c

log10.obj: log10.c mconf.h
	cl $(CFLAGS) log10.c

mtherr.obj: mtherr.c mconf.h
	cl $(CFLAGS) mtherr.c

pow.obj: pow.c mconf.h
	cl $(CFLAGS) pow.c

powi.obj: powi.c mconf.h
	cl $(CFLAGS) powi.c

round.obj: round.c mconf.h
	cl $(CFLAGS) round.c

setprec.obj: setprec.87
	masm setprec.87;

sin.obj: sin.c mconf.h
	cl $(CFLAGS) sin.c

sindg.obj: sindg.c mconf.h
	cl $(CFLAGS) sindg.c

sinh.obj: sinh.c mconf.h
	cl $(CFLAGS) sinh.c

#sqrt.obj: sqrt.87
#	masm sqrt.87;

sqrt.obj: sqrt.c
	cl $(CFLAGS) sqrt.c

tan.obj: tan.c mconf.h
	cl $(CFLAGS) tan.c

tandg.obj: tandg.c mconf.h
	cl $(CFLAGS) tandg.c 

tanh.obj: tanh.c mconf.h
	cl $(CFLAGS) tanh.c

unity.obj: unity.c mconf.h
	cl $(CFLAGS) unity.c

fti.lib: acosh.obj asin.obj asinh.obj atan.obj atanh.obj \
cbrt.obj chbevl.obj clog.obj cmplx.obj const.obj cosh.obj \
drand.obj exp.obj exp2.obj exp10.obj fabs.obj floor.obj \
log.obj log2.obj log10.obj mtherr.obj polevl.obj \
pow.obj powi.obj round.obj sin.obj sindg.obj sinh.obj \
sqrt.obj setprec.obj tan.obj tandg.obj tanh.obj unity.obj \
mconf.h
	lib @ftilib.rsp

mtst.obj: mtst.c mconf.h
	cl /c mtst.c

mtst.exe: mtst.obj fti.lib
	link /noe mtst,,,fti.lib;
