@echo off
REM *****************************************************
REM *** ScrnSave.bat - Save screen contents to a file ***
REM *** ver.2                                         ***
REM *****************************************************

CEnviD %0.bat %1 %2
GOTO CENVI_EXIT

#include <Screen.lib>

main(argc,argv)
{
   if ( argc != 2  ||  !strcmpi(argv[1],"/?")  ||  !strcmpi(argv[1],"/help") )
      Instructions();
   else {
      ScreenLines = ReadScreen();
      WriteScreenLines(ScreenLines,argv[1]);
   }
}

Instructions()
{
   printf("\a\n")
   printf("ScrnSave - Save current ASCII screen to a file\n")
   printf("\n")
   printf("SYNTAX: ScrnSave <FileSpec>\n")
   printf("\n")
   printf("Where: FileSpec - Name of a file to capture screen to; if file then screen is\n")
   printf("                  appended to current file, else file is created\n")
   printf("\n")
   printf("\n")
   printf("Example: SCRNSAVE SCR.TXT\n")
   printf("\n")
}

ReadScreen()   // read in each line of the screen; clean lines so that
{              // 0 are blanks, no extra columns, and no extra lines, 1 at least
   ScreenWidth = ScreenSize().col;
   ScreenHeight = ScreenSize().row;

   // Read in each row
   BiggestValidRow = 0;

   RawScreenData = GetScreenData();
   for ( row = 0; row < ScreenHeight; row++ ) {
      memcpy(ScreenData[row],RawScreenData + row * ScreenWidth,ScreenWidth);
      CleanupScreenLine(ScreenData[row],ScreenWidth);
      if ( ScreenData[row][0] )
         BiggestValidRow = row;
   }

   // end this buffer at biggest valid row
   SetArraySpan(ScreenData,BiggestValidRow);
   return ScreenData;
}

CleanupScreenLine(pLine,pWidth)  // remove attribute, replace 0 with ' '
{                                // and no extra ' ' at end
   pLine[pWidth] = '\0';

   // Turn all 0 into ' '
   while ( lNullChar = memchr(pLine,'\0',pWidth) )
      lNullChar[0] = ' ';

   // Put a NULL character following the last non-blank character
   // Find first non-blank character
   lStr = pLine;
   for (;;) {
      // find next non-blank character
      if ( !(lNextStr = lStr + strspn(lStr," "))[0] ) {
         lStr[0] = '\0';
         break;   // found end of string, so lStr is at final blank
      }
      // now at a non-blank, so go to next blank
      if ( !(lStr = strchr(lNextStr,' ')) )
         break;
   }
}

WriteScreenLines(ScreenData,FileSpec) // write screen to file
{
   if ( !(fp = fopen(FileSpec,"at")) ) {
      printf("\aUnable to open file \"%s\" for appending.\n",FileSpec);
      abort();
   }

   LineCount = 1 + GetArraySpan(ScreenData);

   // Read in each row
   for ( row = 0; row < LineCount; row++ )
      fprintf(fp,"%s\n",ScreenData[row]);

   fclose(fp);
}


:CENVI_EXIT
