@echo off
::gif2desc 0.1, Copyright 1993 Richard Hempsey
::
:: a batch file/cenvi script that extracts the resolution and number of
:: colors in a GIF file, and puts it into a 4DOS descript.ion.

CEnviD gif2desc.bat %1 %2
GOTO CENVI_EXIT

p2[0]=1;
for(i=1;i<8;i++) p2[i]=p2[i-1]*2;

main(argc,argv)
{
    if(argc>2) {
        fprintf(stderr,"Usage: gif2desc [filespec]\n");
        exit(1);
    }

    if(argc==1)
        filespec="*.gif";
    else
        filespec=argv[1];

    temp=SplitFileName(filespec);

    descfile=temp.dir;
    strcat(descfile,"descript.ion");

    df=fopen(descfile,"w");
    if(df==NULL) {
        fprintf(stderr,"error: unable to open %s for writing\n",descfile);
        exit(1);
    }

    files=Directory(filespec,False,~FATTR_SUBDIR);
    if(files==NULL) {
        fprintf(stderr,"error: no files matching filespec %s\n",filespec);
        exit(1);
    }
    numfiles=1+GetArraySpan(files);

    for(i=0;i<numfiles;i++)
        ProcessFile(files[i].name,df);

    fclose(df);

    exit(0);
}

ProcessFile(filename,desc)
{
    gf=fopen(filename,"rb");
    if(gf==NULL) {
        fprintf(stderr,"error: could not open %s for reading.\n",filename);
        return;
    }

    temp=SplitFileName(filename);
    name=temp.name;
    strcat(name,temp.ext);

    fread(gif_id,6,gf);
    if(strcmp(gif_id,"GIF89a")==0)
        fprintf(desc,"%s g",name);
    else
        if(strcmp(gif_id,"GIF87a")!=0) {
            fclose(gf);
            return;
        }
        else
            fprintf(desc,"%s ",name);

    fread(ww,UWORD16,gf);
    fread(hh,UWORD16,gf);
    fread(bitfield,UWORD8,gf);
    colors=p2[(bitfield&0x07)+1];

    fprintf(desc,"%04dx%04dx%03d\n",ww,hh,colors);

    fclose(gf);
}

:CENVI_EXIT
iff %#==1 then ^ attrib +h %@path[%@full[%1]]descript.ion /q >&nul ^ *quit ^ endiff
iff %#==0 then ^ attrib +h descript.ion /q >&nul ^ *quit ^ endiff

