@echo off
REM *****************************************************************
REM *** FloppyID.bat - Get or set the ID from a floppy and store  ***
REM *** ver.2          in environment variable (if wanted)        ***
REM *****************************************************************

CEnviD %0.bat %1 %2 %3 %4 %5 %6 %7 %8 %9
GOTO CENVI_EXIT

main(argc,argv)
{
   if ( argc < 2  ||  4 < argc
     || strcmp( (drive=argv[1]) + 1, ":" )
     || !isalpha(drive[0])
     || (4 == argc && stricmp(argv[2],"SET")) ) {
      Instructions();
      return(EXIT_FAILURE);
   }

   if ( 4 == argc ) {
      // setting the volume ID
      if ( 2 != sscanf(argv[3],"%X-%X",SerialHigh,SerialLow) ) {
         printf("Unrecognized Volume Serial Number format \"%s\"\n\a",argv[3]);
         return(EXIT_FAILURE);
      }
      SetSerialNum(drive[0],SerialHigh << 16 | SerialLow);
   } else {
      // getting the volume ID
      EVar = ( argc == 3 ) ? argv[2] : NULL ;
      if ( EVar )
         putenv(EVar,NULL);

      // get serial number
      SerialNum = GetSerialNum(drive[0]);
      sprintf(SerialString,"%04X-%04X",(SerialNum >> 16) & 0xFFFF,SerialNum & 0xFFFF);
      printf("Serial number: %s\n",SerialString);

      if ( EVar )
         putenv(EVar,SerialString);
   }

   return(EXIT_SUCCESS);
}

Instructions()
{
   printf("\a\n")
   printf("FloppyID - Read disk serial number ID\n")
   printf("\n")
   printf("SYNTAX: FLOPPYID <d>: [EnvVar | SET <id>]\n")
   printf("\n")
   printf("Where: <d> Drive designation (e.g. A:, B:, etc...)\n")
   printf("       EnvVar - Optional environment variable to store ID\n")
   printf("       SET <id> - Set to id in hexadecimal form XXXX-XXXX\n")
   printf("\n")
   printf("Examples: FLOPPYID A:\n")
   printf("          FLOPPYID A: A_SERIAL\n")
   printf("          FLOPPYID A: SET E224-3815\n")
   printf("\n")
   printf("ERRORLEVEL: Sets ERRORLEVEL %d for error, %d if success\n",EXIT_FAILURE,EXIT_SUCCESS)
   printf("\n")
}

Function44Subfunction0D(pDriveLetter,pSubFunction,pBuffer)
{
   RegIn.ax = 0x440D;
   RegIn.bx = toupper(pDriveLetter) - 'A' + 1;
   RegIn.ch = 0x08;
   RegIn.cl = pSubFunction;
   RegIn.ds = segment(pBuffer);
   RegIn.dx = offset(pBuffer);
   if ( !interrupt(0x21,RegIn,RegOut) ) {
      printf("\aError %d on interrupt 0x21 subfunction 0x44\n",RegOut.ax);
      exit(EXIT_FAILURE);
   }
}

GetSerialNum(pDriveLetter)
{
   BLObSize(MediaBuffer,100);  // no reason not to be big
   BLObPut(MediaBuffer,0,0,UWORD16);
   Function44Subfunction0D(pDriveLetter,0x66,MediaBuffer);
   return( BLObGet(MediaBuffer,2,UWORD32) );
}

SetSerialNum(pDriveLetter,pSerialNum)
{
   BLObSize(MediaBuffer,100);  // no reason not to be big

   // get old media ID before setting new one
   BLObPut(MediaBuffer,0,0,UWORD16);
   Function44Subfunction0D(pDriveLetter,0x66,MediaBuffer);

   // set to new ID
   BLObPut(MediaBuffer,0,0,UWORD16);
   BLObPut(MediaBuffer,2,pSerialNum,UWORD32);
   Function44Subfunction0D(pDriveLetter,0x46,MediaBuffer);
}



:CENVI_EXIT
