@echo OFF
REM ***********************************************************
REM *** FileMDay.bat - Save FILE.TMP as FILE.XX where XX is ***
REM *** ver.1          yesterday's date.  Overwrite month-  ***
REM ***                old file with FILE.TMP               ***
REM ***********************************************************

REM *** exit if there is no FILE.TMP ***
IF EXIST FILE.TMP GOTO GET_FILE_DAY
ECHO FILE.TMP DOES NOT EXIST
GOTO BYE_BYE

:GET_FILE_DAY
REM *** set FILE_DAY name for yesterday's date ***
CEnviD strftime(FILE_DAY,"FILE.%%d",localtime(time()-86400))

REM *** if FILE_DAY doesn't exist then simply copy ***
REM *** FILE.TMP over FILE_DAY                     ***
IF EXIST %FILE_DAY% GOTO CHECK_FILE_DATE
ECHO NO FILE FROM LAST MONTH, COPY FILE.TMP TO %FILE_DAY%
COPY FILE.TMP %FILE_DAY%
GOTO BYE_BYE

:CHECK_FILE_DATE
REM *** if current FILE_DAY is more than two days ***
REM *** old then copy FILE.TMP over it            ***
CEnviD "exit(difftime(time(),Directory(`%FILE_DAY%`)[0].Write)/86400<2?1:0)"
IF ERRORLEVEL 1 GOTO NO_COPY

ECHO COPY FILE.TMP OVER OLD %FILE_DAY%
COPY FILE.TMP %FILE_DAY%
GOTO BYE_BYE

:NO_COPY
ECHO NO COPY.  ALREADY HAVE YESTERDAY'S FILE
GOTO BYE_BYE

:BYE_BYE
