@echo OFF
REM ****************************************************************
REM *** EnvSort.bat - Sort environment variables alphabetically. ***
REM *** ver.1         This works by writing a temporary batch    ***
REM ***               file to set all of the environment         ***
REM ***               variables in alphabetic order, then        ***
REM ***               removing the batch file.                   ***
REM ****************************************************************
ECHO SORTING ENVIRONMENT VARIABLES...


REM *** USE TEMP OR TMP VARIABLE TO FIND DIRECTORY ***
REM *** TO STORE TEMPORARY FILE                    ***
SET __BAT=.
IF NOT "%TMP%"=="" SET __BAT=%TEMP%
IF NOT "%TEMP%"=="" SET __BAT=%TEMP%
REM REMOVE BACKSLASH IF THERE IS ONE
CEnviD i=strlen(__BAT); if(__BAT[i-1]=='\\') __BAT[i-1]=0;
SET __BAT=%__BAT%\_ENVSORT.BAT

SET | CEnviD %0.bat
GOTO CENVI_EXIT

   // Build list of all environment variables
   Count = 0;
   while ( ELine = gets() )
      Lines[Count++] = ELine;

   // Sort variable lines
   qsort(Lines,Count,"strcmpi");

   // open temporary batch output file
   if ( !(fp = fopen(__BAT,"wt")) ) {
      printf("Error opening \"%s\" for writing.\a",__BAT);
      exit(EXIT_FAILURE);
   }

   // for each variable, write out to set to nothing
   for ( i = 0; i < Count; i++ ) {
      ELine = Lines[i];
      if ( Equal = strchr(ELine,'=') )
         fprintf(fp,"SET %.*s\n",Equal-ELine+1,ELine);
   }

   // write out all the variable lines to batch file
   for ( i = 0; i < Count; i++ )
      fprintf(fp,"SET %s\n",Lines[i]);

   // all done. close batch file
   fclose(fp);

:CENVI_EXIT

REM *** PLAY BACK THE TEMPORARY BATCH FILE; ALL DONE
CALL %__BAT%
DEL %__BAT%
SET __BAT=

REM *** ENVIRONMENT
