@echo off
REM ***********************************************************
REM *** EnviAsk.bat - Prompt user for value for to set into ***
REM *** ver.2         an environment variable.              ***
REM ***********************************************************

REM ********************************************************************
REM *** Build ALL_EASK_PARMS environment variable to all input parms ***
REM ********************************************************************

SET EASK_PARMS=%0.bat
:NEXT_ARG
   IF q%1q == qq GOTO NO_MORE_ARGS
   SET EASK_PARMS=%EASK_PARMS% %1
   SHIFT
   GOTO NEXT_ARG
:NO_MORE_ARGS

CEnviD %EASK_PARMS%
SET EASK_PARMS=
GOTO CENVI_EXIT

#include <OptParms.lib>

#define  NO_TIMEOUT  -100

// define MASK characters for characters in user input
#define  UPPER_CASE_CHAR      'A'
#define  LOWER_CASE_CHAR      'a'
#define  DIGIT                '#'
#define  CHAR_OR_DIGIT_UPPER  'X'
#define  CHAR_OR_DIGIT_LOWER  'x'
#define  ANYTHING             '?'
#define  ANYTHING_UPPER       'U'
#define  ANYTHING_LOWER       'l'

IntegerCmd = "INT";
EscapeCmd = "ESC";
TimeoutCmd = "TIME";
PromptCmd = "PROMPT";
MaskCmd = "MASK";
HideCmd = "HIDE";

main(argc,argv)
{
   success = False;
   undefine(EASK_PARMS);

   if ( argc < 3 ) {
      ShowInstructions();
      success = True;
   } else {
      // get the command line switches
      if ( !OptionalParameter(argc,argv,MaskCmd,Mask) )
         Mask = "";
      if ( !OptionalParameter(argc,argv,PromptCmd,Prompt) )
         Prompt = NULL;
      Timeout = OptionalParameter(argc,argv,TimeoutCmd,Temp) ? atoi(Temp) : NO_TIMEOUT;
      AllowEsc = OptionalParameter(argc,argv,EscapeCmd);
      IntegerOnly = OptionalParameter(argc,argv,IntegerCmd);
      HideChars = OptionalParameter(argc,argv,HideCmd);
      if ( argc != 4 ) {
         printf("Invalid command arguments. Enter /? for help.");
      } else {
         EnvironmentVar = argv[1];
         Min = atoi(argv[2]);
         Max = atoi(argv[3]);
         if ( Max < Min ) {
            printf("Invalid to have <Min> greater than <Max>");
         } else {
            if ( Input = Ask(getenv(EnvironmentVar),Min,Max,IntegerOnly,HideChars,
                             Mask,Prompt,Timeout,AllowEsc) ) {
               putenv(EnvironmentVar,Input);
               success = True;
            } /* endif */
         } /* endif */
      } /* endif */
   } /* endif */
   if ( !success )
      printf("\a");
   printf("\n");
   return( success ? EXIT_SUCCESS : EXIT_FAILURE );
}

   void
ShowInstructions(void)
{
   printf("\n");
   printf("EnviAsk: Ask user to input a value for an environment variable.\n");
   printf("\n");
   printf("SYNTAX: ENVIASK <EVar> <Min> <Max> [Options]\n");
   printf("Where:\n");
   printf("   EVar    - The Environment variable to set when selection is input, and the\n");
   printf("             initial selection if this variable had a value.\n");
   printf("   <Min>   - Minimum length of input string. If /%s option then this is the\n",IntegerCmd);
   printf("             minimum allowable value for the integer.\n");
   printf("   <Max>   - Maximum length of input string. If /%s option then this is the\n",IntegerCmd);
   printf("             maximum allowable value for the integer.\n");
   printf(" Options:\n");
   printf("   /%s    - An integer value must be input. <Min> and <Max> apply to the value\n",IntegerCmd);
   printf("             of the integer instead of the string length. Assume /%s %c%c%c%c...\n",MaskCmd,DIGIT,DIGIT,DIGIT,DIGIT);
   printf("   /%s str - Prompt <str> for keyboard entry; else there is no prompt.\n",PromptCmd);
   printf("   /%s    - If ESCAPE key is pressed, then exit with ErrorLevel; if no /%s\n",EscapeCmd,EscapeCmd);
   printf("             then a value MUST be input.\n");
   printf("   /%s - Hide input characters and display on *\n",HideCmd);
   printf("   /%s sec - <sec> seconds timeout for default selection if no user input.\n",TimeoutCmd);
   printf("   /%s str - <str> is a mask for validating the type of each character; <str>\n",MaskCmd);
   printf("             is of the form \"%c%c%c%c%c%c%c%c\", where character meanings are:\n",
                           UPPER_CASE_CHAR,LOWER_CASE_CHAR,DIGIT,CHAR_OR_DIGIT_UPPER,
                           CHAR_OR_DIGIT_LOWER,ANYTHING,ANYTHING_UPPER,ANYTHING_LOWER);
   printf("    %c - Characters 'A' to 'Z', converted to upper-case.\n",UPPER_CASE_CHAR);
   printf("    %c - Characters 'a' to 'z', converted to lower-case.\n",LOWER_CASE_CHAR);
   printf("    %c - Only the digits '0' to '9' are accepted.\n",DIGIT);
   printf("    %c - Digits '0' to '9', and characters 'A' to 'Z' (converted to upper-case).\n",CHAR_OR_DIGIT_UPPER);
   printf("    %c - Digits '0' to '9', and characters 'a' to 'z' (converted to lower-case).\n",CHAR_OR_DIGIT_LOWER);
   printf("    %c - Any character is acceptable.\n",ANYTHING);
   printf("    %c - Any character is acceptable; convert 'A' to 'Z' to upper case.\n",ANYTHING_UPPER);
   printf("    %c - Any character is acceptable; convert 'A' to 'Z' to lower case.\n",ANYTHING_LOWER);
}

Ask(InitialChoice,Min,Max,IntegerOnly,Hide,Mask,Prompt,Timeout,AllowEscape)
{  // return entered string, else NULL
   success = True;
   IsAnybodyThere = False;

   BigBuffer = InitAsk(Prompt,InitialChoice,Hide,row,colStart);
   PrevLen = strlen(BigBuffer);

   StartTime = time();

   for ( TotalSeconds = 0, Finished = False; !Finished; ) {

      // check if time has elapsed without any input
      if ( Timeout != NO_TIMEOUT  && !IsAnybodyThere ) {
         if ( Timeout < difftime(time(),StartTime) )
            break;
      } /* endif */

      if ( GetKey(Key) ) {
         IsAnybodyThere = True;
         switch ( Key.Scan ) {
            #define ENTER_SCAN   0x1c
            case ENTER_SCAN:
               if ( IntegerOnly ) {
                  if ( BigBuffer[0] != 0
                  && Min <= atoi(BigBuffer) && atoi(BigBuffer) <= Max )
                     Finished = True;
               } else {
                  if ( Min <= strlen(BigBuffer) && strlen(BigBuffer) <= Max )
                     Finished = True;
               } /* endif */
               break;
            #define UP_SCAN   0x48
            case UP_SCAN:
               if ( IntegerOnly && atoi(BigBuffer) < Max )
                  sprintf(BigBuffer,"%d",atoi(BigBuffer)+1);
               break;
            #define DOWN_SCAN 0x50
            case DOWN_SCAN:
               if ( IntegerOnly && Min < atoi(BigBuffer) )
                  sprintf(BigBuffer,"%d",atoi(BigBuffer)-1);
               break;
            #define LEFT_SCAN       0x4b
            #define BACKSPACE_SCAN  0x0e
            #define DEL_SCAN        0x53
            case LEFT_SCAN:
            case BACKSPACE_SCAN:
            case DEL_SCAN:
               if ( BigBuffer[0] != '\0' )
                  BigBuffer[strlen(BigBuffer)-1] = '\0';
               break;
            #define ESCAPE_SCAN  0x01
            case ESCAPE_SCAN:
               if ( AllowEscape ) {
                  success = False;
                  Finished = True;
               } else
                  BigBuffer[0] = 0;
               break;
            default:
               if ( Key.Char && (strlen(BigBuffer) < Max) ) {
                  MaybeAddNewCharacter(BigBuffer,Key.Char,IntegerOnly,Max,Mask);
               } /* endif */
               break;
         } /* endswitch */
         if ( strlen(BigBuffer) < PrevLen ) {
            // clear all positions from strlen(BigBuffer) to PrevLen
            ScreenCursor(colStart + PrevLen - 1,row);
            for ( i = strlen(BigBuffer); i < PrevLen; i++ ) {
               printf(" ");
            } /* endfor */
         } /* endif */
         // some key, any key, was entered so print the entire string
         ScreenCursor(colStart,row);
         if ( Hide ) {
            for ( ast = strlen(BigBuffer); ast--; )
               putchar('*');
         } else {
            printf("%s",BigBuffer);
         }
         PrevLen = strlen(BigBuffer);
      } /* endif */

   } /* endfor */

   return( success ? BigBuffer : NULL );
}

MaybeAddNewCharacter(BigBuffer,c,IntegerOnly,MaxInteger,Mask)
{
   buflen = strlen(BigBuffer);

   // Figure MaskChar to compare new value against
   if ( IntegerOnly ) {
      MaskChar = DIGIT;
   } else if ( Mask == NULL  ||  strlen(Mask) <= buflen ) {
      MaskChar = ANYTHING;
   } else {
      MaskChar = Mask[buflen];
   } /* endif */

   switch ( MaskChar ) {
   case UPPER_CASE_CHAR:
      valid = ( 'A' <= (c=toupper(c))  &&  c <= 'Z' );
      break;
   case LOWER_CASE_CHAR:
      valid = ( 'a' <= (c=tolower(c))  &&  c <= 'z' );
      break;
   case DIGIT:
      valid = ( '0' <= c  &&  c <= '9' );
      break;
   case CHAR_OR_DIGIT_UPPER:
      valid = ( ('A' <= (c=toupper(c))  &&  c <= 'Z')
             || ('0' <= c  &&  c <= '9') );
      break;
   case CHAR_OR_DIGIT_LOWER:
      valid = ( ('a' <= (c=tolower(c))  &&  c <= 'z')
             || ('0' <= c  &&  c <= '9') );
      break;
   default:
      printf("\nInvalid Mask Character %c\n",MaskChar);
   case ANYTHING:
      valid = True;
      break;
   case ANYTHING_UPPER:
      c = toupper(c);
      valid = True;
      break;
   case ANYTHING_LOWER:
      c = tolower(c);
      valid = True;
      break;
   } /* endswitch */

   if ( IntegerOnly && valid) {
      // may become invalid if this new value puts it out of range
      if ( MaxInteger < ((atoi(BigBuffer) * 10) + (c - '0')) ) {
         valid = False;
      } /* endif */
   } /* endif */

   if ( valid ) {
      BigBuffer[buflen+1] = 0;
      BigBuffer[buflen] = c;
   } /* endif */
}

InitAsk(Prompt,InitialChoice,Hide,row,colStart)
{
   // If there is a prompt then write it now
   if ( Prompt != NULL )
      printf("%s ",Prompt);

   // get current row and column of screen so know where to write to
   row = ScreenCursor().row;
   colStart = ScreenCursor().col;

   // Set Buf to InitialChoice
   strcpy(BigBuffer,(InitialChoice==NULL) ? "" : InitialChoice);
   if ( Hide ) {
      for ( ast = strlen(BigBuffer); ast--; )
         putchar('*');
   } else {
      printf("%s",BigBuffer);
   }
   return BigBuffer;
}


GetKey(pKey)
   // get key if one is avialable at keyboard; if no key then return False, else
   // return TRUE and set following fields: Scan, Char, Key (=scan and ascii)
{
   // see if a key is available
   reg.ah = 1;
   interrupt(0x16,reg);
   #define ZERO_FLAG 0x40
   if ( reg.flags & ZERO_FLAG )
      return False;

   // Get key from keyboard
   undefine(reg);
   reg.ah = 0;
   interrupt(0x16,reg);
   pKey.Key = reg.ax;
   pKey.Scan = reg.ah;
   pKey.Char = reg.al;
   return True;
}

:CENVI_EXIT
