EXTPROC CEnvi
/*****************************************************************
 *** WPFolder - open a directory as a folder in the workplace, ***
 *** ver.1      and switch to it unless told not to            ***
 *****************************************************************/

#include <PMdll.lib>

#define  NOSWITCH_CMD   "NOSWITCH"

main(argc,argv)
{
   if ( 3 < argc  ||  !strcmp(argv[1],"/?")  ||  !stricmp(argv[1],"/help") )
      Instructions();
   else
      // create for input folder or for current dir if no input folder
      CreateWPFolder( 2 <= argc ? argv[1] : ".",
                      (3 <= argc) ? stricmp(argv[2],NOSWITCH_CMD) : TRUE );
}

CreateWPFolder(PathSpec,SwitchRequested)
{
   // use the ValidSubdirectoryName() routine in ValidDir.cmd to check on dir name
   if ( !ValidDirectoryName(PathSpec,TRUE) ) {
      printf("\a\"%s\" is not a valid folder name\n",PathSpec);
   } else {
      // create object using full path name
      FullName = FullPath(PathSpec);
      sprintf(SetupString,"SHADOWID=%s;OPEN=DEFAULT;",FullName);
      // let the WinCreateObject() routin in PMdll.cmm call the dll
      handle = WinCreateObject("WPShadow",FullName,SetupString,
                               "<WP_NOWHERE>",CO_REPLACEIFEXISTS);
      if ( handle == NULL )
         printf("\aError creating workplace folder\n");
      else if ( SwitchRequested ) {
         // call the Switch.cmd command to switch to the selected folder
         FileParts = SplitFileName(FullName);
         system("start /C Switch.cmd %s%s",FileParts.name,FileParts.ext);
      }
   }
}

ValidDirectoryName(DirName)
   // test if DirName is a valid directory name.  Return TRUE if it is else FALSE.
{
   DirIsValid = FALSE; // assume failure
   FullDirName = FullPath(DirName);
   if ( NULL != FullDirName ) {
      // check for root dir, which is always valid
      if ( !strcmp(":\\",FullDirName+1) ) {
         DirIsValid = TRUE;
      } else {
         // append "\." to name to check for directory
         sprintf(TestDir,"%s\\.",FullDirName);
         if ( 0 != DirName[0]
           && '\\' != DirName[strlen(DirName)-1]
           && NULL != Directory(TestDir,FALSE,0xFFFF,FATTR_SUBDIR) ) {
            DirIsValid = TRUE
         }
      }
   }
   return(DirIsValid);
}

Instructions()
{
   printf("\n")
   printf("WPFolder - Create a Workplace Folder for a directory name\n")
   printf("\n")
   printf("SYNTAX: WPFOLDER [DirSpec [%s]]\n",NOSWITCH_CMD)
   printf("\n")
   printf("Where:  DirSpec  - specification for a file-system directory\n")
   printf("        NOSWITCH - if this is entered then do NOT switch to the folder\n")
   printf("\n")
   printf("Examples: WPFolder       - Create folder for the current directory\n")
   printf("          WPFolder C:\\   - Create folder for root drive of C:\n")
   printf("          WPFolder C:\\OS2\\DLL\n")
   printf("          WPFolder C:\\OS2\\DLL %s\n",NOSWITCH_CMD)
   printf("\n")
}

