EXTPROC CEnvi
//************************************************************************
//*** Session.cmd - Allow to start any type of session at any location ***
//*** ver.2         with any title and position.  Etc...  This could   ***
//***               be used in place of OS/2's START command.  And it  ***
//***               runs much quicker if you /BIND it.                 ***
//************************************************************************

// This is a list of Default DOS settings, change to what you like.  If
// left commented out then will retain system default.  Any values set
// here will be overwritten by value input at command line.  For those
// options where many text strings are avaialable, remove comments from
// ONE AND ONLY ONE of the choices

MyDefaultDOSSettings = {
   "COM_DIRECT_ACCESS=0",  // 0 or 1
   "COM_HOLD=0",           // 0 or 1
   "COM_RECEIVE_BUFFER_FLUSH="   // select one of the following
      //"ALL",
      //"RECEIVE DATA INTERRUPT ENABLE",
      //"SWITCH TO FOREGROUND",
      "NONE",
   "COM_SELECT="
      " ALL",
      //"COM1",
      //"COM2",
      //"COM3",
      //"COM4",
      //"NONE",
   "DOS_AUTOEXEC=C:\\AUTOEXEC.BAT",
   "DOS_BACKGROUND_EXECUTION=1", // 0 or 1
   "DOS_BREAK=1", // 0 or 1
   "DOS_DEVICE=SIZE=0  C:\\OS2\\MDOS\\ANSI.SYS",
   "DOS_FCBS=16",
   "DOS_FCBS_KEEP=8",
   "DOS_FILES=75",
   "DOS_HIGH=0",  // 0 or 1
   "DOS_LASTDRIVE=Z",
   "DOS_RMSIZE=640",
   "DOS_SHELL=C:\\OS2\\MDOS\\COMMAND.COM C:\\OS2\\MDOS",
   "DOS_UMB=0",   // 0 or 1
   "DOS_VERSION=DCJSS02.EXE,3,40,255"
      "\nDFIA0MOD.SYS,3,40,255"
      "\nDXMA0MOD.SYS,3,40,255"
      "\nEXCEL.EXE,10,10,4"
      "\nIBMCACHE.COM,3,40,255"
      "\nIBMCACHE.SYS,3,40,255"
      "\nISAM.EXE,3,40,255"
      "\nISAM2.EXE,3,40,255"
      "\nISQL.EXE,3,40,255"
      "\nMSD.EXE,5,00,255"
      "\nNET3.COM,3,40,255"
      "\nNETX.COM,4,00,255"
      "\nNETX.EXE,5,00,255"
      "\nPSCPG.COM,3,40,255"
      "\nSAF.EXE,3,40,255"
      "\nWIN200.BIN,10,10,4",
   "DPMI_DOS_API="   // select one of the following
      "AUTO",
      //"ENABLED",
      //"DISABLED",
   "DPMI_MEMORY_LIMIT=4",
   "DPMI_NETWORK_BUFF_SIZE=8",
   "EMS_FRAME_LOCATION="
      "AUTO",
      //"NONE",
      //"C000",
      //"C400",
      //"C800",
      //"CC00",
      //"D000",
      //"D400",
      //"D800",
      //"DC00",
      //"8000",
      //"8400",
      //"8800",
      //"8C00",
      //"9000",
   "EMS_HIGH_OS_MAP_REGION=0",
   "EMS_LOW_OS_MAP_REGION=384",
   "EMS_MEMORY_LIMIT=2048",
   "HW_NOSOUND=0",      // 0 or 1
   "HW_ROM_TO_RAM=0",   // 0 or 1
   "HW_TIMER=0",        // 0 or 1
   "IDLE_SECONDS=0",
   "IDLE_SENSITIVITY=75",
   "INT_DURING_IO=0",   // 0 or 1
   "KBD_ALTHOME_BYPASS=0", // 0 or 1
   "KBD_BUFFER_EXTEND=1",  // 0 or 1
   "KBD_CTRL_BYPASS="   // select one of the following
      "NONE",
      //"ALT_ESC",
      //"CTRL_ESC",
   "KBD_RATE_LOCK=0",   // 0 or 1
   "MEM_EXCLUDE_REGIONS=",
   "MEM_INCLUDE_REGIONS=",
   "MOUSE_EXCLUSIVE_ACCESS=0",   // 0 or 1
   "PRINT_SEPARATE_OUTPUT=1",    // 0 or 1
   "PRINT_TIMEOUT=15",
   "VIDEO_8514A_XGA_IOTRAP=1",   // 0 or 1
   "VIDEO_FASTPASTE=0",          // 0 or 1
   "VIDEO_MODE_RESTRICTION="  // select one of the following
      "NONE         ",
      //"CGA            ",
      //"MONO           ",
   "VIDEO_ONDEMAND_MEMORY=1",    // 0 or 1
   "VIDEO_RETRACE_EMULATION=1",  // 0 or 1
   "VIDEO_ROM_EMULATION=1",      // 0 or 1
   "VIDEO_SWITCH_NOTIFICATION=0",// 0 or 1
   "VIDEO_WINDOW_REFRESH=1",
   "XMS_HANDLES=32",
   "XMS_MEMORY_LIMIT=2048",
   "XMS_MINIMUM_HMA=0"
};

#define WINDOWS_EXECUTABLE    "WINOS2.COM"
#define DEFAULT_WINDOWS_PROG  "PROGMAN.EXE"
#define INTERVAL_BETWEEN_LOOKS   300   // how long to wait between checking if
                                       // window exists yet
#define MAXIMUM_LOOKS_FOR_WINDOW 50    // after looking 80 times for window,
                                       // then give up
#define WAIT_INTERVAL            1500  // how many milliseconds (approx.) to
                                       // wait between checking if session has
                                       // ended; if /WAIT specified

#include <OptParms.lib>    // for parsing command-line parameters
#include <Profile.lib>     // for getting and setting font size
#include <PMdll.lib>       // used by WinTools.lib
#include <WinTools.lib>    // adjust window size and position

main(argc,argv)
{
   if ( argc == 1
     || OptionalParameter(argc,argv,"?")
     || OptionalParameter(argc,argv,"help")
     || OptionalParameter(argc,argv,"h") ) {
      Instructions();
      success = False;
   } else {
      ParseInputParameters(argc,argv);
      StartData = BuildStartData();

      if ( Background )
         RememberActiveWindow = GetActiveWindow();

      if ( SetFont ) {
         GetCharacterFont(SaveWidth,SaveHeight);
         SetCharacterFont(FontX,FontY);
      }

      success = StartSession(StartData);

      if ( SetFont )
         SetCharacterFont(SaveWidth,SaveHeight);

      if ( success  && ( AdjustWindowAfterCreation || MustWait || TitleSupplied ) ) {
         // StartSession attempted to set these window settings, but
         // it probably failed.  If we can find the window Title
         // now, then use that window handle to set these things.
         if ( NULL == ( WinHandle = FindWindowHandle(Title,OldWindowList) ) ) {
            printf("\n\aUnable to locate \"%s\"\n",Title);
            success = False;
         } else if ( AdjustWindowAfterCreation ) {
            AdjustWindow(WinHandle);
         }
      }

      if ( Background )
         SetActiveWindow(RememberActiveWindow);

      if ( success && MustWait ) {
         // hang around until WinHandle is no longer valid
         do {
            suspend(WAIT_INTERVAL);
         } while ( IsWindow(WinHandle) );
      }

   }
   return success ? EXIT_SUCCESS : EXIT_FAILURE ;
}

ForeGround, BackGround;
Title; TitleSupplied;
InheritConfigSysEnvironment;
FullScreen, Windowed, PresentationManager, DOSApplication;
Windows, Enhanced, Separate;
IconFile;
Hidden, Maximized, Minimized, WantBig, Keep, MustWait;
WantSetPosition, PosX, PosY;
WantSetSize, SizeX, SizeY;
SetFont, FontX, FontY;
UseDosSettings;
ProgramName, ProgramInputs;
AdjustWindowAfterCreation;
#define ERROR_BUFFER_SIZE  300
ErrorBuffer[0] = ErrorBuffer[ERROR_BUFFER_SIZE+1] = '\0';

ParseInputParameters(argc,argv)
{
   ForeGround = OptionalParameter(argc,argv,"F");
   BackGround = OptionalParameter(argc,argv,"B");
   Title = NULL; TitleSupplied = OptionalParameter(argc,argv,"TITLE",Title);
   InheritConfigSysEnvironment = OptionalParameter(argc,argv,"I");
   FullScreen = OptionalParameter(argc,argv,"FS");
   Windowed = OptionalParameter(argc,argv,"WIN");
   PresentationManager = OptionalParameter(argc,argv,"PM");
   DosApplication = OptionalParameter(argc,argv,"DOS");
   Enhanced = OptionalParameter(argc,argv,"ENH");
   Separate = OptionalParameter(argc,argv,"SEP");
   Windows = OptionalParameter(argc,argv,"W")
          || Separate || Enhanced ;
   IconFile = NULL; OptionalParameter(argc,argv,"ICON",IconFile);
   Hidden = OptionalParameter(argc,argv,"HID");
   Maximized = OptionalParameter(argc,argv,"MAX");
   Minimized = OptionalParameter(argc,argv,"MIN");
   WantBig = OptionalParameter(argc,argv,"BIG");
   Keep = OptionalParameter(argc,argv,"K");
   MustWait = OptionalParameter(argc,argv,"WAIT");
   WantSetPosition = ( OptionalParameter(argc,argv,"POS",string)
                  && ScanfRowCol(string,PosX,PosY) );
   WantSetSize = ( OptionalParameter(argc,argv,"SIZE",string)
                && ScanfRowCol(string,SizeX,SizeY) );
   SetFont = ( OptionalParameter(argc,argv,"FONT",string)
            && ScanfRowCol(string,FontY,FontX) );
   UseDosSettings = DosApplication || Windows;
   while ( OptionalParameter(argc,argv,"SET",string) ) {
      UseDosSettings = True;
      switch ( string[0] ) {
         case '@':
            GetSettingsFromFile(string+1);
            break;
         case '#':
            GetSettingsFromEnvironmentVariable(string+1);
            break;
         default:
            AddNewSetting(string);
            break;
      }
   }

   AdjustWindowAfterCreation = ( ForeGround & !Windows )
                            || Hidden || Maximized || WantBig
                            || Minimized|| WantSetPosition || WantSetSize ;

   // any further arguments are the ProgramName and ProgramInputs
   ProgramName = (argc == 1) ? NULL : argv[1] ;
   if ( argc < 3 ) {
      ProgramInputs = NULL;
   } else {
      // build program input string of all further arguments together
      strcpy(ProgramInputs,argv[2]);
      for ( i = 3; i < argc; i++ ) {
         strcat(ProgramInputs," ");
         strcat(ProgramInputs,argv[i]);
      }
   }

   if ( Windows ) {
      // Windows needs a default program, so use Program Manager
      if ( NULL == ProgramName )
         ProgramName = DEFAULT_WINDOWS_PROG;
   }

   if ( !Title ) {
      // YUCK!!! No one likes a session with no title. So give it one.
      // Title will be all but path of ProgramName.  But if no program
      // name then will match the sesion type.
      if ( ProgramName != NULL ) {
         strcpy(Title,ProgramName + strlen(SplitFileName(ProgramName).dir));
      }
      if ( !Title || !Title[0] ) {
         // Get name from session type
         if ( UseDosSettings ) Title = "DOS Session";
         else if ( Windows ) Title = "Windows Session";
         else if ( PresentationManager ) Title = "PM Session";
         else Title = "Session";
      }
   }

}

ScanfRowCol(string,Row,Col)  // scan ROWxCOL or ROWXCOL or ROWxCOL, or return FALSE
{
   return( 2 == sscanf(string,"%dx%d",Row,Col)
        || 2 == sscanf(string,"%dX%d",Row,Col)
        || 2 == sscanf(string,"%d,%d",Row,Col) );
}

MyDefaultDOSSettings;

AddNewSetting(setting)
   // add setting string to MyDefaultDOSSettings, or replace one that is
   // already there if it has the same "NAME=VALUE" name
{
   // Find the length of variable name: all characters before '='
   VarLen = strcspn(setting,"=");
   if ( 0 == VarLen  ||  strlen(setting) == VarLen ) {
      printf("\n\aInvalid setting \"%s\" ignored.",setting);
      printf("\nPress any key to continue...");
      getch();
      printf("\n");
   } else {
      SettingIndex = 0;
      if ( defined(MyDefaultDOSSettings) ) {
         // check existing settings if this is already in the list
         MaxSettingIndex = GetArraySpan(MyDefaultDOSSettings);
         for( ; SettingIndex <= MaxSettingIndex; SettingIndex++ ) {
            if ( !memicmp(MyDefaultDOSSettings[SettingIndex],setting,
                          VarLen+1) )
               break;
         }
      }
      strcpy(MyDefaultDOSSettings[SettingIndex],setting);
   }
}

GetSettingsFromFile(FileName)
   // read in each setting line from file, and add to DOS settings
{
   fp = fopen(FileName,"r");
   if ( NULL == fp ) {
      printf("\n\aUnable to open settings file \"%s\"",FileName);
      printf("\nPress any key to continue...");
      getch();
      printf("\n");
   } else {
      while ( NULL != (setting = fgets(fp)) ) {
         if ( '\n' == setting[len = strlen(setting) - 1] )
            setting[len] = 0;
         if ( ';' != setting[0]  &  '\0' != setting[0] )
            AddNewSetting(setting);
      }
      fclose(fp);
   }
}

GetSettingsFromEnvironmentVariable(evar)
   // get settings from environment variable, if there is one.  Individual
   // setting statements are separated by semi-colons
{
   if ( NULL != (string = getenv(evar)) ) {
      for ( NextString = strtok(string,";");
            NULL != NextString; NextString = strtok(NULL,";") ) {
         if ( NULL != (EqualPosition = strchr(NextString,',')) ) {
            EqualPosition[0] = '=';
            AddNewSetting(NextString);
         }
      }
   }
}

DetermineSessionType()
   // return integer representing the TYPE of session to start
{
   #define SESSION_DEFAULT             0
   #define SESSION_OS2_FULLSCREEN      1
   #define SESSION_WINDOWABLEVIO       2
   #define SESSION_PM                  3
   #define SESSION_DOS_FULLSCREEN      4
   #define SESSION_DOS_WINDOWED        7
   #define SESSION_WIN_STD_SEPARATE    15
   #define SESSION_WIN_STD             16
   #define SESSION_WIN_ENH_SEPARATE    17
   #define SESSION_WIN_ENH             18
   #define SESSION_WIN_ENH_FULLSCREEN  19
   #define SESSION_WIN_STD_FULLSCREEN  20

   #define PROG_DEFAULT             (PROGCATEGORY)0
   #define PROG_FULLSCREEN          (PROGCATEGORY)1
   #define PROG_WINDOWABLEVIO       (PROGCATEGORY)2
   #define PROG_PM                  (PROGCATEGORY)3
   #define PROG_GROUP               (PROGCATEGORY)5
   #define PROG_REAL                (PROGCATEGORY)4
   #define PROG_VDM                 (PROGCATEGORY)4
   #define PROG_WINDOWEDVDM         (PROGCATEGORY)7
   #define PROG_DLL                 (PROGCATEGORY)6
   #define PROG_PDD                 (PROGCATEGORY)8
   #define PROG_VDD                 (PROGCATEGORY)9
   #define PROG_WINDOW_REAL         (PROGCATEGORY)10
   #define PROG_WINDOW_PROT         (PROGCATEGORY)11
   #define PROG_WINDOW_AUTO         (PROGCATEGORY)12
   #define PROG_SEAMLESSVDM         (PROGCATEGORY)13
   #define PROG_SEAMLESSCOMMON      (PROGCATEGORY)14
   #define PROG_RESERVED            (PROGCATEGORY)255

   if ( PresentationManager ) return SESSION_PM;
   if ( Windows ) {
      if ( Separate )
         return Enhanced ? SESSION_WIN_ENH_SEPARATE : SESSION_WIN_STD_SEPARATE;
      if ( FullScreen )
         // return Enhanced ? SESSION_WIN_ENH_FULLSCREEN : SESSION_WIN_STD_FULLSCREEN;
         return SESSION_DOS_FULLSCREEN;
      return Enhanced ? SESSION_WIN_ENH : SESSION_WIN_STD;
   }
   if ( UseDosSettings ) {
      return ( Windowed && !FullScreen )
           ? SESSION_DOS_WINDOWED : SESSION_DOS_FULLSCREEN ;
   }
   if ( FullScreen ) return SESSION_OS2_FULLSCREEN;
   if ( Windowed ) return SESSION_WINDOWABLEVIO;
   return SESSION_DEFAULT;
}

GetDOSSettingsString()
   // return MyDefaultDOSSettings() array as a large string where each
   // element is separaterd by a NULL byte
{
   string = SettingString = "";
   count = GetArraySpan(setting = MyDefaultDOSSettings);
   while( 0 <= count-- ) {
      strcpy(string,setting[0]);
      string += strlen(string) + 1;
      setting++;
   }
   string[0] = '\0';
   return SettingString;
}


PgmName, PgmInputs, env; // globals used in following function
BuildStartData()
   // Build the StartData structure (BLOb) based on the global data already
   // retrieved.  Return the blob
{
   BLObPut(data,0,UWORD16); // size of block; we'll get back to this
      #define SSF_RELATED_INDEPENDENT 0
      #define SSF_RELATED_CHILD       1
   BLObPut(data,SSF_RELATED_INDEPENDENT,UWORD16);
      #define SSF_FGBG_FORE   0
      #define SSF_FGBG_BACK   1
   BLObPut(data,ForeGround ? SSF_FGBG_FORE : SSF_FGBG_BACK,UWORD16);
      #define SSF_TRACEOPT_NONE       0
      #define SSF_TRACEOPT_TRACE      1
      #define SSF_TRACEOPT_TRACEALL   2
   BLObPut(data,SSF_TRACEOPT_NONE,UWORD16);
   if ( Windows  &&  NULL != Title && !Fullscreen ) {
      sprintf(Title-8,"Session:%s",Title);
      BLObPut(data,pointer(Title)-8,UWORD32);
   }
   else
      BLObPut(data,Title ? pointer(Title) : NULL,UWORD32);

   // Preform a cheat here with the ProgramName and inputs so that
   // windows programs will be started by WINOS2.COM and be set
   // to enhanced mode if that is wanted
   if ( Windows ) {
      PgmName = WINDOWS_EXECUTABLE;
      if ( NULL == ProgramInputs )
         PgmInputs = ProgramName;
      else
         sprintf(PgmInputs,"%s %s",ProgramName,ProgramInputs);
      if ( Enhanced ) {
         // Add /3 to parameters to start in enhanced mode
         if ( NULL == PgmInputs )
            PgmInputs = "/3";
         else
            sprintf(PgmInputs,"/3 %s",PgmInputs);
      }
   } else {
      PgmName = ProgramName;
      PgmInputs = ProgramInputs;
   }

   BLObPut(data,PgmName ? pointer(PgmName) : NULL,UWORD32);
   BLObPut(data,PgmInputs ? pointer(PgmInputs) : NULL,UWORD32);

   BLObPut(data,NULL,UWORD32);  // no termination queue
   if ( UseDosSettings  &&  defined(MyDefaultDOSSettings) ) {
      env = GetDOSSettingsString();
      BLObPut(data,pointer(env),UWORD32);
   } else {
      BLObPut(data,NULL,UWORD32);  // no environment setting
   }
      #define SSF_INHERTOPT_SHELL     0
      #define SSF_INHERTOPT_PARENT    1   // for DOS session, inherit drive and directory
   BLObPut( data,
            InheritConfigSysEnvironment ? SSF_INHERTOPT_SHELL : SSF_INHERTOPT_PARENT,
            UWORD16 );
   BLObPut(data,DetermineSessionType(),UWORD16);
   BLObPut(data,IconFile ? pointer(IconFile) : NULL,UWORD32);
   BLObPut(data,NULL,UWORD32);  // no program handle

   #define SSF_CONTROL_VISIBLE     0x0000
   #define SSF_CONTROL_INVISIBLE   0x0001
   #define SSF_CONTROL_MAXIMIZE    0x0002
   #define SSF_CONTROL_MINIMIZE    0x0004
   #define SSF_CONTROL_NOAUTOCLOSE 0x0008
   #define SSF_CONTROL_SETPOS      0x8000
   PgmControl = 0;
   if ( Hidden ) PgmControl |= SSF_CONTROL_INVISIBLE;
   if ( Maximized ) PgmControl |= SSF_CONTROL_MAXIMIZE;
   if ( Minimized ) PgmControl |= SSF_CONTROL_MINIMIZE;
   if ( Keep ) PgmControl |= SSF_CONTROL_NOAUTOCLOSE;
   if ( WantSetPosition || WantSetSize ) PgmControl |= SSF_CONTROL_SETPOS;
   BLObPut(data,PgmControl,UWORD16);

   if ( !WantSetPosition ) PosX = PosY = 0;
   if ( !WantSetSize ) SizeX = SizeY = 0;
   BLObPut(data,PosX,SWORD16);
   BLObPut(data,PosY,SWORD16);
   BLObPut(data,SizeX,SWORD16);
   BLObPut(data,SizeY,SWORD16);
   BLObPut(data,0,SWORD16);      // reserved byte; required

   BLObPut(data,pointer(ErrorBuffer),UWORD32);
   BLObPut(data,ERROR_BUFFER_SIZE,UWORD32);

   BLObPut(data,0,BLObSize(data),UWORD16); // size of block
   return data;
}

StartSession(StartData)
   // call OS/2 start session functions
{
   #define ORD_DOS32STARTSESSION 37
   rc = DynamicLink("SESMGR",ORD_DOS32STARTSESSION,BIT32,CDECL,
                    StartData,DummySessionID,DummyProcessID);

   #define ERROR_SMG_START_IN_BACKGROUND   457
   if ( rc  &&  ERROR_SMG_START_IN_BACKGROUND != rc ) {
      printf("Error %d starting session\a\a\n",rc);
      if ( 0 < strlen(ErrorBuffer) )
         printf("Error in object: %s\n",ErrorBuffer);
      return(False);
   }
   return(True);
}

GetCharacterFont(FontWidth,FontHeight)
{
   // Get current size
   BLObSize(current,2);
   PrfQueryProfileData(HINI_USERPROFILE,"Shield","~Font Size...",current,2);
   FontHeight = BLObGet(current,1,UWORD8);
   FontWidth = BLObGet(current,0,UWORD8);
}

SetCharacterFont(FontWidth,FontHeight)
{
   BLObPut(new,0,FontWidth,UWORD8);
   BLObPut(new,1,FontHeight,UWORD8);
   PrfWriteProfileData(HINI_USERPROFILE,"Shield","~Font Size...",new,2);
}

FindWindowHandle(WindowTitle,OldWindowList)
   // Wait around for a while for a new window with this WindowTitle.
   // return NULL if not found
{
   for ( retry = MAXIMUM_LOOKS_FOR_WINDOW; retry;
         retry--, suspend(INTERVAL_BETWEEN_LOOKS) ) {
      if ( NULL != (NewHandle = GetWindowHandle(WindowTitle)) )
         return(NewHandle);
   }
   return(NULL);
}

AdjustWindow(hwnd)
{
   if ( WantBig || Maximized ) {
      ShowWindow(hwnd,ForeGround ? SW_SHOWMAXIMIZED : SW_SHOWMAXNOACTIVE);
      if ( WantBig ) {
         // get maximized size, then restore but at maximum size
         GetWindowRect(hwnd,rect);
         ShowWindow(hwnd,ForeGround ? SW_RESTORE : SW_RESTORENOACTIVE);
         SetWindowRect(hwnd,rect);
      }
   }
   if ( Minimized )
      ShowWindow(hwnd,ForeGround ? SW_SHOWMINIMIZED : SW_SHOWMINNOACTIVE);
   if ( ForeGround )
      SetActiveWindow(hwnd);
   if ( WantSetSize ) {
      if ( WantSetPosition )
         SetWindowPos(hwnd,0,PosX,PosY,SizeX,SizeY,SWP_SIZE | SWP_MOVE);
      else
         SetSize(hwnd,SizeX,SizeY);
   } else if ( WantSetPosition )
      SetPosition(hwnd,PosX,PosY);
   if ( Hidden )
      ShowWindow(hwnd,SW_HIDE);
}

Instructions()
{
   printf("\n")
   printf("Session - Start a session\n")
   printf("\n")
   printf("SYNTAX: Session [Options] Command [Command arguments...]\n")
   printf("\n")
   printf("Options: /F - Start session in the foreground\n")
   printf("         /B - Start session in the background\n")
   printf("         /TITLE \"Program Title\" - Session Title\n")
   printf("            For Windows sessions this is title windows will give\n")
   printf("         /I - Inherit environment of CONFIG.SYS, not current settings\n")
   printf("         /FS - Full-Screen DOS, OS/2, or Windows session\n")
   printf("         /WIN - Windowed DOS, OS/2, or Windows session\n")
   printf("         /PM - Presentation Manager application\n")
   printf("         /DOS - DOS application\n")
   printf("         /W - Windows application\n")
   printf("         /SEP - Separate Windows session (for /W)\n")
   printf("                Always Searate sessions in this version\n")
   printf("         /ENH - Enhanced-mode Windows session\n")
   printf("         /ICON FileSpec - Full name of an Icon file\n")
   printf("         /HID - Window initially hidden\n")
   printf("         /MAX - Initially maximized\n")
   printf("         /MIN - Initially minimized\n")
   printf("         /BIG - Not maximized, but at maximum size\n")
   printf("         /K - Keep Windowed session open after program completes\n")
   printf("         /WAIT - Wait until session ends\n")
   printf("         /POS X,Y - Set the X and Y position\n")
   printf("         /SIZE X,Y - Set the width (X) and height (Y) of session\n")
   printf("         /FONT YxX - Set Height (Y) and Width (X) of DOS or OS/2 windowed font\n")
   printf("         /SET SET=VALUE - Dos Settings, any number of these allowed\n")
   printf("         /SET @FileSpec - Get DOS settings from FileSpec, except blank and ';' lines\n")
   printf("         /SET #ENVVAR - Get DOS settings from environment variable <ENVVAR>\n")
   printf("              where values in NAME,VAL;NAME,VAL format\n")
   printf("\n")
   printf("NOTE: SESSION.CMD contains a list of default DOS settings.  You may want to\n")
   printf("      alter these by editing SESSION.CMD and change MyDefaultDOSSettings\n")
   printf("      DOS settings are only specified for session if the /DOS, /W, or /SET\n")
   printf("\n")
   printf("      If command arguments take any of the same flags as SESSION.CMD then you\n")
   printf("      May want to include those in quotes and with spaces.  For example:\n")
   printf("          SESSION /WIN CMD.EXE \"/K mode 80,50\"\n")
}

