EXTPROC CEnvi
//******************************************************************
//*** DOS_Echo.cmd - Demonstration of DOS_Boss.lib.  This starts ***
//*** ver.1          a DOS window and echos everything on it.    ***
//******************************************************************

#include <PMdll.lib>
#include <WinTools.lib>
#include <ClipBrd.lib>
#include <FileIO.lib>
#include <NamePipe.lib>
#include <DOS_Boss.lib>

DosSessionName = "DOS Echo Source";

// Start a DOS session in the background
system("mode 80,26");
system("start \"%s\" /WIN /DOS /B command.com /C mode 80,25",DosSessionName);
//system("session /WIN /DOS /F /Title \"DOS Echo Source\" /SET DPMI_DOS_API=ENABLED command.com \"/K mode 80,25\"");
suspend(3000);

printf("\nDOS_Echo has started a DOS windowed session named \"%s\"\n",DosSessionName);
printf("DOS_Echo will now attempt to control that DOS session so that what you\n");
printf("type HERE will be typed THERE, and what is displayed THERE will be\n");
printf("displayed HERE.  The effect should be of a VERY SLOW DOS WINDOW.  For\n");
printf("this illusion to work, this OS/2 has been set to 26 lines, and that DOS\n");
printf("session is at 25 lines.  This will work best if that DOS session is visible\n");
printf("and this OS/2 session remains in the foreground.\n");
printf("\n");
printf("You may edit that DOS window with keystrokes here, or keystrokes there.  But\n");
printf("function keys will only be recognized THERE\n");
printf("\n");
printf("When \"%s\" is visible, press any key...",DosSessionName);
getch();
printf("\n");

DosWindowHandle = GetWindowHandle(DosSessionName);
if ( NULL == DosWindowHandle ) {
   printf("Could not locate DOS session named \"%s\"\n",DosSessionName);
   abort();
}

PasteToDOSWindow(DosWindowHandle,"ServeOS2 DOS_ECHO\r");

// initialize data to compare when it has changed
PreviousData = "";
PreviousLen = 0;

while ( IsWindow(DosWindowHandle) ) {

   // If keys are available, then send them to the window
   if ( kbhit() ) {
      KeysLen = 0;
      do {
         if ( 0 == (Keys[KeysLen] = byte(getch())) ) {
            // extended key, so send any existing ascii string, then
            // send just this extended key
            if ( KeysLen ) {
               Keys[KeysLen] = '\0';
               SendDosKey("DOS_ECHO",Keys);
            }
            SendDosKey("DOS_ECHO",getch() << 8);
            KeysLen = 0;
         } else {
            KeysLen++;
         }
      } while( kbhit() );
      if ( KeysLen ) {
         Keys[KeysLen] = '\0';
         SendDosKey("DOS_ECHO",Keys);
      }
   }

   // Read the text in the window, if it has changed
   Data = ReadDOSWindow(DosWindowHandle,DataLen);
   if ( NULL != Data
     && ( PreviousLen != DataLen || memcmp(Data,PreviousData,DataLen) ) ) {
      Lines = CopyDOSBufferToLines(Data,LineCount);
      for ( row = 0; row < 25; row++ ) {
         ScreenCursor(0,row);
         printf("%-80.80s",Lines[row]);
      }
      PreviousLen = DataLen;
      PreviousData = Data;
   }

   suspend(250);

}
