EXTPROC CEnvi2
//***************************************************************************
//*** WinTools.cmd - CEnvi2 demonstration program to show the capabilities ***
//*** ver.1          of the WinTools.lib functions.                       ***
//***************************************************************************

#include <Pmdll.lib>
#include <WinTools.lib>

printf("Moving CEnvi2 text window to middle of the screen...");

// Save current dimensions of CEnvi2 window
GetWindowRect(Info().WinHandle,SavePosition);
SaveMaximized = IsMaximized(Info().WinHandle);

// Try to change size of CEnvi2 window so that it is 1/4 screen height and full width
// PM might make it LESS than this size
GetScreenSize(ScreenWidth,ScreenHeight);
SetSize(Info().WinHandle,ScreenWidth,ScreenHeight / 4);

// Center CEnvi2 window in the screen
GetSize(Info().WinHandle,width,height);
printf("Set to %d %d\n",(ScreenWidth - width) / 2,(ScreenHeight - height) / 2);
SetPosition(Info().WinHandle,(ScreenWidth - width) / 2,(ScreenHeight - height) / 2);

// Add lots of lines to make sure we can read the new lines on the screen
for ( i = ScreenSize().row; i; i-- )
   printf("\n");

// Start up E.EXE
printf("\nStarting E.EXE...");
if ( IsWindow("e.exe") ) {
   printf("\n\n\aERROR: E.EXE must NOT be running to run this test.");
   printf("\nPress any key to quit...");
   getch();
   exit(1);
}
system("Start /F /N E.EXE");
// Wait for e.exe to exist
while ( !IsWindow("e.exe") )
   suspend(100);

// Restore this CEnvi2 screen as the active one
SetActiveWindow(Info().WinHandle);

printf("\nPress any key to move E.EXE to upper-left corner...");
getch();
GetSize("e.exe",width,height);
SetPosition("e.exe",0,ScreenHeight - height);

printf("\nPress any key to move E.EXE to bottom-right corner...");
getch();
SetPosition("e.exe",ScreenWidth - width,0);

printf("\nPress any key to fit E.EXE in top center...");
getch();
// make 1/2 width of screen height and width, and center at top
SetSize("e.exe",ScreenWidth / 2,ScreenHeight / 2);
SetPosition("e.exe",ScreenWidth / 4,ScreenHeight / 2);


printf("\nPress any key to hide E.EXE...");
getch();
ShowWindow("e.exe",SW_HIDE);

printf("\nPress any key to show E.EXE...");
getch();
ShowWindow("e.exe",SW_SHOWNOACTIVATE);

printf("\nPress any key to minimize E.EXE...");
getch();
ShowWindow("e.exe",SW_MINIMIZE);

printf("\nPress any key to maximize E.EXE...");
getch();
ShowWindow("e.exe",SW_SHOWMAXNOACTIVE);

printf("\nPress any key to restore E.EXE...");
getch();
ShowWindow("e.exe",SW_RESTORENOACTIVE);

printf("\nDemo done, but E.EXE needs a new title.");
printf("\nTerminate E.EXE, or press key here to exit....");

// Make e.exe the active window
SetActiveWindow("e.exe");

// Will change the title, so save the window handle here
EHandle = GetWindowHandle("e.exe");

// Finally, as long as e.exe exists, rotate the advertisement
NewTitle = "  I like CEnvi.    CEnvi is swell!    Thank you, Nombas.  ";
TitleLen = strlen(NewTitle);
while( IsWindow(EHandle)  &&  !kbhit() ) {
   // set to new title
   SetWindowTitle(EHandle,NewTitle);
   // rotate title one character left
   NewLastChar = NewTitle[0];
   strcpy(NewTitle,NewTitle + 1);
   NewTitle[TitleLen-1] = NewLastChar;
   suspend(100);
}

// Restore dimensions of CEnvi2 window
printf("\nbye bye");
if ( SaveMaximized )
   ShowWindow(Info().WinHandle,SW_SHOWMAXNOACTIVE);
SetWindowRect(Info().WinHandle,SavePosition);

// If window is still running then close it
CloseWindow(EHandle);

