EXTPROC CEnvi2
/**************************************************************************
 *** DoMenu.cmd - Quick interface to pass menu commands directly.       ***
 *** ver.3        This posts menu command directly to any frame window. ***
 **************************************************************************/

#include <MenuCtrl.lib>
#include <WinTools.lib>
#include <OptParms.lib>

main(argc,argv)
{
   FullMatch = OptionalParameter(argc,argv,"FULL");

   if ( (2 != argc && 3 != argc)  ||  !strcmp(argv[1],"/?")  ||  !strcmpi(argv[1],"help") )
      Instructions();

   if ( 2 == argc ) {
      hwnd = GetActiveWindow();
      MenuString = argv[1];
   } else {
      if ( !(hwnd = GetWindowHandle(WindowTitle = argv[1])) ) {
         printf("\aCould not find window \"%s\"\n",WindowTitle);
         exit(EXIT_FAILURE);
      }
      MenuString = argv[2];
   }
   // try regular menu first, then system menu, then anything else
   if ( !MenuCommand(hwnd,FID_MENU,MenuString,True,Dummy,FullMatch)
     && !MenuCommand(hwnd,FID_SYSMENU,MenuString,True,Dummy,FullMatch)
     && !MenuCommand(hwnd,0,MenuString,True,Dummy,FullMatch) ) {
      printf("\aSelection \"%s\" not found in any menu.\n",MenuString);
      exit(EXIT_FAILURE);
   }
   return EXIT_SUCCESS;
}


Instructions()
{
   puts("\a")
   puts(`DoMenu - Post menu selection to a PM window`)
   puts(``)
   puts(`SYNTAX: DoMenu <WinTitle> <MenuString> [/FULL] `)
   puts(``)
   puts(`Where: WinTitle - Name of a window; if this parameter not supplied then`)
   puts(`                  use currently active window`)
   puts(`       MenuString - Ascii text of menu string to select from any menu.`)
   puts(`                    Will select first match for length of MenuString,`)
   printf("                    case-insensitive`.  If you include the sequence \"%s\"\n",gSubmenuBranch)
   printf("                    then the %s characters specify the sub-menu path to take\n",gSubmenuBranch)
   puts(`       /FULL - With this option, will only accept menu item that matches`)
   puts(`               <MenuString> for the full length of <MenuString>`)
   puts(``)
   puts(`Example: If the calculator is running, this would set font to 18 x 10`)
   puts(`            DoMenu Calculator "18 x 10"`)
   puts(``)
   puts(`Example: If an "OS/2 Window" session is active, to choose "Copy All"`)
   puts(`            DoMenu "Copy All"`)
   puts(`         In E.EXE, to save file use one of the following`)
   puts(`            DoMenu E.EXE Save /FULL`)
   puts(`            DoMenu E.EXE File##Save /FULL`)
   puts(``)
   exit(EXIT_FAILURE);
}

