EXTPROC CEnvi2
//*********************************************
//*** DeskLock.cmd - Lock or unlock desktop ***
//*** ver.1                                 ***
//*********************************************

main(argc,argv)
{
   if ( argc == 2   &&  !stricmp(argv[1],"LOCK") ) {
      success = WinLockupSystem(PMInfo().hab);
   } else if ( argc == 3  &&  !stricmp(argv[1],"UNLOCK") ) {
      Password = argv[2];
      success = WinUnlockSystem(PMInfo().hab,Password);
   }
   else {
      success = False;
      Instructions();
   }
   return success ? EXIT_SUCCESS : EXIT_FAILURE ;
}

Instructions()
{
   puts("\a")
   puts("DeskLock - Lock or UnLock OS/2 desktop")
   puts("")
   puts("USAGE: DeskLock [ LOCK | UNLOCK <password> ]")
   puts("")
   puts("WHERE: LOCK - Lockup desktop")
   puts("       UNLOCK - Unlock desktop")
   puts("       password - Password for unlocking")
   puts("")
   printf("ERRORLEVEL: Return ERRORLEVEL %d for success, else %d\n",EXIT_SUCCESS,EXIT_FAILURE);
   puts("")
}

WinLockupSystem(pHab)
{
   #define ORD_WIN32LOCKUPSYSTEM 283
   return PMDynamicLink("PMWP",ORD_WIN32LOCKUPSYSTEM,BIT32,CDECL,pHab);
}

WinUnlockSystem(pHab,pPassword)
{
   #define ORD_WIN32UNLOCKSYSTEM 282
   return PMDynamicLink("PMWP",ORD_WIN32UNLOCKSYSTEM,BIT32,CDECL,pHab,pPassword);
}

