@echo off
REM *****************************************************************
REM *** BarClock.cmd - CEnvi2 for OS/2 utility to show the current ***
REM *** ver.2          time in the title bar of the currently     ***
REM ***                active window.                             ***
REM *****************************************************************

START "BarClock Forever" /N CEnvi2.exe BarClock.cmd
GOTO CENVI_EXIT

#define UPDATE_FREQUENCY   1000 // milliseconds between update

// Adjust strftime statement to get your own version of time.
// Uncomment the one you want
//TimeFormat = "%I:%M%p";  // 12-hour and minute and AM or PM
//TimeFormat = "%H:%M:%S"; // 24-hour hour:minute:second
TimeFormat = "%I:%M:%S";   // 12-hour hour:minute:second

#include <WinTools.lib>

// hide this window
ShowWindow(Info().WinHandle,SW_HIDE);

TimeWindow = NULL;

while( True ) {
   suspend(UPDATE_FREQUENCY);
   Hwnd = GetActiveWindow();
   if ( Hwnd != TimeWindow ) {
      // New window, so remove time from old window title
      if ( TimeWindow ) {
         if ( Title = GetWindowTitle(TimeWindow) ) {
            RemoveTimeFromTitle(Title);
            SetWindowTitle(TimeWindow,Title);
         }
      }
   }
   if ( TimeWindow = Hwnd ) {
      // Add time to this window
      if ( Title = GetWindowTitle(TimeWindow) ) {
         RemoveTimeFromTitle(Title);
         SetWindowTitle(TimeWindow,AddTimeToTitle(Title));
      }
   }
}


#define TIME_SEQUENCE   '\xFF-\xFF'

AddTimeToTitle(pTitle)
{
   strftime(lTime,TimeFormat,localtime(time()));
   sprintf(lTitle,"%s%s%s",pTitle,TIME_SEQUENCE,lTime);
   return lTitle;
}

RemoveTimeFromTitle(pTitle)
{
   if ( lSequence = strstr(pTitle,TIME_SEQUENCE) )
      lSequence[0] = '\0';
}

:CENVI_EXIT
