program convertmessage;

uses dos, crt;

var
  infile, outfile : text;
  buf :string[255];
  lines : word;

procedure showhelp;
begin
  writeln('SYNTAX: CNVTMSG <Infile> <Outfile>');
  writeln('                                ');
  writeln('                             file to save converted message');
  writeln('                    file containing message to convert');
  writeln;
  writeln('This program will fix messages that have been exported from');
  writeln('Celerity v2.00 or v2.01 by adding a CR/LF to the end of each');
  writeln('line in the message.  The outfile will be overwritten if it exists.');
  writeln;
end;

begin
  writeln('Celerity v2.01 Message Converter v1.0');
  writeln('written by Byteman 5.1.94');
  writeln;
  if paramcount >= 2 then
    begin
    assign(infile,paramstr(1));
    {$I-}
    reset(infile);
    {$I+}
    if IOResult <> 0 then
      begin
      writeln('Error opening input file ',paramstr(1));
      writeln;
      showhelp;
      Halt(1);
    end;
    assign(outfile,paramstr(2));
    {$I-}
    rewrite(outfile);
    if IOResult <> 0 then
      begin
      writeln('Error opening output file ',paramstr(2));
      writeln;
      showhelp;
      Halt(2);
    end;
    {$I+}
    writeln('Converting file ',paramstr(1));
    lines := 0;
    repeat
      readln(infile,buf);
      writeln(outfile,buf);
      inc(lines);
    until eof(infile);
    close(outfile);
    close(infile);
    writeln(lines,' lines converted and saved as ',paramstr(2));
    writeln;
  end
  else showhelp;
end.

{v1.0 written 5.1.94 by Byteman to fix an ansi exported from Celerity v2.01}