% ͸
% ****  Example of a CDU.CTL file, usable for ALL programs       *****
% --------------------------------------------------------------------
%  This is an example of CDU.CTL. If you want to use a separate CTL   
%  for each program (e.g. CDM.CTL, CDF.CTL and so on), you must leave 
%  out the program-prefix that can be found in the program-specific   
%  options. All COMMON options must be repeated into the separate     
%  CTL-files in this case (the programs only read 1 CTL).             
% ;
%
% ͸
%  S T A T E M E N T S   C O M M O N   T O   A L L   P R O G R A M S  
% ;
%
% RegistrationName only registered users
CDUTempDirectory F:\ZIP
CDUSwapDirectory F:\ZIP
CDUCatdiskBase   C:\CAT
CDUCatdiskProg   C:\CAT\CATDISK.EXE
BaseOptions      ARCH NC_NCC
BaseOptions      GAME NC
BaseDrive        ARCH A
BaseDrive        GAME B
%
% ͸
%  S T A T E M E N T S   S P E C I A L   T O   :   C D C              
% ;
%
% None
%
% ͸
%  S T A T E M E N T S   S P E C I A L   T O   :   C D F              
% ;
%
% None
%
% ͸
%  S T A T E M E N T S   S P E C I A L   T O   :   C D M              
% ;
%
CDM ClusterSize    1350000 1499999  512
CDM ClusterSize     700000  740000 1024
%
CDM Directory2Base F:\ZIP\TRA  ARCH A
CDM Directory2Base F:\ZIP\MOV  UBBS A
CDM Directory2Base F:\ZIP\WIN  WIN3 A
CDM Directory2Base F:\ZIP\PAS  PASC A
CDM Directory2Base F:\ZIP\LAN  LANG A
CDM Directory2Base F:\ZIP\FS4  FSIM A
%
% ͸
%  S T A T E M E N T S   S P E C I A L   T O   :   C D R              
% ;
%
CDR ToOldFiles -12
% CDR ToOldFiles 0991
% CDR ExcludeFile *    ARC*.*
% CDR ExcludeFile ARCH PKZ*.*
%
% ͸
%  S T A T E M E N T S   S P E C I A L   T O   :   C D S              
% ;
%
% None
%
% ͸
%  S T A T E M E N T S   S P E C I A L   T O   :   C D T              
% ;
%
CDT GlobalChange .EXE .ARJ
CDT GlobalChange .COM .ARJ
CDT GlobalChange .ARC .ARJ
CDT GlobalChange .LZH .ARJ
CDT GlobalChange .HYP .ARJ
CDT GlobalChange .ZIP .ARJ
CDT GlobalChange .ZOO .ARJ
CDT GlobalChange .SQZ .ARJ
%
% ͸
%  Each FileListUpdate statement contains the following fields        
%  ----mask----  mask of the comment-file                             
%  --base--      name of the database to update                       
%  SFi           starting postion of the filename                     
%  EFi           ending      ,,   ,,  ,, filename                     
%  SDi           starting postion of the directory (if any)           
%  EDi           ending      ,,   ,,  ,, directory (if any)           
%  SVo           starting postion of the VolumeID  (if any)           
%  EVo           ending      ,,   ,,  ,, VolumeID  (if any)           
%  SCo           starting postion of the comment                      
%  ECo           ending      ,,   ,,  ,, comment                      
% ;
%                  ----mask---- --base-- SFi EFi SDi EDi SVo EVo SCo ECo
CDT FilelistUpdate FILES.???    ARCH     001 012 000 000 000 000 014 080
CDT FilelistUpdate FILES.???    GAME     001 012 000 000 000 000 014 080
CDT FilelistUpdate FILES.???    WIN3     001 012 000 000 000 000 014 080
CDT FilelistUpdate FILES.???    PASC     001 012 000 000 000 000 014 080
CDT FilelistUpdate FILES.???    LANG     001 012 000 000 000 000 014 080
CDT FilelistUpdate FILES.???    UBBS     001 012 000 000 000 000 014 080
CDT FilelistUpdate FILES.???    FSIM     001 012 000 000 000 000 014 080
CDT FilelistUpdate MLP*.LST     ARCH     001 012 000 000 000 000 033 080
CDT FilelistUpdate MLP*.LST     GAME     001 012 000 000 000 000 033 080
CDT FilelistUpdate MLP*.LST     WIN3     001 012 000 000 000 000 033 080
CDT FilelistUpdate MLP*.LST     PASC     001 012 000 000 000 000 033 080
CDT FilelistUpdate MLP*.LST     LANG     001 012 000 000 000 000 033 080
CDT FilelistUpdate MLP*.LST     UBBS     001 012 000 000 000 000 033 080
CDT FilelistUpdate MLP*.LST     FSIM     001 012 000 000 000 000 033 080
CDT FilelistUpdate NEWFILES.*   ARCH     001 012 000 000 000 000 038 080
CDT FilelistUpdate NEWFILES.*   GAME     001 012 000 000 000 000 038 080
CDT FilelistUpdate NEWFILES.*   WIN3     001 012 000 000 000 000 038 080
CDT FilelistUpdate NEWFILES.*   PASC     001 012 000 000 000 000 038 080
CDT FilelistUpdate NEWFILES.*   LANG     001 012 000 000 000 000 038 080
CDT FilelistUpdate NEWFILES.*   UBBS     001 012 000 000 000 000 038 080
CDT FilelistUpdate NEWFILES.*   FSIM     001 012 000 000 000 000 038 080
CDT FilelistUpdate ALLFILES.TXT ARCH     001 012 000 000 000 000 038 080
CDT FilelistUpdate ALLFILES.TXT GAME     001 012 000 000 000 000 038 080
CDT FilelistUpdate ALLFILES.TXT WIN3     001 012 000 000 000 000 038 080
CDT FilelistUpdate ALLFILES.TXT PASC     001 012 000 000 000 000 038 080
CDT FilelistUpdate ALLFILES.TXT LANG     001 012 000 000 000 000 038 080
CDT FilelistUpdate ALLFILES.TXT UBBS     001 012 000 000 000 000 038 080
CDT FilelistUpdate ALLFILES.TXT FSIM     001 012 000 000 000 000 038 080
%
% ͸
%  S T A T E M E N T S   S P E C I A L   T O   :   C D Z              
% ;
%
% CDZ TapeProgramPath C:\CMS\TAPE.EXE
%
% ͸
%            ###  E N D   O F   C O N T O L F I L E  ###              
% ;
