/*
** $PROJECT: c.datatype
**
** $VER: classbase.h 39.2 (11.03.95)
**
** by
**
** Stefan Ruppert , Windthorststrae 5 , 65439 Flrsheim , GERMANY
**
** (C) Copyright 1995
** All Rights Reserved !
**
** $HISTORY:
**
** 11.03.95 : 039.002 : pen allocation stuff added
** 06.03.95 : 039.001 : initial
*/

/* ------------------------------- includes ------------------------------- */

#include <dos/dos.h>
#include <dos/dosextens.h>
#include <exec/types.h>
#include <exec/ports.h>
#include <exec/memory.h>
#include <exec/lists.h>
#include <exec/semaphores.h>
#include <exec/execbase.h>
#include <intuition/classes.h>
#include <intuition/classusr.h>
#include <intuition/cghooks.h>
#include <intuition/gadgetclass.h>
#include <graphics/gfxbase.h>
#include <graphics/gfx.h>
#include <graphics/text.h>
#include <libraries/iffparse.h>
#include <datatypes/datatypes.h>
#include <datatypes/datatypesclass.h>
#include <datatypes/textclass.h>
#include <clib/alib_protos.h>
#include <clib/alib_stdio_protos.h>
#include <string.h>
#include <dos.h>

#include <clib/macros.h>
#include <clib/dos_protos.h>
#include <clib/exec_protos.h>
#include <clib/intuition_protos.h>
#include <clib/iffparse_protos.h>
#include <clib/graphics_protos.h>
#include <clib/utility_protos.h>
#include <clib/datatypes_protos.h>
#include <clib/dtclass_protos.h>

#include <pragmas/dos_pragmas.h>
#include <pragmas/exec_pragmas.h>
#include <pragmas/intuition_pragmas.h>
#include <pragmas/iffparse_pragmas.h>
#include <pragmas/graphics_pragmas.h>
#include <pragmas/utility_pragmas.h>
#include <pragmas/datatypes_pragmas.h>
#include <pragmas/dtclass_pragmas.h>

#include <ctype.h>

/* --------------------------- include my stuff --------------------------- */

#include <register.h>
#include <debug.h>

#define ClassCall    LibCall

#include "protos.h"

/* -------------- set some stuff for the generic classbase.c -------------- */

/* set , which datatype library should be opened during our OpenLibrary() */
#define SUPERCLASSDATATYPE       "datatypes/text.datatype"

/* set the function name to get a pointer to our class */
#define ENGINE                   ObtainCEngine

#define DATATYPENAME             "c.datatype"

/* ------------------------- ClassBase structure -------------------------- */

struct ClassBase
{
	 struct Library               cb_Lib;
	 UWORD                        cb_UsageCnt;
	 struct Library              *cb_SysBase;
	 struct Library              *cb_DOSBase;
	 struct Library              *cb_IntuitionBase;
	 struct Library              *cb_GfxBase;
	 struct Library              *cb_UtilityBase;
	 struct Library              *cb_IFFParseBase;
	 struct Library              *cb_DataTypesBase;
	 struct Library              *cb_SuperClassBase;
	 BPTR                         cb_SegList;

	 struct SignalSemaphore       cb_Lock;               /* Access lock */
	 Class                       *cb_Class;
};

/* ---------------------------- library bases ----------------------------- */

#define SysBase                 cb->cb_SysBase
#define DOSBase                 cb->cb_DOSBase
#define UtilityBase             cb->cb_UtilityBase
#define IntuitionBase           cb->cb_IntuitionBase
#define IFFParseBase            cb->cb_IFFParseBase
#define GfxBase                 cb->cb_GfxBase
#define DataTypesBase           cb->cb_DataTypesBase
#define SuperClassBase          cb->cb_SuperClassBase

/* ----------------------- datatype specific stuff ------------------------ */

enum
{
	/* modes with style */
	C_STANDARD,
	C_COMMENT,
	C_CPP,
	C_KEYWORD,
	C_STORAGE,
	C_TYPES,
	C_TYPENAME,
	C_STRING,
	C_NUMBER,
	C_MAX,

	/* modes without style */
	C_CPPTEXTLIST,
};

struct Style
{
	UWORD FgPen;
	UWORD BgPen;
	UWORD Style;
};

struct cdtMem
{
	struct cdtMem *Next;
	ULONG Size;
};

struct PenNode
{
	struct MinNode pn_Node;
	ULONG pn_Red;
	ULONG pn_Green;
	ULONG pn_Blue;
	ULONG pn_Section;
	LONG pn_Pen;
};

/* ---------------------------- instance data ----------------------------- */

struct CData
{
	APTR cd_Pool;

	UWORD cd_TabLength;

	struct List cd_PenList;
	struct ColorMap *cd_ColorMap;

	struct Style cd_CStyle[C_MAX];
};

/* --------------------------- parser structure --------------------------- */

struct CParse
{
	STRPTR BegPtr;          /* pointer to the begin of the hole text */
	STRPTR SegPtr;          /* pointer to the text for the next segment */
	STRPTR TxtPtr;          /* pointer to the text for the next text segment */
	STRPTR ActPtr;          /* Actual text pointer */
	STRPTR EndPtr;          /* End text pointer */

	UWORD TabWidth;

	ULONG Chars;
	UWORD Mode;
	UWORD LastMode;         /* last segment index */
	int Token;              /* last token */

	ULONG XOffset;
	ULONG YOffset;
	ULONG XOffsetAdd;       /* for tab handling */

	ULONG MaxWidth;

	struct List *LineList;  /* list to append line segments */
	struct RastPort *RPort; /* tempory RastPort for TextLength() */

	struct cdtMem *Memory;  /* memory handling for bison parser */

	struct CData *Data;     /* link to the instance data */
};

int cdtparse_parse(struct ClassBase *cb,struct CParse *cparse);
int cdtparse_error(char *errstr);
void *cdtparse_alloc(struct ClassBase *cb,struct CParse *cparse,int size);

/* redirect bison alloca() to my own memory handling function */
#define alloca(x)    cdtparse_alloc(cb,cparse,x)

