
' $segment
' $linesize:132
' $title: 'DOSFUNC.BAS, Copyright 1993,1994 by Daniel T. Drinnon'
'  RBBS-PC Copyright 1992 by D. Thomas Mack, all rights reserved.
'  Name ...............: DOSFUNC.BAS
'  First Released .....: August 17, 1993
'  Copyright ..........: 1993,1994
'  Purpose.............: DOS Function calls for RBBS-PC CDOR
'  Parameters..........: Most parameters are passed via a COMMON statement.
'
' Subroutine or Function             Purpose
'  CheckShare                         Check/Return status of DOS SHARE
'  CheckPrinter                       Check/Return status of PRINTER
'
' $INCLUDE: 'RBBS-VAR.BAS'

   TYPE RegTypeX
      ax      AS INTEGER
      bx      AS INTEGER
      cx      AS INTEGER
      dx      AS INTEGER
      bp      AS INTEGER
      si      AS INTEGER
      di      AS INTEGER
      flags   AS INTEGER
      ds      AS INTEGER
      es      AS INTEGER
   END TYPE
'
' =============================================================================
' * CheckShare - Returns ZOK = ZTrue if SHARE is loaded
' =============================================================================

    SUB CheckShare
    DIM InRegs AS RegTypeX, OutRegs AS RegTypeX
    CALL CheckNovell (Installed)
    IF Installed = 0 THEN
       ZOK = ZTrue
       EXIT SUB
    END IF
    ZOK = ZFalse
    InRegs.ax = &H1000
    CALL InterruptX(&H2F, InRegs, OutRegs)
    CheckShareVal = OutRegs.ax AND &HFF
    IF CheckShareVal = &HFF THEN
       ZOK = ZTrue
    ELSE
       ZSnoop = ZTrue
       '* "ERROR - SHARE NOT INSTALLED"
       CALL FormatString (848,ZTrue,ZFalse,0,ZFalse,0,"")
       CALL DelayTime (5)
    END IF
    END SUB

' =============================================================================
' * CheckPrinter - Returns ZOK = ZTrue if Printer Ready
' =============================================================================

    SUB CheckPrinter (PrinterNumber)
    DIM InRegs AS RegTypeX, OutRegs AS RegTypeX
    ZOK = ZFalse
    IF PrinterNumber = 0 THEN
       EXIT SUB
    END IF
    InRegs.ax = &H0200
    InRegs.dx = PrinterNumber - 1
    CALL InterruptX(&H17, InRegs, OutRegs)
    PrinterAlive = (OutRegs.ax AND &HFF00) / &H100
    ZOK = (((PrinterAlive AND &H29) = 0) AND ((PrinterAlive AND &H90) = &H90))
    END SUB

' =============================================================================
' * SetFileHandles - Sets Maximum number of File Handles (not needed yet!)
' =============================================================================

'   SUB SetFileHandles (Handles)
'   DIM InRegs AS RegTypeX, OutRegs AS RegTypeX
'   InRegs.ax = &H6700
'   InRegs.bx = Handles
'   CALL InterruptX(&H21, InRegs, OutRegs)
'   END SUB

' =============================================================================
' * DelFile - Deletes a File
' =============================================================================

    SUB DelFile (FileName$,ECODE)
    DIM InRegs AS RegTypeX, OutRegs AS RegTypeX
    NameFile$ = FileName$ + CHR$(0)
    InRegs.ds = SSEG(NameFile$)
    InRegs.dx = SADD(NameFile$)
    InRegs.ax = &H4100
    CALL InterruptX(&H21, InRegs, OutRegs)
    ECODE = (OutRegs.Flags AND 1)
    END SUB

' =============================================================================
' * GetFDateTime - Gets File Date and Time
' =============================================================================

    SUB GetFDate (FileName$,FDATE,FTIME)
    DIM InRegs AS RegTypeX, OutRegs AS RegTypeX
    NameFile$ = FileName$ + CHR$(0)
    InRegs.ds = SSEG(NameFile$)
    InRegs.dx = SADD(NameFile$)
    InRegs.ax = &H3D00
    CALL InterruptX(&H21, InRegs, OutRegs)
    IF OutRegs.flags AND 1 THEN
       EXIT SUB
    END IF
    Handle = OutRegs.ax
    InRegs.ax = &H5700
    InRegs.bx = Handle
    CALL InterruptX(&H21, InRegs, OutRegs)
    FTIME = OutRegs.cx
    FDATE = OutRegs.dx
    InRegs.ax = &H3E00
    InRegs.bx = Handle
    CALL InterruptX(&H21, InRegs,OutRegs)
    END SUB

' =============================================================================
' * SetFDateTime - Sets File Date and Time
' =============================================================================

    SUB SetFDate (FileName$,FDATE,FTIME)
    DIM InRegs AS RegTypeX, OutRegs AS RegTypeX
    NameFile$ = FileName$ + CHR$(0)
    InRegs.ds = SSEG(NameFile$)
    InRegs.dx = SADD(NameFile$)
    InRegs.ax = &H3D02
    CALL InterruptX(&H21, InRegs, OutRegs)
    IF OutRegs.flags AND 1 THEN
       EXIT SUB
    END IF
    Handle = OutRegs.ax
    InRegs.ax = &H5701
    InRegs.bx = Handle
    InRegs.cx = FTIME
    InRegs.dx = FDATE
    CALL InterruptX(&H21, InRegs, OutRegs)
    InRegs.ax = &H3E00
    InRegs.bx = Handle
    CALL InterruptX(&H21, InRegs,OutRegs)
    END SUB

' =============================================================================
' * ScrollUp - Scrolls Local Display Screen up 1 line
' =============================================================================

    SUB ScrollUp
    DIM InRegs AS RegTypeX, OutRegs AS RegTypeX

    Bottom = ((ZLocalPageLength-2) * &HFF) + 80 + ZLocalPageLength-2

    InRegs.ax = &H0601
    InRegs.bx = &H0F00
    InRegs.cx = &H0000
    InRegs.dx = Bottom
    CALL InterruptX(&H10, InRegs, OutRegs)

    END SUB

' =============================================================================
' * ClearViewPort - Clears all but 'line 25'
' =============================================================================

    SUB ClearViewPort
    DIM InRegs AS RegTypeX, OutRegs AS RegTypeX

    Bottom = ((ZLocalPageLength-2) * &HFF) + 80 + ZLocalPageLength-2

    InRegs.ax = &H0600
    InRegs.bx = &H0F00
    InRegs.cx = &H0000
    InRegs.dx = Bottom
    CALL InterruptX(&H10, InRegs, OutRegs)

    END SUB

' =============================================================================
' * WriteChar - Writes Any ASCII Character to the screen
' =============================================================================

    SUB WriteChar (Char,Attr)
    DIM InRegs AS RegTypeX, OutRegs AS RegTypeX

    InRegs.ax = &H0900 + Char
    InRegs.bx = &H0000 + Attr
    InRegs.cx = &H0001

    CALL InterruptX(&H10, InRegs, OutRegs)
    END SUB
