' $INCLUDE: 'RBBS-VAR.MOD'
' $segment
' $dynamic
' * Originaly by Richard Todd (1:3612/299)
' * Changes for Mpl/Cdor by Peter Eibl and Dan Drinnon
' * Used with Permission
' *
    TYPE RegTypeX
       ax      AS INTEGER
       bx      AS INTEGER
       cx      AS INTEGER
       dx      AS INTEGER
       bp      AS INTEGER
       si      AS INTEGER
       di      AS INTEGER
       flags   AS INTEGER
       ds      AS INTEGER
       es      AS INTEGER
    END TYPE

    FUNCTION GetFirstMatchingFile$ (FileSpec$)

    DIM InRegs AS RegTypeX, OutRegs AS RegTypeX
' *
' * REM Get Disk Transfer Area (DTA) address
' *
    InRegs.ax = &H2F00
    CALL InterruptX(&H21, InRegs, OutRegs)
    SegDTA% = OutRegs.es
    OffDTA% = OutRegs.bx
' *
' * REM Now find first match
' *
    NameFile$ = FileSpec$ + CHR$(0)
    InRegs.ds = SSEG(NameFile$)
    InRegs.dx = SADD(NameFile$)
    InRegs.cx = 0
    InRegs.ax = &H4E00
    CALL InterruptX(&H21, InRegs, OutRegs)

    IF OutRegs.flags AND 1 THEN
       GetFirstMatchingFile$ = ""
       EXIT FUNCTION
    END IF

    DEF SEG = SegDTA%
    OffMatch% = OffDTA% + 29

    Match$ = ""
    FOR i = 1 TO 13
       C$ = CHR$(PEEK(OffMatch% + i))
       IF C$ = CHR$(0) THEN
          EXIT FOR
       END IF
       Match$ = Match$ + C$
    NEXT i

    DEF SEG

    GetFirstMatchingFile$ = Match$

    END FUNCTION
'
    FUNCTION GetNextMatchingFile$

    DIM InRegs AS RegTypeX, OutRegs AS RegTypeX
' *
' * REM Get Disk Transfer Area (DTA) address
' *
    InRegs.ax = &H2F00
    CALL InterruptX(&H21, InRegs, OutRegs)
    SegDTA% = OutRegs.es
    OffDTA% = OutRegs.bx
' *
' * REM Now find next match
' *
    InRegs.ax = &H4F00
    CALL InterruptX(&H21, InRegs, OutRegs)

    IF OutRegs.flags AND 1 THEN
       GetNextMatchingFile$ = ""
       EXIT FUNCTION
    END IF

    DEF SEG = SegDTA%
    OffMatch% = OffDTA% + 29

    Match$ = ""
    FOR i = 1 TO 13
       C$ = CHR$(PEEK(OffMatch% + i))
       IF C$ = CHR$(0) THEN
          EXIT FOR
       END IF
       Match$ = Match$ + C$
    NEXT i

    DEF SEG

    GetNextMatchingFile$ = Match$

    END FUNCTION

'
' ***  WILDDOWN  -  Find matches to input for download  ***
'
'
' * read in the config file
'

100 SUB WILDDOWN (ZFileName$, ZMarkedFiles$, ZFastFileList$, Found) STATIC
'
    REDIM ZOutTxt$(99)

    Found = ZFalse

    CALL QuickTPut (ZFG5$ + "Looking for Matches to " + _
                ZFGB$ + ZWasZ$ + ZFG5$ + SPACE$(1) + ZEmphasizeOn$ + _
                "(<CTRL-X> Aborts) " + ZEmphasizeOff$,0)
    NumDots = 0
    CfgFileName$ = LEFT$(ZFastFileList$, INSTR(ZFastFileList$, ".") -1) + ".CFG"
    CLOSE 2
    CALL OpenWork (2,CfgFileName$)
    CALL ReadDir (2,1)
    MaxFiles = VAL(ZOutTxt$)
'
' * check for previously marked files
'
    IF LEN(ZMarkedFiles$) > MaxFiles * 13 THEN
       CALL SkipLine (1)
       CALL QuickTPut1(ZFGF$ + ZBG4$ + _
                       "Too Many Files Already Marked!" + _
                       ZEmphasizeOff$)
       ZFileName$ = ""
       EXIT SUB
    END IF
'
' * save the current list of marked files
'
   HoldMarkedFiles$ = ZMarkedFiles$
'
' * read in the directories from the FIDX.CFG and check Security Level
'
    Index = 1
    DO WHILE NOT EOF(2)
       CALL ReadDir (2,1)
       Level = INSTR(ZOutTxt$,",")
       IF ZUserSecLevel >= VAL(LEFT$(ZOutTxt$,Level-1)) THEN
          ZOutTxt$(Index) = RIGHT$(ZOutTxt$,LEN(ZOutTxt$)-Level)
          Index = Index + 1
       END IF
    LOOP
    CLOSE 2
'
' * search in the Upload and Download Directories listed in the FIDX.CFG
'
200 TotalMatch = 0
    SearchDir = 1
    ZMarkedFiles$ = ""
    DO WHILE SearchDir < Index
       GOSUB 700
       IF KillSearch THEN GOTO 400
       MatchFile$ = ""
       FILESPEC$ = ZOutTxt$(SearchDir) + ZFileName$
       IF SearchDir = 1 THEN
          CALL SkipLine (1)
          CALL QuickTPut (ZFG5$ + "Searching " + _
                          ZFGB$ + "UPLOADS",0)
       END IF
       CALL MarkTime (NumDots)
       MatchFile$ = GetFirstMatchingFile$(FILESPEC$)
       IF MatchFile$ <> "" THEN
          ZMarkedFiles$ = ZMarkedFiles$ + MatchFile$ + CHR$(13)
          TotalMatch = TotalMatch + 1
          MatchFile$ = GetNextMatchingFile$
          DO WHILE MatchFile$ <> ""
             CALL MarkTime (NumDots)
             ZMarkedFiles$ = ZMarkedFiles$ + MatchFile$ + CHR$(13)
             TotalMatch = TotalMatch + 1
             MatchFile$ = GetNextMatchingFile$
             IF TotalMatch => MaxFiles THEN
                CALL QuickTPut (ZBackSpace$,0)
                CALL SkipLine (1)
                CALL QuickTPut1(ZFGF$ + ZBG4$ + _
                                "Too Many Matching Files!" + _
                                ZEmphasizeOff$)
                ZFileName$ = ""
                GOTO 400
             END IF
          LOOP
       END IF
       SearchDir = SearchDir + 1
    LOOP
    CALL QuickTPut (ZBackSpace$,0)
'
' * look in the FIDX.DEF
'
300 IF NOT ZFastFileSearch THEN GOTO 400
    CALL BreakFileName (ZFastFileList$, Drive$,Body$,Ext$,ZTrue)
    TIdxLst$ = Drive$ + Body$ + ".LST"
    CALL FindIt (TIdxLst$)
    IF ZOK THEN
       LineToRead = 1
       CALL OpenWork (11,TIdxLst$)
       IF ZErrCode <> 0 THEN
          GOTO 400
       END IF
305    CALL ReadParmsX (11,ZOutTxt$(),4,LineToRead)
       IF ZErrCode <> 0 AND ZOutTxt$(1) = "" THEN
          CLOSE 11
          GOTO 400
       END IF
       LineToRead = LineToRead + 1
       TFastFileList$ = ZOutTxt$(1)
       CALL BreakFileName (ZOutTxt$(3),Drive$,Body$,Ext$,ZTrue)
       CALL SkipLine (1)
       CALL QuickTPut (ZFG5$ + "Searching " + ZFGB$ + _
                       UCASE$(Body$) + SPACE$(2),0)
       GOSUB 310
       ZOutTxt$(1) = ""
       GOTO 305
    ELSE
       TFastFileList$ = ZFastFileList$
       GOSUB 310
       GOTO 400
    END IF
310 FSize = 21
    CALL OpenRSeq (2,TFastFileList$,HighRec,WasX,21)
    FIELD #2, 12 AS SearchFile$, _
               4 AS SearchPath$, _
               3 AS SearchDate$, _
               2 AS SearchCrLf$
    GET 2,1
    IF SearchCrLf$ <> ZCRLf$ THEN
       FSize = 18
       CALL OpenRSeq (2,TFastFileList$,HighRec,WasX,18)
       FIELD #2, 12 AS SearchFile$, _
                  4 AS SearchPath$, _
                  2 AS SearchCrLf$
    END IF
'
' * Set the LowRec value to 1 before checking for the tabs file low value.
'
    LowRec = 1                                                       ' DGS050401/DS

'
' * See if the Tabs File exists by checking for the proper size.
' * The file ZFastTabs$ is created in line 108 of RBBS-PC.
'
    IF LEN(ZFastTabs$) < 72 THEN _                                   ' DGS050401/DS
       GOTO 350                                                      ' DGS050401/DS

'
' * Now check to see if the first letter is not a wildcard, to make
' * the searching of the FIDX file by the first letter, instead of
' * a sequential search (AAARRRRGGGGHHHHHH!!!!).  Most of this code
' * was taken from SUB5 witH variable names and some logic changed
' * to work in this sub.
'
    FirstLetter$ = LEFT$(ZFileName$,1)                               ' DGS050401/DS
    FirstLet = INSTR("0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ*?",FirstLetter$) ' DGS050401/DS
    IF FirstLet < 37 THEN                                            ' DGS050401/DS
       IF FirstLet = 0 THEN                                          ' DGS050401/DS
          LowRec = 1                                                 ' DGS050401/DS
       ELSE                                                          ' DGS050401/DS
          LowRec = CVI(MID$(ZFastTabs$,1+2*(FirstLet-1),2))          ' DGS050401/DS
       END IF                                                        ' DGS050401/DS
       IF FirstLet < 36 THEN _                                       ' DGS050401/DS
          HighRec = CVI(MID$(ZFastTabs$,1+2*FirstLet,2))             ' DGS050401/DS
    END IF                                                           ' DGS050401/DS
350 FOR Count = LowRec TO HighRec                                    ' DGS050401/DS
       GET 2, Count
       GOSUB 700
       IF KillSearch THEN EXIT FOR
       CALL MarkTime (NumDots)
       FileName$ = SearchFile$
       CALL Trim (FileName$)
       CALL WildFile (ZFileName$,FileName$,DoesMatch)
       IF DoesMatch THEN
             ZMarkedFiles$ = ZMarkedFiles$ + Filename$ + CHR$(13)
             TotalMatch = TotalMatch + 1
       END IF
       IF TotalMatch => MaxFiles THEN
          CALL QuickTPut (ZBackSpace$,0)
          CALL SkipLine (1)
          CALL QuickTPut1(ZFGF$ + ZBG4$ + _
                       "Too Many Matches!" + _
                       ZEmphasizeOff$)
          EXIT FOR
       END IF
    NEXT Count
    RETURN
400 CLOSE 2
    CALL QuickTPut (ZBackSpace$,0)
'
' * display number of matches found and end sub
'
600 ZFileName$ = ""
    CALL OpenWorkA (2,ZNodeWorkDrvPath$+"WILDDOWN.DEF")
    CALL PrintWorkA (2,ZMarkedFiles$)
    CLOSE #2
    CALL SkipLine (1)
    CALL QuickTput1 (ZFGB$ + STR$(TotalMatch) + _
                     ZFG2$ + " Matches Found" + ZEmphasizeOff$)

    IF ZMarkedFIles$ <> "" THEN Found = ZTrue

    ZMarkedFiles$ = HoldMarkedFiles$
    EXIT SUB
'
' * routine to find user break
'
700 CALL FindFKey
    KillSearch = ZFalse
    IF ZKeyPressed$ = CHR$(24) THEN
       KillSearch = ZTrue
    END IF
    IF ZLocalUser THEN
       RETURN
    END IF
    IF ZCommPortStack$ <> "" THEN
       IF LEFT$(ZCommPortStack$,LEN(ZCommPortStack$)-1) = CHR$(24) THEN
          KillSearch = ZTrue
       END IF
    END IF
    CALL EofComm (Char)
    IF Char <> -1 THEN
       CALL GetCom (WasX$)
       IF WasX$ = CHR$(24) THEN
          KillSearch = ZTrue
       END IF
    END IF
    CALL FlushCom (ZCommPortStack$)
    RETURN

    END SUB

