'  $segment
'
'  $linesize:132
'
'  $title: 'SYSOP8.BAS 17.4'
'
'  Copyright (c) 1993 Daniel T. Drinnon
'
'
'  $INCLUDE: 'RBBS-VAR.BAS'
'
'  $SUBTITLE: 'Sysop8 -- PERSONAL/FMS/FFS/RFM OnLine File Maintenance'
'
'  SUBROUTINE NAME    -- SYSOP8
'
'  INPUT PARAMETERS   -- None
'
'  OUTPUT PARAMETERS  -- None
'
'  SUBROUTINE PURPOSE -- Manipulation of the FMS/FFS/Personal Files Systems
'
100 SUB Sysop8 STATIC
'
' =============================================================================
' * Error Handling
' =============================================================================
'
    ON ERROR GOTO 12000
'
' =============================================================================
' * Return from Extended Description on ADD Action
' =============================================================================
'
    IF ZGetExtDesc THEN
       ZMaxMsgLines = ZMaxMsgLinesDef
       ZRightMargin = WasLL
       CALL UpdtUpload (ZCategoryName$(),ZCategoryCode$(),ZMaxExtendedLines,3)
       ZGetExtDesc = ZFalse
    END IF
'
' =============================================================================
' * Main entry prompt
' =============================================================================
'
    IF ZExpertUser THEN _
       GOTO 110
101 Sysop8File$ = ZWelcomeFileDrvPath$ + "SYSOP8.MNU"                ' DD061901
    CALL Graphic (Sysop8File$)                                       ' DD061901
    CALL BufFile (Sysop8File$,WasX)                                  ' DD061901
110 CALL Line25
    DO
       ZOutTxt$ = "A)dd, D)elete, E)dit, F)ind, M)ove, H)elp, [Q]uit"
       GOSUB 11100
    LOOP UNTIL ZWasQ = 0 OR INSTR("ADEFMHQ",ZWasZ$) <> 0
    IF ZWasQ = 0 OR ZWasZ$ = "Q" THEN                                'quit
       ZFileSysParm = 0                                              ' DD070101
       EXIT SUB
    END IF
    WasX = INSTR("ADEFMH",ZWasZ$)
    ON WasX GOSUB 200,300,400,500,600,101
    GOTO 110
'
' * ===========================================================================
' * Add a file to the FMS, Upload, or Personal Areas
' * ===========================================================================
'
200 Action$ = "ADD"
    GOSUB 700
205 ZOutTxt$ = ZFGB$ + "Enter " + ZFGA$ + "SOURCE " + ZFGB$ + _
               "Path/Filename of new file to " + Action$ + _
               ZEmphasizeOff$ + ZPressEnterExpert$
'
' * Get Source File Name
'
    GOSUB 8000

'
' * nothing to do check
'
    IF NOT ZOK THEN _
       GOTO 205
    IF ZWasQ = 0 THEN _
       RETURN
'
' * option to change target filename
'
    TargetFileName$ = SourceBody$ + SourceExt$
    ZOutTxt$ = ZFGB$ + "Enter " + ZFGA$ + "TARGET " + ZFGB$ + _
               "filename: " + ZEmphasizeOff$ + "[" + _
               TargetFileName$ + "]" + ZEmphasizeOff$
    GOSUB 11000
    IF ZWasQ <> 0 THEN
       TargetFileName$ = UCASE$(ZUserIn$(ZAnsIndex))
    END IF
'
' * Allow for Personal Uploads
'
    IF ZUserSecLevel >= ZMinSecPersUpld THEN _
       WhoTo$ = "" : _
       ZFileSysParm = 7 : _                                          ' DD070101
       CALL SetWhoTo (ZTrue,WhoTo$,"",RcvrRecNum,Found,ZTrue) _
    ELSE WhoTo$ = "ALL"
    TargetDir$ = ""
'
' * Setup to select target subdirectory
'
    IF WhoTo$ = "ALL" THEN
       InPers = ZFalse
       GOSUB 2000
    ELSE
        InPers = ZTrue
        InFMS = ZFalse
        TargetDir$ = ZPersonalDrvPath$
        GOSUB 5000
    END IF
    IF ZAnsIndex = 0 THEN
       ZWasQ = 0
       ZWasZ$ = ""
       RETURN
    END IF
'
' * Make sure copy was successful
'
    CALL FindIt (TargetDir$ + TargetFileName$)
    IF NOT ZOK THEN
       CALL QuickTPut1 (ZFGF$ + ZBG4$ + "ERROR! " + TargetFileName$ + _
                        " not found after COPY!" + ZBG0$ + ZEmphasizeOff$)
       GOTO 205
    END IF
'
' * option to delete original file
'
    GOSUB 3000
'
' * get description for directory listing
'
    GOSUB 4000
'
' * if aborted, then delete the copied file
'
    IF ZAbort THEN
       CALL KillWork (TargetDir$ + TargetFileName$)
       GOTO 205
    END IF
'
' * log it to the Caller's Log
'
    CALL UpdtCalr ("Added " + TargetFileName$ + " to File System",2)
'
' * set filename for FIDX
'
    ZFileName$ = TargetFileName$
'
' * if file was in FIDX/LIDX, then update the FIDX file
'
215 GOSUB 6000
' *
' * All Done
' *
    RETURN
'
' * ===========================================================================
' * Delete an entry from the Upload, FMS, or Personal Areas
' * ===========================================================================
'
300 Action$ = "DELETE"
    GOSUB 700
305 ZOutTxt$ = ZFGB$ + "Enter Filename" + _
               " to " + ZFGA$ + Action$ + ZEmphasizeOff$ + ZPressEnterExpert$
'
' * Get SourceFileName$
'
    GOSUB 8000

    IF ZWasQ = 0 THEN _
       RETURN
'
' *  if couldn't find file to delete, ask to remove it from file list
'
    CALL FindIt (SourceFileName$)
    IF NOT ZOK THEN
       DO
          ZOutTxt$ = ZFGB$ + "Remove Entry from File List?" + _
                     ZEmphasizeOff$ + ZNoPrompt$
          GOSUB 11100
       LOOP UNTIL ZWasQ = 0 OR INSTR("YN",ZWasZ$) <> 0
       IF ZWasZ$ = "N" OR ZWasQ = 0 THEN
          GOTO 305
       ELSE
          GOSUB 1000
          GOTO 310
       END IF
    END IF

    IF ZWasQ = 0 THEN
       RETURN
    END IF
'
' * find out if file to delete is in the Personal Files
'
    GOSUB 1000
'
' * delete it
'
    GOSUB 3000
'
' * if the file was not deleted then go no further
'
    CALL FindIt (SourceFileName$)
    IF ZOK OR ZWasQ = 0 OR ZWasZ$ = "N" THEN
       GOTO 305
    END IF
'
' * remove the entry from the respective file system (private/FMS)
'
310 IF InPers THEN
       GOSUB 7000
       GOTO 320
    END IF
    IF ZFastFileSearch THEN
       InFMS = ZTrue
       CALL BreakFileName (SourceFileName$,SourceDrive$, _
                           SourceBody$,SourceExt$,ZTrue)
       ZFileName$ = SourceBody$ + SourceExt$
       GOSUB 6000
       GOSUB 7000
    END IF
'                                                                    ' DD062805
' * option to add entry to offline file list                         ' DD062805
'                                                                    ' DD062805
320 CALL BreakFileName (SourceFileName$, Drive$, Body$, Ext$, ZTrue) ' DD062805
    DelFileName$ = Body$ + Ext$                                      ' DD062805
    DO                                                               ' DD062805
       ZOutTxt$ = ZFGB$ + "Add " + ZFG2$ + DelFileName$ + _          ' DD062805
                  ZFGB$ + " to " + ZFG2$ + "OFFLINE " + _            ' DD062805
                  ZFGB$ + "list?" + _                                ' DD062805
                  ZEmphasizeOff$ + ZNoPrompt$                        ' DD062805
       GOSUB 11100                                                   ' DD062805
    LOOP UNTIL ZWasQ = 0 OR INSTR("YN",ZWasZ$) <> 0                  ' DD062805
    IF ZWasZ$ = "N" OR ZWasQ = 0 THEN                                ' DD062805
       GOTO 330                                                      ' DD062805
    ELSE                                                             ' DD062805
       ZOutTxt$ = ZFGB$ + "Enter Filename" + _                       ' DD062805
               " of " + ZFGA$ + "OFFLINE List" + _                   ' DD062805
               ZEmphasizeOff$ + ZPressEnterExpert$                   ' DD062805
       GOSUB 11000                                                   ' DD062805
       IF ZWasQ = 0 THEN                                             ' DD062805
          GOTO 330                                                   ' DD062805
       END IF                                                        ' DD062805
       OfflineFileName$ = UCASE$(ZUserIn$(ZAnsIndex))                ' DD062805
       CALL FindIt (OfflineFileName$)                                ' DD062805
       IF NOT ZOK THEN                                               ' DD062805
          ZOutTxt$ = ZFGE$ + OfflineFileName$ + _                    ' DD062805
                     " does not exist!  Create?" + _                 ' DD062805
                     ZEmphasizeOff$ + ZNoPrompt$                     ' DD062805
          GOSUB 11100                                                ' DD062805
          IF ZWasZ$ = "N" OR ZWasQ = 0 THEN                          ' DD062805
             GOTO 320                                                ' DD062805
          END IF                                                     ' DD062805
       END IF                                                        ' DD062805
       CALL OpenWorkA (2,OfflineFileName$)                           ' DD062805
       CALL PrintWorkA (2, DelFileName$)                             ' DD062805
       CLOSE 2                                                       ' DD062805
    END IF                                                           ' DD062805
'
' * log it to the Caller's Log
'
330 CALL UpdtCalr ("Deleted " + SourceFileName$ + " from File System",2) ' DD062805
'
' All done
'
    RETURN
'
' * ===========================================================================
' * Edit an entry in the Upload, FMS, or Personal Areas
' * ===========================================================================
'
400 Action$ = "EDIT"
    GOSUB 700
    RETURN
'
' * ===========================================================================
' * Find an entry in the Upload, FMS, or Personal Areas
' * ===========================================================================
'
500 Action$ = "FIND"
    GOSUB 700

    ZOutTxt$ = ZFGB$ + "Enter Filename" + _
               " to " + ZFGA$ + Action$ + ZEmphasizeOff$ + ZPressEnterExpert$
'
' * get filename to find
'
    GOSUB 8000
'
    IF ZWasQ = 0 THEN _
       RETURN
'
' * give location
'
    IF ZOK THEN
       CALL BreakFileName (SourceFileName$,SourceDrive$, _
                           SourceBody$,SourceExt$,ZTrue)
       CALL QuickTPut1 (ZFGB$ + SourceBody$ + SourceExt$ + _
                        ZFG2$ + " is located in " + _
                        ZFGB$ + SourceDrive$ + ZEmphasizeOff$)
       RETURN
    END IF
'
' All done
'
    RETURN
'
' * ===========================================================================
' * Move an entry from/to the Upload, FMS, or Personal Areas
' * ===========================================================================
'
600 Action$ = "MOVE"
    GOSUB 700

605 ZOutTxt$ = ZFGB$ + "Enter Filename" + _
               " to " + ZFGA$ + Action$ + ZEmphasizeOff$ + ZPressEnterExpert$
'
' * get filename to find
'
    GOSUB 8000
'
    IF ZWasQ = 0 THEN _
       RETURN

    IF ZOK THEN
       CALL BreakFileName (SourceFileName$,SourceDrive$, _
                           SourceBody$,SourceExt$,ZTrue)

       TargetFileName$ = SourceFileName$
       CALL BreakFileName (TargetFileName$,TargetDir$, _
                           TargetBody$,TargetExt$,ZTrue)
       TargetFileName$ = TargetBody$ + TargetExt$
    END IF
'
' * Allow for Personal Uploads
'
    IF ZUserSecLevel >= ZMinSecPersUpld THEN _
       WhoTo$ = "" : _
       CALL SetWhoTo (ZTrue,WhoTo$,"",RcvrRecNum,Found,ZTrue) _
    ELSE WhoTo$ = "ALL"
    TargetDir$ = ""
'
' * Setup to select target subdirectory
'
    IF WhoTo$ = "ALL" THEN
       InPers = ZFalse
       GOSUB 2000
    ELSE
        InPers = ZTrue
        InFMS = ZFalse
        TargetDir$ = ZPersonalDrvPath$
        GOSUB 5000
    END IF
    IF ZAnsIndex = 0 THEN
       ZWasQ = 0
       ZWasZ$ = ""
       RETURN
    END IF
'
' * Make sure copy was successful
'
    CALL FindIt (TargetDir$ + TargetFileName$)
    IF NOT ZOK THEN
       CALL QuickTPut1 (ZFGF$ + ZBG4$ + "ERROR! " + TargetFileName$ + _
                        " not found after COPY!" + ZBG0$ + ZEmphasizeOff$)
       GOTO 605
    END IF
'
' * delete the original
'

GOSUB 3000
'    CALL KillWork (SourceFileName$)

'
' * set filename for FIDX
'
    ZFileName$ = TargetFileName$
'
' * if file was in FIDX/LIDX, then update the FIDX file
'
    GOSUB 6000
' *
' * All Done
' *
    RETURN
'
' * ===========================================================================
' * Build and display an Action prompt
' * ===========================================================================
'
700 CALL SkipLine (1)
    CALL QuickTPut1 (ZFGE$ + Action$ + " an FMS Entry" + ZEmphasizeOff$)
    RETURN
'
' =============================================================================
' * determine if the file is in Personals or FMS
' =============================================================================
'
1000 CALL WordInFile (ZPersonalDir$,SourceBody$ + SourceExt$,ZOK)
     IF ZOK THEN
        InFMS = ZFalse
        InPers = ZTrue
     ELSE
        InFMS = ZTrue
        InPers = ZFalse
     END IF
     RETURN
'
' =============================================================================
' * Pick Subdirectory to copy file to.  Look in subdirectories listed
' * in CONFIG first.  If FIDX/LIDX is used, use them too.
' *
' * Check the directories listed in CONFIG
' * The FIRST Subdirectory ZSubDir$(1) is always the UPLOAD sub
' * any other subdirectories listed in CONFIG should
' * not be in the FFS
' =============================================================================
'
2000 FOR WasX = 1 TO ZSubDirCount - 1
        DO
           ZOutTxt$ = ZFGB$ + Action$ + SPACE$(1) + ZFG2$ + SourceFileName$ + _
                      ZFGB$ + " to " + ZFG2$ + ZSubDir$(WasX) + _
                      ZEmphasizeOff$ + " (Y)es,[N]o,A)bort)"
           GOSUB 11100
        LOOP UNTIL ZWasQ = 0 OR INSTR("YNA",ZWasZ$) <> 0
        IF ZWasZ$ = "A" THEN
           ZAnsIndex = 0
           RETURN
        END IF
        IF ZWasZ$ = "Y" THEN
           InPers = ZFalse
           InFMS = ZFalse
           TargetDir$ = ZSubDir$(WasX)
           CALL BreakFileName (ZFMSDirectory$,TDirPath$, _
                               TMainFMSDir$,TMainDirExtension$,ZFalse)
           GOSUB 5000
           RETURN
        END IF
     NEXT WasX
' *
' * Search through the FIDX
' * Look for the FIDX.LST first
' *
     IF ZFastFileSearch THEN
        TFastFileLocator$ = ZFastFileLocator$
        CALL BreakFileName (ZFastFileList$,Drive$,Body$,Ext$,ZTrue)
        CALL FindIt (Drive$ + "SYSOP8.CFG")                          ' DD062802
        IF ZOK THEN                                                  ' DD062802
           CALL OpenWork (7, Drive$ + "SYSOP8.CFG")                  ' DD062802
        ELSE                                                         ' DD062802
           CALL FindIt (Drive$ + Body$ + ".LST")                     ' DD062802
           IF ZOK THEN                                               ' DD062802
              CALL OpenWork (7,Drive$ + Body$ + ".LST")              ' DD062802
           END IF                                                    ' DD062802
        END IF                                                       ' DD062802
        LineToRead = 1
        IF ZOK THEN                                                  ' DD062802
           IF ZErrCode <> 0 THEN
              GOSUB 2010
              GOTO 2020
           END IF
2005       CALL ReadParmsX (7,ZOutTxt$(),4,LineToRead)
           IF ZErrCode <> 0 AND ZOutTxt$(2) = "" THEN
              CLOSE 7
              GOTO 2020
           END IF
           TFastFileList$ = UCASE$(ZOutTxt$(1))
           TFastFileLocator$ = UCASE$(ZOutTxt$(2))
           CALL BreakFileName (UCASE$(ZOutTxt$(3)),TDirPath$,TMainFMSDir$, _
                              TMainDirExtension$,ZFalse)
           TMaxDescLen = VAL(ZOutTxt$(4))
           GOSUB 2010
           IF ZWasZ$ = "Y" THEN
              InPers = ZFalse
              InFMS = ZTrue
              GOTO 2020
           END IF
           LineToRead = LineToRead + 1
           ZOutTxt$(2) = ""
           GOTO 2005
        ELSE
           GOSUB 2010
           GOTO 2020
        END IF
2010    CALL OpenRSeq (2,TFastFileLocator$,HighRec,WasX,66)
        FIELD 2, 66 AS Location$
        IF LineToRead = 1 THEN
           Start = 2
        ELSE
           Start = 1
        END IF
        FOR WasX = Start TO HighRec
           GET 2, WasX
           Select$ = LEFT$(Location$,63)
           CALL Trim (Select$)
           IF LEFT$(Select$,2) <> "M!" THEN
              ZOutTxt$ = ZFGB$ + Action$ + SPACE$(1) + ZFG2$ + _
                         SourceFileName$ + _
                         ZFGB$ + " to " + ZFG2$ + Select$ + _
                         ZEmphasizeOff$ + " (Y)es,[N]o,A)bort)"
              GOSUB 11100
              IF ZWasZ$ = "A" THEN
                 ZAnsIndex = 0
                 RETURN
              END IF
              IF ZWasZ$ = "Y" THEN
                 InPers = ZFalse
                 InFMS = ZTrue
                 LidxPos = WasX
                 TargetDir$ = Select$
                 CLOSE 2
                 GOSUB 5000
                 RETURN
              END IF
           END IF
        NEXT WasX
        CLOSE 2
        RETURN
     END IF
2020 IF TargetDir$ = "" THEN _
        GOTO 2000
     RETURN
'
' =============================================================================
' * option to delete original file
' =============================================================================
'
3000 DO
        ZOutTxt$ = ZFGC$ + "Delete " + ZFGE$ + SourceFileName$ + _
                   ZFGC$ + "?" + ZEmphasizeOff$ + ZNoPrompt$
        GOSUB 11100
     LOOP UNTIL ZWasQ = 0 OR INSTR("YN",ZWasZ$) <> 0
     IF ZWasQ > 0 AND ZWasZ$ = "Y" THEN
        CALL KillWork (SourceFileName$)
     END IF
     RETURN
'
' =============================================================================
' * get description for directory listing
' =============================================================================
'
4000 CALL BreakFileName (TargetFileName$,Pre$,Body$,Ext$,ZFalse)
     HoldUpldDir$ = ZUpldDir$
     HoldFMSDirectory$ = ZFMSDirectory$
     GOSUB 4010
     CALL UpdtUpload (ZCategoryName$(),ZCategoryCode$(),0,1)
     GOSUB 4010
     CALL UpdtUpload (ZCategoryName$(),ZCategoryCode$(),0,2)
     ZFMSDirectory$ = HoldFMSDirectory$
     GOSUB 4020
     CALL FindIt (ZFileName$)
     IF NOT ZOK THEN
        CALL QuickTPut1 ("Upload Aborted")
     END IF
     IF ZGetExtDesc THEN
        ZMsgHeader$ = "Extended Description of " + ZFileNameHold$
        ZSysopComment = ZTrue
        ZMaxMsgLines = ZMaxExtendedLines
        WasLL = ZRightMargin
        ZRightMargin = 30 + ZMaxDescLen + (5 * ZShowTimesDownloaded)
        IF ZRightMargin > 74 THEN _
           ZRightMargin = 74
        EXIT SUB
     END IF
     RETURN
'==============================================================================
' * some rbbs configurations seem to leave off the trailing "\"
'==============================================================================
4010 IF RIGHT$(TDirPath$,1) <> "\" THEN
        ZFMSDirectory$ = TDirPath$ + "\" + TMainFMSDir$ + "." + TMainDirExtension$
     ELSE
        ZFMSDirectory$ = TDirPath$ + TMainFMSDir$ + "." + TMainDirExtension$
     END IF
     IF RIGHT$(ZFMSDirectory$,1) <> "\" THEN
        ZUpldDir$ = ZFMSDirectory$
     ELSE
        ZUpldDir$ = ZFMSDirectory$
     END IF
4020 ZFileName$ = TargetDir$ + TargetFileName$
     ZFileNameHold$ = TargetFileName$
     RETURN
'
' =============================================================================
' * copy file from source to target
' =============================================================================
'
5000 IF SourceFileName$ = TargetDir$ + TargetFileName$ THEN
        CALL QuickTPut1 (ZFG9$ + "SOURCE and TARGET " + _
                         "are the SAME!" + ZEmphasizeOff$)
        RETURN
     END IF
     CopyCommand$ = "COPY " + SourceFileName$ + SPACE$(1) + _
                        TargetDir$ + TargetFileName$ + " > NUL"
     CALL QuickTPut1 (ZFG9$ + "Copying " + ZFGB$ + SourceFileName$ + _
                      ZFG9$ + " as " + ZFGB$ + TargetFileName$ + _
                      ZFG9$ + " to " + ZFGB$ + TargetDir$ + ZEmphasizeOff$)
     CALL ShellExit (CopyCommand$)
     RETURN
'
' =============================================================================
' * if file was in FIDX/LIDX, then update the FIDX file
' =============================================================================
'
6000 IF InFMS = ZFalse OR InPers = ZTrue OR NOT ZFastFileSearch THEN _
         RETURN
     CALL QuickTPut1(ZFG2$ + "Rebuilding " + ZFGB$ + _
                     TFastFileList$ + ZEmphasizeOff$)
     FSize = 21
     CALL OpenRSeq (2,TFastFileList$,HighRec,WasX,21)
     FIELD #2, 12 AS SearchFile$, _
                4 AS SearchPath$, _
                3 AS SearchDate$, _
                2 AS SearchCrLf$
     GET 2,1
     IF SearchCrLf$ <> ZCRLf$ THEN _
        FSize = 18 : _
        CALL OpenRSeq (2,TFastFileList$,HighRec,WasX,18) : _
        FIELD #2, 12 AS SearchFile$, _
                   4 AS SearchPath$, _
                   2 AS SearchCrLf$
     SearchFile$ = ZFileName$
     WasX$ = MID$(STR$(LidxPos),2)
     WasX$ = SPACE$(4 - LEN(WasX$)) + WasX$
     SearchPath$ = WasX$
     IF FSize > 18 THEN _
        WasDX$ = DATE$ : _
        SearchDate$ = CHR$ (VAL (MID$ (WasDX$, 9, 2)) - 48) + _
                      CHR$ (VAL (MID$ (WasDX$, 1, 2)) + 31) + _
                      CHR$ (VAL (MID$ (WasDX$, 4, 2)) + 31) : _
     SearchCrLf$ = ZCRLf$

     IF FSize > 18 THEN _
        Template$ = SPACE$(21) : _
        MID$(Template$,17,3) = SearchDate$ : _
        MID$(Template$,20,2) = SearchCrLf$ _
     ELSE _
        Template$ = SPACE$(18) : _
        MID$(Template$,17,2) = SearchCrLf$
     MID$(Template$,1,12) = SearchFile$
     MID$(Template$,13,4) = SearchPath$
'
' * Rebuild the FIDX file
'
6010 CALL OpenRSeq (2,TFastFileList$,HighRec,WasX,FSize)
     FIELD #2, Fsize AS OldFidx$
     FIDXFileName$ = TDirPath$ + "FIDX.$$$"
     CALL OpenRSeq (7,FIDXFileName$,XX,XX,FSize)
     FIELD #7, FSize AS WorkFidx$
     NumRecs = LOF(2) / FSize
     Flag = ZFalse
     FOR Count = 1 TO NumRecs
        GET 2
        IF Action$ = "ADD" THEN
           IF MID$(OldFidx$,1,12) > MID$(Template$,1,12) _
              AND Flag = ZFalse THEN
              LSET WorkFidx$ = Template$
              PUT 7
              Flag = ZTrue
           END IF
           LSET WorkFidx$ = OldFidx$
           PUT 7
        END IF
        IF Action$ = "DELETE" THEN
           IF MID$(OldFidx$,1,12) < MID$(Template$,1,12) THEN
              LSET WorkFidx$ = OldFidx$
              PUT 7
           END IF
           IF MID$(OldFidx$,1,12) > MID$(Template$,1,12) THEN
              LSET WorkFidx$ = OldFidx$
              PUT 7
           END IF
        END IF
        IF Action$ = "MOVE" THEN
           IF MID$(OldFidx$,1,12) < MID$(Template$,1,12) THEN
              LSET WorkFidx$ = OldFidx$
              PUT 7
           END IF
           IF MID$(OldFidx$,1,12) = MID$(Template$,1,12) THEN
              LSET WorkFidx$ = Template$
              PUT 7
           END IF
           IF MID$(OldFidx$,1,12) > MID$(Template$,1,12) THEN
              LSET WorkFidx$ = OldFidx$
              PUT 7
           END IF
        END IF
     NEXT Count
'    CLOSE 2
     CLOSE 7
     CALL KillWork (TFastFileList$)
     NAME FIDXFileName$ AS TFastFileList$
'
' * make a new FIDXT tab file
'
6020 IF TFastFileList$ = "" THEN
        TFastFileList$ = ZFastFileList$
     END IF
     DIM StartPos(36)
     CharsCounted$ = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ"
     CLOSE 2
     CALL OpenWork (2,TFastFileList$)
     FOR i = 1 TO 36
        StartPos(i) = 0
     NEXT
     IndexPos = 1
     LinesRead = 0
     WHILE NOT EOF(2)
        LINE INPUT #2, A$
        LinesRead = LinesRead + 1
        IndexChar$ = MID$(A$, IndexPos, 1)
        Position = INSTR(CharsCounted$, IndexChar$)
        IF Position > 0 THEN
           IF StartPos(Position) = 0 THEN
              StartPos(Position) = LinesRead
           END IF
        END IF
     WEND
     CLOSE 2
     CALL BreakFileName (TFastFileList$,Pre$,Body$,Ext$,ZTrue)
     FastTabFile$ = Pre$ + Body$ + "T" + Ext$
     CALL OpenRSeq (2,FastTabFile$,HighRec,WasX,72)
     CALL QuickTPut1(ZFG2$ + "Re-Indexing " + ZFGB$ + _
                     FastTabFile$ + ZEmphasizeOff$)
     FIELD #2, 72 AS OutRec$
     PrevValue = 0
     i = 1
     WHILE i < 37 AND StartPos (i) = 0
        StartPos (i) = 1
        i = i + 1
     WEND
     i = 36
     WHILE i > 0 AND StartPos(i) = 0
        i = i - 1
     WEND
     StartPos(36) = StartPos(i)
     FOR i = 36 TO 1 STEP -1
        IF StartPos(i) = 0 THEN
           CurrentValue = 1
           IF PrevValue > CurrentValue THEN
              CurrentValue = PrevValue
           END IF
        ELSE
           CurrentValue = StartPos(i)
        END IF
        StartPos(i) = CurrentValue
        PrevValue = CurrentValue
     NEXT
     FOR i = 1 TO 36
        MID$(OutRec$, 1 + 2 * (i - 1), 2) = MKI$(StartPos(i))
     NEXT
     PUT 2, 1
     CLOSE 2
     RETURN
'
' =============================================================================
' * Update the MASTER.DIR or PERSONAL DIR file
' =============================================================================
'
7000 CALL BreakFileName (SourceFileName$,SourceDrive$, _
                         SourceBody$,SourceExt$,ZTrue)
     CALL BreakFileName (ZPersonalDir$,PerPre$,PerBody$,PerExt$,ZFalse)
     DeleteFile$ = SourceBody$ + SourceExt$
     IF InPers THEN
        CALL QuickTPut1(ZFG2$ + "Rebuilding " + ZFGB$ + _
                        ZPersonalDir$ + ZEmphasizeOff$)
        FSize = 12 + 21 + ZMaxDescLen + (5 * ZShowTimesDownloaded) + ZPersonalLen + 1 + 2
        CALL OpenRSeq (2,ZPersonalDir$,HighRec,WasX,FSize)
        FIELD #2, 12 AS FileName$, _
                  21 + ZMaxDescLen + (5 * ZShowTimesDownloaded) AS FileDesc$, _
                  ZPersonalLen + 1 AS FilePers$, _
                   2 AS FileChar$
        CALL OpenRSeq (7,PerPre$ + "\" + PerBody$ + ".$$$",XX,XX,FSize)
        FIELD #7, 12 AS WorkFileName$, _
                  21 + ZMaxDescLen + (5 * ZShowTimesDownloaded) AS WorkFileDesc$, _
                  ZPersonalLen + 1 AS WorkFilePers$, _
                   2 AS WorkFileChar$
     ELSE
        CALL QuickTPut1(ZFG2$ + "Rebuilding " + ZFGB$ + _
                        TDirPath$ + TMainFMSDir$ + "." + _
                        TMainDirExtension$ + ZEmphasizeOff$)
        FSize = 12 + 10 + 11 + TMaxDescLen + 3 + 2
        CALL OpenRSeq (2,TDirPath$ + TMainFMSDir$ + "." + _
                       TMainDirExtension$,HighRec,WasX,Fsize)
        FIELD #2, 12 AS FileName$, _
                  10 AS FileSize$, _
                  11 AS FileDate$, _
                  TMaxDescLen + 1 AS FileDesc$, _
                   4 AS FileCat$
        CALL OpenRSeq (7,TDirPath$ + TMainFMSDir$ + ".$$$",XX,XX,FSize)
        FIELD #7, 12 AS WorkFileName$, _
                  10 AS WorkFileSize$, _
                  11 AS WorkFileDate$, _
                  TMaxDescLen + 1 AS WorkFileDesc$, _
                   4 AS WorkFileCat$
     END IF
     '*
     '* Parse the list to look for possible extended descriptions
     '*
     SourceCount = HighRec
     LastWasIt = ZFalse
     FOR InCount = HighRec TO 1 STEP -1
        GET 2, InCount
        IF DeleteFile$ + SPACE$(12-LEN(DeleteFile$)) <> FileName$ THEN
           IF LastWasIt = ZTrue THEN
              IF LEFT$(FileName$,1) = SPACE$(1) THEN
                 SourceCount = SourceCount - 1
              ELSE
                 LastWasIt = ZFalse
              END IF
           END IF
        ELSE
           LastWasIt = ZTrue
           SourceCount = SourceCount - 1
        END IF
     NEXT InCount
     '*
     '* rebuild the file list
     '*
     OutCount = SourceCount
     LastWasIt = ZFalse
     FOR InCount = HighRec TO 1 STEP -1
        GET 2, InCount
        '*
        '* check for extended on the deleted file
        '*
        IF LastWasIt = ZTrue THEN
           IF LEFT$(FileName$,1) = SPACE$(1) THEN
              LastWasIt = ZTrue
           ELSE
              LastWasIt = ZFalse
           END IF
        END IF
        IF DeleteFile$ + SPACE$(12-LEN(DeleteFile$)) <> FileName$ THEN
           IF LastWasIt = ZFalse THEN
              IF InPers THEN
                 LSET WorkFileName$ = FileName$
                 LSET WorkFileDesc$ = FileDesc$
                 LSET WorkFilePers$ = FilePers$
                 LSET WorkFileChar$ = FileChar$
              ELSE
                 LSET WorkFileName$ = FileName$
                 LSET WorkFileSize$ = FileSize$
                 LSET WorkFileDate$ = FileDate$
                 LSET WorkFileDesc$ = FileDesc$
                 LSET WorkFileCat$ = FileCat$
              END IF
              PUT 7, OutCount
              OutCount = OutCount - 1
           ELSE
              CALL QuickTPut1 (ZFG2$ + "Removing Extended " + _
                            "Description" + ZEmphaisizeOff$)
           END IF
        ELSE
           LastWasIt = ZTrue
           CALL QuickTPut1 (ZFG2$ + "Found " + ZFGB$ + _
                            DeleteFile$ + ZFG2$ + _
                            " - Removing Entry" + ZEmphaisizeOff$)
        END IF
     NEXT InCount
     CLOSE 2
     CLOSE 7
     '*
     '* kill the old listing and rename the new one
     '*
     IF InPers THEN
        CALL KillWork (ZPersonalDir$)
        NAME PerPre$ + "\" + PerBody$ + ".$$$" AS ZPersonalDir$
     END IF
     IF InFMS THEN
        CALL KillWork (TDirPath$ + TMainFMSDir$ + "." + _
                       TMainDirExtension$)
        NAME TDirPath$ + TMainFMSDir$ + ".$$$" AS TDirPath$ + _
             TMainFMSDir$ + "." + _
             TMainDirExtension$
     END IF
     RETURN
'
' =============================================================================
' * Input SourceFileName for Action
' =============================================================================
'
8000 GOSUB 11000
     IF ZWasQ = 0 THEN
        RETURN
     END IF
     SourceFileName$ = ZUserIn$(ZAnsIndex)
     CALL AllCaps (SourceFileName$)
     CALL BreakFileName (SourceFileName$,SourceDrive$, _
                         SourceBody$,SourceExt$,ZTrue)
     Found = ZFalse
     IF Action$ = "ADD" THEN
        CALL FindIt (SourceFileName$)
        IF ZOK THEN
           Found = ZTrue
           RETURN
        END IF
     ELSE
        SourceFileName$ = SourceBody$ + SourceExt$
        CALL FindIt (ZPersonalDrvPath$ + SourceBody$ + SourceExt$)
        IF ZOK THEN
           Found = ZTrue
           IF Action$ = "FIND" OR Action$ = "MOVE" THEN
              SourceFileName$ = ZPersonalDrvPath$ + SourceBody$ + SourceExt$
              RETURN
           END IF
           DO
              ZOutTxt$ = ZFGB$ + Action$ + SPACE$(1) + ZFG2$ + _
                         SourceBody$ + SourceExt$ + _
                         ZFGB$ + " from " + ZFG2$ + ZPersonalDrvPath$ + _
                         ZEmphasizeOff$ + " (Y)es,[N]o,A)bort)"
              GOSUB 11100
           LOOP Until ZWasQ = 0 OR INSTR("YNA",ZWasZ$) <> 0
           IF ZWasZ$ = "A" THEN
              Found = ZFalse
              ZAnsIndex = 0
              RETURN
           END IF
           IF ZWasZ$ = "Y" THEN
              InPers = ZTrue
              InFMS = ZFalse
              SourceFileName$ = ZPersonalDrvPath$ + SourceBody$ + SourceExt$
              RETURN
           END IF
           Found = ZFalse
        END IF
        FOR WasX = 1 TO ZSubDirCount - 1
           CALL FindIt (ZSubDir$(WasX) + SourceBody$ + SourceExt$)
           IF ZOK THEN
              Found = ZTrue
              IF Action$ = "FIND" OR Action$ = "MOVE" THEN
                 SourceFileName$ = ZSubDir$(WasX) + SourceBody$ + SourceExt$
                 RETURN
              END IF
              ZOutTxt$ = ZFGB$ + Action$ + SPACE$(1) + ZFG2$ + _
                         SourceBody$ + SourceExt$ + _
                         ZFGB$ + " from " + ZFG2$ + ZSubDir$(WasX) + _
                         ZEmphasizeOff$ + " (Y)es,[N]o,A)bort)"
              GOSUB 11100
              IF ZWasZ$ = "A" THEN
                 Found = ZFalse
                 ZAnsIndex = 0
                 RETURN
              END IF
              IF ZWasZ$ = "Y" THEN
                 SourceFileName$ = ZSubDir$(WasX) + _
                                   SourceBody$ + SourceExt$
                 TDirPath$ = ZDirPath$
                 TMainFMSDir$ = ZMainFMSDir$
                 TMainDirExtension$ = ZMainDirExtension$
                 TMaxDescLen = ZMaxDescLen
                 TFastFileList$ = ZFastFileList$
                 TFastFileLocator$ = ZFastFileLocator$
                 RETURN
              END IF
              Found = ZFalse
           END IF
        NEXT WasX
        IF ZFastFileSearch THEN
           TFastFileLocator$ = ZFastFileLocator$
           CALL BreakFileName (ZFastFileList$,Drive$,Body$,Ext$,ZTrue)
           CALL FindIt (Drive$ + "SYSOP8.CFG")                       ' DD062802
           IF ZOK THEN                                               ' DD062802
              CALL OpenWork (7, Drive$ + "SYSOP8.CFG")               ' DD062802
           ELSE                                                      ' DD062802
              CALL FindIt (Drive$ + Body$ + ".LST")                  ' DD062802
              IF ZOK THEN                                            ' DD062802
                 CALL OpenWork (7,Drive$ + Body$ + ".LST")           ' DD062802
              END IF                                                 ' DD062802
           END IF                                                    ' DD062802
           LineToRead = 1
           IF ZOK THEN                                               ' DD062802
              IF ZErrCode <> 0 THEN
                 GOSUB 8010
                 GOTO 8020
              END IF
8005          CALL ReadParmsX (7,ZOutTxt$(),4,LineToRead)
              IF ZErrCode <> 0 AND ZOutTxt$(1) = "" THEN
                 CLOSE 7
                 GOTO 8020
              END IF
              TFastFileList$ = UCASE$(ZOutTxt$(1))
              TFastFileLocator$ = UCASE$(ZOutTxt$(2))
              CALL BreakFileName (UCASE$(ZOutTxt$(3)),TDirPath$, _
                                  TMainFMSDir$,TMainDirExtension$,ZFalse)
              TMaxDescLen = VAL(ZOutTxt$(4))
              GOSUB 8010
              IF ZWasZ$ = "Y" THEN
                 GOTO 8020
              END IF
              LineToRead = LineToRead + 1
              ZOutTxt$(1) = ""
              GOTO 8005
           ELSE
              GOSUB 8010
              GOTO 8020
           END IF
8010       CALL OpenRSeq (14,TFastFileLocator$,HighRec,WasX,66)
           FIELD 14, 66 AS Location$
           IF LineToRead = 1 THEN Start = 2 ELSE Start = 1
           FOR WasX = Start TO HighRec
              GET 14, WasX
              Select$ = LEFT$(Location$,63)
              CALL Trim (Select$)
              IF LEFT$(Select$,2) <> "M!" THEN
                 CALL FindIt (Select$ + SourceBody$ + SourceExt$)
                 IF ZOK THEN
                    Found = ZTrue
                    IF Action$ = "FIND" OR Action$ = "MOVE" THEN
                       SourceFileName$ = Select$ + SourceBody$ + SourceExt$
                       RETURN
                    END IF
                    ZOutTxt$ = ZFGB$ + Action$ + SPACE$(1) + ZFG2$ + _
                               SourceBody$ + SourceExt$ + _
                               ZFGB$ + " from " + ZFG2$ + Select$ + _
                               ZEmphasizeOff$ + " (Y)es,[N]o,A)bort)"
                    GOSUB 11100
                    IF ZWasZ$ = "A" THEN
                       Found = ZFalse
                       ZAnsIndex = 0
                       RETURN
                    END IF
                    IF ZWasZ$ = "Y" THEN
                       InFMS = ZTrue
                       LidxPos = WasX
                       SourceFileName$ = Select$ + SourceBody$ + SourceExt$
                       CLOSE 14
                       RETURN
                    END IF
                    Found = ZFalse
                 END IF
              END IF
           NEXT WasX
           CLOSE 14
           RETURN
        END IF
     END IF
8020 IF NOT Found THEN
        CALL QuickTPut1 (ZFGF$ + ZBG4$ + "ERROR! Could not find " + _
                        SourceBody$ + SourceExt$ + "!" + _
                        ZBG0$ + ZEmphasizeOff$)
     END IF
     RETURN
'
' =============================================================================
' * common input routine - single char
' =============================================================================
'
11000 ZSubParm = 1
      CALL TGet
      IF ZSubParm < 0 THEN _
         EXIT SUB
      RETURN
'
' =============================================================================
' * common input routine - string
' =============================================================================
'
11100 ZTurboKey = -ZTurboKeyUser
      CALL PopCmdStack
      IF ZSubParm < 0 THEN _
         EXIT SUB
      ZWasZ$ = UCASE$(ZUserIn$(ZAnsIndex))
      RETURN
'
' =============================================================================
' * End of SYSOP8
' =============================================================================
'
      END SUB
'
' =============================================================================
' * Error Handling
' =============================================================================
'
12000 ZOutTxt$ = "SYSOP8 Untrapped Error" + _
           STR$(ERR) + _
           " in line" + _
           STR$(ERL)
      IF ZPrinter THEN
         CALL Printit(ZOutTxt$)
      END IF
      CALL QuickTPut1 (ZOutTxt$)
      CALL UpdtCalr (ZOutTxt$,2)
      ZErrCode = ERR
      RESUME NEXT
