{$N-,E- no math support needed}
{$X- function calls may not be discarded}
{$I- disable I/O checking (trap errors by checking IOResult)}

UNIT ArcID;

(* A Pascal unit which will determine most major archive types.
   To use this unit, simply call the function as follows:

   FileID := IsArc (FileName.Ext);
   IF FileID = 'ZIP' THEN ...

Returns a null string if unable to identify, otherwise one of these:
 ARC, ARJ, HA, HPACK, HYPER, LHA, PAH, PAK, RAR, SQZ, UC2, ZIP, ZOO

*)
INTERFACE

FUNCTION IsArc (FName : STRING) : STRING;

IMPLEMENTATION

FUNCTION Byte_To_Hex(X : byte) : String;
CONST
  Digits : array [0..15] of char = '0123456789ABCDEF';

BEGIN { Byte_To_Hex }
  Byte_To_Hex := Concat(Digits[X shr 4],Digits[X and 15]);
END; { Byte_To_Hex }

FUNCTION StrToHex (str: STRING; len: BYTE): STRING;
VAR
  NewStr : STRING;
  Index : WORD;
BEGIN
  NewStr := '';
  For Index := 1 to len DO
    NewStr := NewStr + Byte_To_Hex (Ord (str [Index]));
  StrToHex := NewStr;
END;

FUNCTION IsArc (FName : STRING) : STRING;
LABEL
  Exit;
VAR
  ArcFile : FILE;
  ArcID   : STRING;
  IDarr   : Array[1..64] OF CHAR;
  IDStr,
  IDStrh,
  IDhex   : STRING;
  Index,
  BytesRead : INTEGER;

BEGIN
  ArcID := '';  {If none of the above}
  Assign (ArcFile, FName);
  Reset (ArcFile,1);
  IF IOResult <> 0 THEN
    ArcID := 'Error'
  ELSE BEGIN
    BlockRead (ArcFile, IDarr, SizeOf (IDarr), BytesRead);
    Close (ArcFile);

    IDStr[0] := Chr (64);
    Move (IDarr[1], IDStr[1], BytesRead);
    IDStrh := StrToHex (IDStr, 64);

    {UC2}
      IDhex := '5543321A';
      IF Copy (IDStrh, 1, length (IDhex)) = IDhex THEN
         BEGIN ArcID := 'UC2'; Goto Exit END;

    {RAR}
      IDhex := '526172';
      IF Copy (IDStrh, 1, length (IDhex)) = IDhex THEN
         BEGIN ArcID := 'RAR'; Goto Exit END;

    {SQZ}
      IDhex := '484C53515A';
      IF Copy (IDStrh, 1, length (IDhex)) = IDhex THEN
         BEGIN ArcID := 'SQZ'; Goto Exit END;

    {ZIP}
      IDhex := '504B';
      IF Copy (IDStrh, 1, length (IDhex)) = IDhex THEN
         BEGIN ArcID := 'ZIP'; Goto Exit END;

    {ZIP SFX}
      IDhex := '4D5AEF01190000000600D10CFFFF2003000400000001F0FF1E000000000'+
      '1436F7079726967687420313938392D3139393020504B5741524520496E632E20416C';
      IF Copy (IDStrh, 1, length (IDhex)) = IDhex THEN
         BEGIN ArcID := 'ZIP'; Goto Exit END;
      IDhex := '4D5A76010600000002000206FFFFF0FF706700000001F0FF1E000000000'+
      '00000B87067A34E0CBF560CB9705F2BCF32C0F3AAB430CD21A3520CA12C00A3500CE8';
      IF Copy (IDStrh, 1, length (IDhex)) = IDhex THEN
         BEGIN ArcID := 'ZIP'; Goto Exit END;
      IDhex := '4D5A99011F0001000600890CFFFF0000206100000001F0FF52000000141'+
      '1504B4C49544520436F70722E20313939302D393220504B5741524520496E632E2041';
      IF Copy (IDStrh, 1, length (IDhex)) = IDhex THEN
         BEGIN ArcID := 'ZIP'; Goto Exit END;
      IDhex := '4D5ABA01060000000200890B0010F0FF1CC000000001F0FF1E000000000'+
      '00000B91CBABF9A0C2BCF32C0F3AAB430CD21A302BA892614BAE83300B8A80AE8D401';
      IF Copy (IDStrh, 1, length (IDhex)) = IDhex THEN
         BEGIN ArcID := 'ZIP'; Goto Exit END;

    {HPACK}
      IDhex := '4850414B';
      IF Copy (IDStrh, 1, length (IDhex)) = IDhex THEN
         BEGIN ArcID := 'HPACK'; Goto Exit END;

    {HAP/PAH}
      IDhex := '91334846';
      IF Copy (IDStrh, 1, length (IDhex)) = IDhex THEN
         BEGIN ArcID := 'PAH'; Goto Exit END;

    {ZOO}
      IDhex := 'DCA7C4FD';
      IF Copy (IDStrh, 41, length (IDhex)) = IDhex THEN
         BEGIN ArcID := 'ZOO'; Goto Exit END;

    {ZOO - MS DOS}
      IDhex := '5A4F4F'; {ZOO - only at beginning on MS-DOS machines!}
      IF Copy (IDStrh, 1, length (IDhex)) = IDhex THEN
         BEGIN ArcID := 'ZOO'; Goto Exit END;

    {LHA}
      IDhex := '2D6C68';
      IF Copy (IDStrh, 5, length (IDhex)) = IDhex THEN
         BEGIN ArcID := 'LHA'; Goto Exit END;

    {LHA SFX}
      IDhex := '4D5A99010400000002000010FFFFF0FF000100000001F0FF1C000000000'+
      '00000EB7920004C484127732053465820322E31334C2028632920596F7368692C2031';
      IF Copy (IDStrh, 1, length (IDhex)) = IDhex THEN
         BEGIN ArcID := 'LHA'; Goto Exit END;
      IDhex := '4D5A64000400000002000010FFFFF0FF000100000001F0FF1C000000000'+
      '00000EB7920004C484127732053465820322E3133532028632920596F7368692C2031';
      IF Copy (IDStrh, 1, length (IDhex)) = IDhex THEN
         BEGIN ArcID := 'LHA'; Goto Exit END;

    {HA}
      IDhex := '4841';
      IF Copy (IDStrh, 1, length (IDhex)) = IDhex THEN
         BEGIN ArcID := 'HA'; Goto Exit END;

    {ARJ}
      IDhex := '60EA';
      IF Copy (IDStrh, 1, length (IDhex)) = IDhex THEN
         BEGIN ArcID := 'ARJ'; Goto Exit END;

    {ARJ SFX}
      IDhex := '4D5A0A001E0000000200640FFFFF3D05800000000E0088031C000000524'+
      'A5358FFFFBA40042E89163A02B430CD218B2E02FFFF008B1E2C008EDAA390008C068E';
      IF Copy (IDStrh, 1, length (IDhex)) = IDhex THEN
         BEGIN ArcID := 'ARJ'; Goto Exit END;
      IDhex := '4D5AD1000B0000000200120EFFFFCB01800000000E0035011C000000524'+
      'A5358FFFFBA62012E89163A02B430CD218B2E02FFFF008B1E2C008EDAA390008C068E';
      IF Copy (IDStrh, 1, length (IDhex)) = IDhex THEN
         BEGIN ArcID := 'ARJ'; Goto Exit END;

    {HYPER}
      IDhex := '1A4850';
      IF Copy (IDStrh, 1, length (IDhex)) = IDhex THEN
         BEGIN ArcID := 'HYPER'; Goto Exit END;

    {PAK}
      IDhex := '1A0A';
      IF (IDStr[1] = #$1a) AND ((IDStr[2] = #$0a) OR (IDStr[2] = #$0b)) THEN
         BEGIN ArcID := 'PAK'; Goto Exit END;

    {PAK SFX}
      IDhex := '4D5AD3000E00060020007900FFFF8E0180070000E10900003E000000010'+
      '0FB306A7200000000000000000000000000000000000000000000000000000000A605';
      IF Copy (IDStrh, 1, length (IDhex)) = IDhex THEN
         BEGIN ArcID := 'PAK'; Goto Exit END;

    {ARC}
      IDhex := '1A';
      IF Copy (IDStrh, 1, length (IDhex)) = IDhex THEN
         BEGIN ArcID := 'ARC'; Goto Exit END;
  END;
  Exit:
  IsArc := ArcID;
END;

END.
