/*
 *  SAMPLE.H
 *
 *  Copyright (C) 1991 by Daytris.  All rights reserved.
 */

/* Database record typedefs */
typedef struct client CLIENT;
typedef struct address ADDRESS;
typedef struct setup SETUP;

/* menu defines */
#define IDM_EXIT            200
#define IDM_ABOUT           210
#define IDM_ADD             220
#define IDM_UPDATE          230
#define IDM_DELETE          240
#define IDM_SORT_BY_NUMBER  250
#define IDM_SORT_BY_NAME    260

/* main window dialog defines */
#define IDC_CLIENT_LISTBOX  100

/* client window dialog defines */
#define IDC_CLIENT_INFO     100
#define IDC_NUMBER          110
#define IDC_NAME            120
#define IDC_DESC            130
#define IDC_BALANCE         140
#define IDC_EDIT_NUMBER     150
#define IDC_EDIT_NAME       160
#define IDC_EDIT_DESC       170
#define IDC_EDIT_BALANCE    180
#define IDC_ADDR_INFO       190
#define IDC_ADDR_LISTBOX    200
#define IDC_ADD_ADDR        210
#define IDC_UPDATE_ADDR     220
#define IDC_DELETE_ADDR     230

/* address window dialog defines */
#define IDC_STREET          100
#define IDC_CITY            110
#define IDC_STATE           120
#define IDC_ZIP             130
#define IDC_TEL             140
#define IDC_FAX             150
#define IDC_EDIT_STREET     160
#define IDC_EDIT_CITY       170
#define IDC_EDIT_STATE      180
#define IDC_EDIT_ZIP        190
#define IDC_EDIT_TEL        200
#define IDC_EDIT_FAX        210

/* Client listbox defines */
#define LISTBOX_X       2
#define LISTBOX_Y       2
#define LISTBOX_LENGTH  8
#define LISTBOX_WIDTH   47
#define WINDOW_LENGTH   (LISTBOX_LENGTH + LISTBOX_Y)
#define WINDOW_WIDTH    (LISTBOX_WIDTH + (LISTBOX_X * 2))

/* Data declarations */
extern HANDLE hInst;
extern HANDLE hDb;
extern HWND hWndClientLB;
extern BOOL bSortByNumber;
extern SETUP setup;

/* sclient.c */
BOOL AddClientDlg( HWND hWnd);
BOOL UpdateClientDlg( HWND hWnd);
BOOL DeleteClientDlg( HWND hWnd);

/* saddress.c */
BOOL AddAddressDlg( HWND hWnd);
BOOL UpdateAddressDlg( HWND hWnd);
BOOL DeleteAddressDlg( HWND hWnd);

/* sabout.c */
void AboutDlg( HWND hWnd);

/* slistbox.c */
BOOL LoadClientListBox( HWND hWnd);
BOOL AddToClientListBox( HWND hWnd, CLIENT *pClient);
BOOL DeleteFromClientListBox( HWND hWnd, short nIndex);
BOOL LoadAddressListBox( HWND hWnd);
BOOL AddToAddressListBox( HWND hWnd, ADDRESS FAR *lpAddress);
BOOL DeleteFromAddressListBox( HWND hWnd, short nIndex);
HANDLE GetAddressHandle( HWND hWnd, short nIndex);

/* serror.c */
void DbError( HWND hWnd, DWORD dwError, PSTR pFile, WORD wLineNbr);
