/* This REXX script is used to remove all CD in a Box Files */
/* from your Hard Disk and to remove the entry from the */
/* OS2.INI File */

/* setup Rexx SysFunc */
call RXFUNCADD 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
call SysLoadFuncs

Program = "CDInABox"
File.0 = 5
File.1 = 'CDinaBox.EXE'
File.2 = 'CDinaBox.INI'
File.3 = 'CDinaBox.DAT'
File.4 = 'CDinaBox.INF'
File.5 = 'CDBoxout.CMD'
rc = 0

Call SysCls

Say ''
Say ''

   /* Confirm deletion */
Say 'Do You wish to remove CD in a Box from your system?'
Say 'Enter Y or N '
PARSE UPPER PULL Option

if Option = 'Y' then
   DO

   /* Delete files */
Say 'Removing Files'
do index = 1 to File.0
   rc = SysFileDelete( File.index )
   select
      when rc = 0 then
         Say File.index' Removed Ok'
      when rc = 2 then
         Say File.index' could not be Found!!'
      Otherwise
         Say 'An Error Occured Removing 'File.index
   end /* end Select rc */
end /* do index = 1 to file.0 */

Say ''
   /* Remove Data from OS2.INI File */
Say 'Removing Entry From OS2.INI File'
rc = SysIni( 'USER', Program, 'ALL:', 'Names.')

if Names.0 = 0 then
      DO
   Say 'No Entry Found for CD in a Box.'
      END /* end if names.0 = 0 */
else /* else names.0 = 0 */
      DO
   rc = SysIni( 'USER', Program, 'DELETE:')

   if rc = 'ERROR:' then
         DO
      Say 'An Error occured Removing the Entry for CD in a Box'
         END /* end if rc = error */
   else /* else rc = error */
         DO
      Say 'CD in a Box Entry Removed Ok.'
         END /* end else if rc = error */
      END /* end else if names.0 = 0 */

Say ''
Say 'Thank You For Trying CD in a Box.   I Hope you Found it Useful.'

   END /* end if option = Y */

