#---------------------------------------------------------------------------
#
#       MAKEFILE.MAK: makefile for DOS coroutine library.
#       Copyright (c) J.English 1993.
#
#       Permission is granted to use copy and distribute the
#       information contained in this file provided that this
#       copyright notice is retained intact and that any software
#       or other document incorporating this file or parts thereof
#       makes the source code for the TSR class of which this file
#       is a part freely available.
#
#---------------------------------------------------------------------------

.AUTODEPEND
.SILENT

#----- Symbol definitions -----

DIR   = d:\borlandc                 # Borland C++ directory -- change to suit
MODEL = s                           # Memory model (s, m, l, c, h or t)
CC    = bcc -m$(MODEL) -I$(INC)\include -L$(LIB)\lib

#----- Default compilation rule -----

.cpp.obj:
    $(CC) -c $.

#----- Compilation rules -----

all: example1.exe example2.exe example3.exe

example1.exe: example1.obj coroutin.obj
    $(CC) example1.obj coroutin.obj

example2.exe: example2.obj coroutin.obj
    $(CC) example2.obj coroutin.obj

example3.exe: example3.obj coroutin.obj
    $(CC) example3.obj coroutin.obj

example1.obj: example1.cpp
example2.obj: example2.cpp
example3.obj: example3.cpp

#----- Other targets -----

clean:                              # clean up directory
    del *.obj

print:                              # print sources
    print *.doc *.mak *.h *.cpp
