	;MASM MODE
	.386p
	.model small

include  prints.ase 
include  input.ase 
include  mtrap.ase 

DUMPLEN = 80h
	PUBLIC	dump
	extrn put_pure : proc, put_msg:proc

	.data
index	dd	0		; Default for next dump

	.code
;
; Dump one line
;
dumpline	PROC	
	push	edx
	push	ebx        		; EBX MUST be on second of stack
	push	ecx			; ECX MUST be on top of stack
	sub	eax,eax
	mov	al,bl  		; AL = lower byte of address
	and	al,15		; AL = lower nibble
	mov	ecx,16		; Total bytes to dump
	jz	short doline	; Go do hexdump if start of line = 0
	neg	al		; Else calculate number of bytes in line
	add	al,16		;
	mov	ecx,eax		; To ECX

doline:
	sub	[esp],ecx	; Decrement count which is on stack
	add	[esp+4],ecx	; Increment address which is on stack
	mov	al,16		; Get count of amount to space over
	sub	al,cl		;
	jz	short puthex	; Don't space over any, just put out hex

	push	ecx		; Else ecx = spacecount * 3
	mov	ecx,eax		;
	add	ecx,ecx		;
	add	ecx,eax		;
blanklp1:
	call	printspace      ; Dump spaces
	loop	blanklp1	;
	pop	ecx

puthex:                         ; Save count and address for ASCII dump
	push	ecx		;
	push	esi		;
hexlp:
	call	printspace	; Print a space
	mov	al,[esi]	; Get the byte
	inc	esi		; Increment the address pointer
	call	printbyte	; Print byte in hex
	loop	hexlp		; Loop till done
	pop	esi		;
	pop	ecx		;

	call	printspace	; Print two spaces to seperate ASCII dump
	call	printspace	;

	sub	eax,eax		; Calculate amoun to space over
	mov	al,16		;
	sub	al,cl		;
	jz	short putascii	; None to space over, put ascii
	push	ecx		; ECX = space value
	mov	ecx,eax
blanklp2:
	call	printspace	; Space over
	loop	blanklp2	;
	pop	ecx		;

putascii:
	mov	dl,[esi]	; Get char
	inc	esi		; Increment buffer
	call	put_pure
	loop	putascii
	pop	ecx		; Get count from stack
	pop	ebx		; Get address from stack
	pop	edx		; Restore EDX
	ret
dumpline	ENDP	
;
; Main DUMP routine
;
dump	PROC	
	call	PageTrapErr	; Enable error on page trap
	mov	ecx,DUMPLEN	; Default amount to dump
	call	WadeSpace	; Wade to end of spaces
	cmp	al,13		; If no numbers, we just use the old default
	jz	short atIndex	;
	call	ReadAddress	; Else read start address
	jc	dudone		; Quit on error
	call	WadeSpace	; Wade through spaces
	cmp	al,13		; If no numbers, just use the default
	jz	short dodump	;
	call	ReadNumber	; Else read end offset
	jc	short dudone	;
	sub	eax,ebx		; Calculate length of dump
	mov	ecx,eax		;
	jmp	short dodump	; Go do dump
atIndex:
	mov	ebx,[index]	; Assume we want to dump from last index
dodump:
	
	mov	esi,ebx
dumplp:
	push	ebx		;
	mov	ebx,offset CRLF
	call	put_msg
	pop	ebx		;
	mov	eax,ebx		;
	and	eax,0fffffff0h  ; Address low nibble = 0
	call	printdword	; Print address
	call	dumpline	; Dump a line
	or	ecx,ecx		; Continue while count > 0
	jg	dumplp		;
	mov	[index],ebx	; Save new index value
	clc			; No errors
dudone:
	pushfd			; Save error flag
	call	PageTrapUnerr	; Disable page traps
	popfd			; Restore error flag
	ret
dump	ENDP	
END