#include <stdio.h>
#include <time.h>
#include <libp.h>

int _readbuf(FILE *stream)
{
	if (!(stream->flags & _F_IN) || !stream->level) {
		if (stream->flags & _F_OUT) {
			if (fflush(stream))
				return EOF;
		}
		stream->flags &= ~_F_OUT;
		if (!(stream->flags & _F_IN)) {
			stream->level = 0;
			stream->curp = stream->buffer;
			stream->hold = 0;
		}
		stream->flags |= _F_IN;
		if (!stream->level) {
			stream->curp = stream->buffer;
			if (stream->flags & _F_LBUF) {
				while (stream->level < stream->bsize) {
					int sz = _ll_read(stream->fd,stream->curp,1);
					if (!sz)
						break;
					stream->level++;
					if ((*stream->curp == '\n') || (*stream->curp == '\r'))
						break;
					stream->curp++;
				}
				stream->curp = stream->buffer;
			}
			else 
				stream->level = _ll_read(stream->fd,stream->buffer,stream->bsize);
		}
	}
	if (stream->level == 0) {
		stream->flags |= _F_EOF;
		return EOF;
	}
	return 0;
}