PROGRAM GETACTSL;

USES DOS;

TYPE

    SystemRec           = RECORD
      BaudRate          : WORD;       { baud rate user is at      }
      ComPort           : BYTE;       { comport currently in user }
      Name              : STRING[51]; { system name               }
      Sysop             : STRING[51]; { sysop's name              }
      TimeOn            : LONGINT;    { time user logged on       }
      TimeUsed          : LONGINT;    { time used so far          }
      Uk                : WORD;       { # of k uploaded by user   }
      Uploads           : WORD;       { # of uploads by user      }
      Dk                : WORD;       { # of k downloaded by user }
      Downloads         : WORD;       { # of downloads by user    }
      Databits          : BYTE;       { databits modem is set to  }
      Stopbits          : BYTE;       { stop bits modem is set to }
      Parity            : CHAR;       { parity modem is set to    }
    END;

    UserRec             = RECORD
      UserNumb          : WORD;        { users number on BBS       }
      Name              : STRING[30];  { user's alias              }
      RealName          : STRING[14];  { user's real name          }
      LastOn            : STRING[10];  { date user was last on     }
      LineLen           : BYTE;        { # of columns              }
      PageLen           : BYTE;        { # of screen rows          }
      SL                : BYTE;        { security level            }
      Age               : BYTE;        { age                       }
      Sex               : CHAR;        { sex ('F' or 'M')          }
      Callsign          : STRING[8];   { amatuer radio callsign    }
      Gold              : REAL;        { game money                }
      timerem           : LONGINT;     { Time remaining in secs    }
    END;

VAR

   RestoreF            : FILE;
   RestoreB            : ARRAY[1..3000] OF BYTE;
   bytesread           : WORD;

   SysOpLog            : TEXT;
   gfilespath,
   datapath,
   SysOpFFN            : STRING;
   thesysop,
   cosysop,
   okANSI,
   remote              : BOOLEAN;
   TheUser             : UserRec;
   TheSystem           : SystemRec;


FUNCTION Exist(fn : STRING) : BOOLEAN;
  VAR
    s : SearchRec;
  BEGIN
    FindFirst(fn,anyfile,s);
    Exist := DosError = 0;
  END;

PROCEDURE GetParameterFile;
  VAR
    chainfile : TEXT;
    r         : REAL;
    n         : INTEGER;
    i         : STRING;
    error     : BOOLEAN;
  BEGIN
    IF (ParamCount <> 1) THEN BEGIN
      Writeln(^g,^g,'[>ERROR<] - CHAIN.TXT PATH/FILENAME NOT FOUND ON COMMAND LINE');
      HALT(1);
    END;

    IF NOT Exist(paramstr(1)) THEN BEGIN
      Writeln(^g,^g,'[>ERROR<] - UNABLE TO FIND FILE "',paramstr(1),'"');
      HALT(1);
    END;

    Assign(chainfile,paramstr(1));
    Reset(chainfile);
    IF (IOResult <> 0) THEN BEGIN
      Writeln(^g,^g,'[>ERROR<] - ERROR READING FILE "'+paramstr(1),'"');
      HALT(1);
    END;
    ReadLN(chainfile, TheUser.UserNumb);
    ReadLN(chainfile, TheUser.name);
    ReadLN(chainfile, TheUser.realname);
    ReadLN(chainfile, i);
    ReadLN(chainfile, TheUser.age);
    ReadLN(chainfile, TheUser.sex);
    ReadLN(chainfile, i);
    ReadLN(chainfile, i);
    ReadLN(chainfile, TheUser.linelen);
    ReadLN(chainfile, TheUser.pagelen);
    ReadLN(chainfile, TheUser.sl);
    ReadLN(chainfile, n);
    cosysop := (n = 1);
    ReadLN(chainfile, n);
    thesysop := (n = 1);
    ReadLN(chainfile, n);
    OkANSI := (n = 1);
    ReadLN(chainfile, n);
    remote := (n = 1);
    ReadLn(chainfile,r);
    TheUser.timerem := TRUNC(r);
    ReadLN(chainfile, GFilesPath);
    ReadLN(chainfile, DataPath);
    ReadLN(chainfile, i);
    SysopFFN := GFilesPath + i;
    ReadLn(chainfile, i);
    ReadLN(chainfile, TheSystem.comport);
    ReadLN(chainfile, TheSystem.name);
    ReadLN(chainfile, TheSystem.Sysop);
    ReadLN(chainfile, TheSystem.TimeOn);
    ReadLN(chainfile, TheSystem.timeused);
    Close(chainfile);
  END;

PROCEDURE ExamineRestore;
  VAR
    xx : WORD;
  BEGIN
    Assign(RestoreF,'RESTORE.WWV');
    Reset(RestoreF,1);
    IF IOResult <> 0 THEN BEGIN
      Writeln(' You must shrink to create RESTORE.WWV ');
      HALT;
    END;
    BlockRead(RestoreF,RestoreB,2900,bytesread);
    Close(RestoreF);
    FOR xx := 1 TO bytesread DO
      IF RestoreB[xx] = TheUser.Sl THEN
        Writeln(' Possible Match occured at : ',xx);
  END;

BEGIN
  GetParameterFile;
  Writeln;
  Writeln;
  Writeln('Security level found in CHAIN.TXT was : ',TheUser.sl);
  ExamineRestore;
  Writeln;
  Writeln('Most like occurence that will be valid for actsl will be after');
  Writeln('location 250,  nearer to 265');
  Writeln('You can use the information provided here to correctly enter a');
  Writeln('value for CBVCFG.USERREC entry "RESTORE.WWV ACTSL offset"');
  Writeln;
END.
