UNIT CBVVAR;    (* contains variables specific to WWIV version *)

INTERFACE

CONST

    _version            = 'WWIV-CBV 1.60 ';

    _autoconfigfile     = 'AUTOCFG.CBV';
    _restore            = 'RESTORE.WWV';
    _config             = 'CBVCFG.DAT';
    _user_file          = 'USER.LST';
    _versionflag1       = 1150000150;
    _versionflag2       = 1000150000;

TYPE

    ConfigRec           = RECORD
      header            : STRING[15];

      use_note_field,
      compare_fons,                    (* compare userrec.phone 2 entry?? *)
      update_trash,
      allow_ld,
      allow_out_ld,
      CTS_RTS,
      hangup_after,
      wwiv_421,
      use_callfile,                    (* CANCALL.DAT - ac-pr to only call *)
      direct_write,
      quite_mode,                      (* option requested by Apolloyn *)
      allow_toll        : BOOLEAN;     (* new option *)

      retry_attempts,
      delay_time,
      drop_delay,
      min_time,                        (* min time granted for door use *)
      hang_time,                       (* no entry hangup time *)
      max_SL,

      LC_SL,                           (* New SL when validated *)
      LC_DSL,                          (* New DSL when validated *)
      LC_exempt,                       (* New Exempt when validated *)
      LD_SL,                           (* New SL when Long-Dist validated *)
      LD_DSL,
      LD_exempt        : BYTE;

      IRQLevel,

      LC_AR,                           (* ARs when validated *)
      LC_DAR,
      LC_REST,
      LD_AR,
      LD_DAR,
      LD_REST          : WORD;

      bbs_areac,
      bbs_prefix,
      bbs_suffix       : STRING[4];

      LD_PREFIX        : STRING[20];

      dialcommand,                     (* command to dial on modem *)
      hangupcmd        : STRING[30];   (* command to hangup the modem *)

      bbsdirectory     : STRING[60];

      loc_actsl,                       (* byte location in restore.wwv *)
      userreclen,
      offset_name,
      offset_phone,
      offset_passwd,
      offset_note,
      offset_sl,
      offset_dsl,
      offset_exempt,
      offset_ar,
      offset_dar,
      offset_rest      : WORD;

      version1,
      version2,

      LastDate,                       (* for checking autocfg *)

      LD_WIN_START,
      LD_WIN_STOP      : LONGINT;

    END;

    ASCIIZ             = ARRAY[0..255] OF CHAR;

VAR
   file_buffer         : ARRAY[0..3071] OF CHAR;
   userfile            : FILE;

   Config              : ConfigRec;
   ConfigFile          : FILE OF ConfigRec;

IMPLEMENTATION

END.
