UNIT RBVVAR; (* contains variables specific to RENEGADE version *)

INTERFACE

CONST

    _version            = 'RENEGADE-CBV 0.97 ';

    _config             = 'CBVCFG.';
    _user_file          = 'USERS.DAT';
    _versionflag1       = 1100000100;
    _versionflag2       = 1000100000;

    maxbases=250;
    maxfbases=250;


TYPE

  acrq='@'..'Z';                  { Access Restriction flags }

  colors   = array[FALSE..TRUE,0..9] of byte; { Color tables }

  mzscanr  = set of 1..maxbases;                 { Which message bases to scan }
  fzscanr  = set of 1..maxfbases;                { Which file bases to scan }
  mhireadr = array[1..maxbases] of longint;      { Lastread pointers }


  uflags =
   (rlogon,                       { L - Limited to one call a day }
    rchat,                        { C - No SysOp paging }
    rvalidate,                    { V - Posts are unvalidated }
    ruserlist,                    { U - Can't list users }
    ramsg,                        { A - Can't post an auto message }
    rpostan,                      { * - Can't post anonymously }
    rpost,                        { P - Can't post }
    remail,                       { E - Can't send email }
    rvoting,                      { K - Can't use voting booth }
    rmsg,                         { M - Force email deletion }

    xreplace,                      { use me }
    xhotkey,                       { hotkey input mode }
    xavatar,                       { Supports Avatar }
    xxause,                        { screen pausing }
    xnovice,                       { user requires novice help }
    xansi,                         { Supports ANSI }
    xcolor,                        { Supports color }
    xalert,                        { Alert SysOp upon login }
    xsmw,                          { Short message(s) waiting }
    xnomail,                       { Mailbox is closed }

    fnodlratio,                   { 1 - No UL/DL ratio }
    fnopostratio,                 { 2 - No post/call ratio }
    fnofilepts,                   { 3 - No file points checking }
    fnodeletion);                 { 4 - Protected from deletion }

  suflags =
    (lockedout,                   { if locked out }
    deleted,                      { if deleted }
    trapactivity,                 { if trapping users activity }
    trapseparate,                 { if trap to seperate TRAP file }
    chatauto,                     { if auto chat trapping }
    chatseparate,                 { if separate chat file to trap to }
    slogseparate,                 { if separate SysOp log }
    clsmsg,                       { if clear-screens }
    avadjust,                     { if AVATAR color adjust }
    fseditor                      { if Full Screen Editor }
  );

  ACFF                  = SET OF ACRQ;
  ACRR                  = SET OF UFLAGS;


    ConfigRec           = RECORD
      header            : STRING[15];

      use_note_field,
      compare_fons,                    (* compare userrec.phone 2 entry?? *)
      update_trash,
      allow_ld,
      allow_out_ld,
      CTS_RTS,
      hangup_after,
      use_callfile,                    (* CANCALL.DAT - ac-pr to only call *)
      direct_write,
      quite_mode,                      (* option requested by Apolloyn *)
      allow_toll                       (* allow toll calls? *)
                       : BOOLEAN;

      retry_attempts,
      delay_time,
      drop_delay,
      min_time,                        (* min time granted for door use *)
      hang_time,                       (* no entry hangup time *)
      max_SL,
      logtype          : BYTE;         (* 0=NONE 1=PART 2=COMP *)
      startmenu        : STRING[7];

      LC_SL,
      LC_DSL,
      LD_SL,
      LD_DSL           : BYTE;

      LC_AR,
      LD_AR            : ACFF;

      LC_flags,
      LD_flags         : ACRR;      (* userrec.uflags *)

      IRQLevel,

      LC_filepoints,
      LD_filepoints    : INTEGER;

      bbs_areac,
      bbs_prefix,
      bbs_suffix       : STRING[4];

      LD_PREFIX        : STRING[20];

      dialcommand,                     (* command to dial on modem *)
      hangupcmd        : STRING[30];   (* command to hangup the modem *)

      logfiledir,
      _BBSDIR_         : STRING[60];   (* now is BBS directory! *)

      version1,
      version2,

      LastDate,                       (* for checking autocfg *)

      LD_WIN_START,
      LD_WIN_STOP      : LONGINT;

    END;

  RGuserrec= record
    name:string[36];                  { system name      }
    realname:string[36];              { real name        }
    pw:string[20];                    { password         }
    ph:string[12];                    { phone #          }
    bday:string[8];                   { birthdate        }
    firston:string[8];                { first on date    }
    laston:string[8];                 { last on date     }
    street:string[30];                { street address   }
    citystate:string[30];             { city, state      }
    zipcode:string[10];               { zipcode          }
    usrdefstr:array[1..3] of string[35]; { type of computer }
                                      { occupation       }
                                      { BBS reference    }
    note:string[35];                  { SysOp note       }
    userstartmenu:string[8];          { menu to start at }
    lockedfile:string[8];             { print lockout msg}
    flags:set of uflags;              { flags            }
    sflags:set of suflags;            { status flags     }
    ar:set of acrq;                   { AR flags         }
    vote:array[1..25] of byte;        { voting data      }

    sex:char;                         { gender           }
    ttimeon,                          { total time on    }
    uk,                               { UL k             }
    dk:longint;                       { DL k             }
    tltoday,                          { # min left today }
    forusr,                           { forward mail to  }
    filepoints:integer;               { # of file points }

    uploads,downloads,                { # of ULs/# of DLs}
    loggedon,                         { # times on       }
    msgpost,                          { # message posts  }
    emailsent,                        { # email sent     }
    feedback,                         { # feedback sent  }
    timebank,                         { # mins in bank   }
    timebankadd,                      { # added today    }
    dlktoday,                         { # kbytes dl today}
    dltoday:word;                     { # files dl today }

    waiting,                          { mail waiting     }
    linelen,                          { line length      }
    pagelen,                          { page length      }
    ontoday,                          { # times on today }
    illegal,                          { # illegal logons }
    barf,
    lastmbase,                        { # last msg base  }
    lastfbase,                        { # last file base }
    sl,dsl:byte;                      { SL / DSL         }

    mhiread:mhireadr;                 { Message last read date ptrs}
    mzscan:mzscanr;                   { Which message bases to scan}
    fzscan:fzscanr;                   { Which file bases to scan}

    cols:colors;                      { user colors }

    garbage:byte;
    timebankwith:word;                { amount of time withdrawn today}
    passwordchanged:word;             { last day password changed }
    defarctype:byte;                  { default QWK archive type }
    lastconf:char;                    { last conference they were in }
    lastqwk:longint;                  { date/time of last qwk packet }
    getownqwk:boolean;                { add own messages to qwk packet? }
    scanfilesqwk:boolean;             { scan file bases for qwk packets? }
    privateqwk:boolean;               { get private mail in qwk packets? }

    credit:longint;                   { Amount of credit a user has }
    debit:longint;                    { Amount of debit a user has }
    expiration:longint;               { Expiration date of this user }
    expireto:char;                    { Subscription level to expire to }
    ColorScheme:byte;                 { User's color scheme # }

    res:array[1..2] of byte;         { RESERVED }
  end;

(***************************************************************************)
const
  ver='01-03 Beta';
  maxprotocols=120;
  maxevents=10;
  maxarcs=8;
  maxbatchfiles=50;
  maxmenucmds=100;

TYPE
  astr=string[160];

  acstring=string[20];            { Access Condition String }

  secrange = array[0..255] of integer;        { Access tables }

  filearcinforec=                 { Archive configuration records }
  record
    active:boolean;               { active or not  }
    ext:string[3];                { file extension }
    listline,                     { /x for internal;
                                     x: 1=ZIP, 2=ARC/PAK, 3=ZOO, 4=LZH }
    arcline,                      { compression cmdline    }
    unarcline,                    { de-compression cmdline }
    testline,                     { integrity test cmdline }
    cmtline:string[25];           { comment cmdline        }
    succlevel:integer;            { success ERRORLEVEL, -1=ignore results }
  end;

  historyrec=                     { HISTORY.DAT : Summary logs }
  record
    date:string[8];
    userbaud:array[0..4] of word;
    active,callers,newusers,posts,email,feedback,
    errors,uploads,downloads:word;
    uk,dk:longint;
  end;

  modemflags=         { MODEM.DAT status flags }
  (
    lockedport,       { COM port locked at constant rate }
    xonxoff,          { XON/XOFF (software) flow control }
    ctsrts            { CTS/RTS (hardware) flow control }
  );


linerec=
  record
    waitbaud:word;                    { initialization baud }
    comport:byte;                     { COM port number }
    init:string[50];                  { init string }
    answer:string[40];                { answer string }
    hangup:string[40];                { hangup string }
    offhook:string[40];               { phone off-hook string }
    nocallinittime:word;              { reinit modem after x mins of inactivity }
    lockedportbaud:word;              { locked baud rate }
    mflags:set of modemflags;         { status flags }
    nocarrier:byte;                   { NO CARRIER result code }
    resultcode:array[1..2,0..14]      { CONNECT result codes }
                 of byte;             { 300,1200,2400,4800,7200,9600,12000,14400,16800,19200,5 extra}
    logonacs:acstring;                { acs string to logon this node }
    doorpath:string[40];              { path to write door info files to }
  end;

  validationrec = record
    description:string[25];           { description }
    newsl,                            { new SL }
    newdsl:byte;                      { new DSL }
    newar:set of acrq;                { new AR }
    newac:set of uflags;              { new AC }
    newfp:integer;                    { file points to add }
    newcredit:longint;                { new credit (added) }
    expiration:word;                  { days until expiration }
    expireto:char;                    { validation level to expire to }
    softar:boolean;                   { TRUE=AR added to current, else replaces }
    softac:boolean;                   { TRUE=AC    "   "   "       "      "  }
    newmenu:string[8];                { User start out menu }
  end;


systatrec=
  record
    datapath:string[40];              { DATA path }
    miscpath:string[40];              { MISC path }
    menupath:string[40];              { MENU path }
    logspath:string[40];              { LOGS path }
    msgpath:string[40];               { MSGS path }
    nodepath:string[40];              { NODE list path }
    temppath:string[40];              { TEMP path }
    protpath:string[40];              { PROT path }
    arcspath:string[40];              { ARCS path }

    bbsname:string[40];               { BBS name }
    bbsphone:string[12];              { BBS phone number }
    sysopname:string[30];             { SysOp's name }

    lowtime,                          { SysOp begin minute (in minutes) }
    hitime,                           { SysOp end time }
    dllowtime,                        { normal downloading hours begin.. }
    dlhitime,                         { ..and end }
    minbaudlowtime,                   { minimum baud calling hours begin.. }
    minbaudhitime,                    { ..and end }
    minbauddllowtime,                 { minimum baud downloading hours begin.. }
    minbauddlhitime:integer;          { ..and end }

    minimumbaud,                      { minimum baud rate to logon }
    minimumdlbaud:longint;            { minimum baud rate to download }

    shuttlelog,                       { Use Shuttle Logon? }
    closedsystem,                     { Allow new users? }
    swapshell:boolean;                { Swap on shell? }

    sysoppw,                          { SysOp password }
    newuserpw,                        { newuser password }
    minbaudoverride,                  { override minimum baud rate }
    shuttlepw:string[20];             { Shuttle password }

    crapola2:string[8];               { }

    sop,                              { SysOp }
    csop,                             { Co-SysOp }
    msop,                             { Message SysOp }
    fsop,                             { File SysOp }
    spw,                              { SysOp PW at logon }
    seepw,                            { see SysOp PWs remotely  }
    normpubpost,                      { make normal public posts }
    normprivpost,                     { send normal e-mail }
    anonpubread,                      { see who posted public anon }
    anonprivread,                     { see who sent anon e-mail }
    anonpubpost,                      { make anon posts }
    anonprivpost,                     { send anon e-mail }
    seeunval,                         { see unvalidated files }
    dlunval,                          { DL unvalidated files }
    nodlratio,                        { no UL/DL ratio }
    nopostratio,                      { no post/call ratio }
    nofilepts,                        { no file points checking }
    ulvalreq,                         { uploads require validation }
    junkola1,                         { nuuuuuuuuukkkkkkkked }
    overridechat:acstring;            { override chat hours }

    maxprivpost,                      { max email can send per call }
    maxfback,                         { max feedback per call }
    maxpubpost,                       { max posts per call }
    maxchat,                          { max sysop pages per call }
    maxwaiting,                       { max mail waiting }
    csmaxwaiting,                     { max mail waiting for Co-SysOp + }
    junk1,                            { }
    junk2,                            { }
    maxlogontries,                    { tries allowed for PW's at logon }
    sysopcolor,                       { SysOp color in chat mode }
    usercolor:byte;                   { user color in chat mode }
    minspaceforpost,                  { minimum drive space left to post }
    minspaceforupload:integer;        { minimum drive space left to upload }
    backsysoplogs,                    { days to keep SYSOP##.LOG }
    eventwarningtime,                 { minutes before event to warn user }
    wfcblanktime:byte;                { minutes before blanking WFC menu }

    allowalias,                       { allow handles? }
    phonepw,                          { phone number password in logon? }
    localsec,                         { use local security? }
    globaltrap,                       { trap everyone's activity? }
    autochatopen,                     { automatically open chat buffer? }
    autominlogon,                     { Auto-Message at logon? }
    bullinlogon,                      { bulletins at logon? }
    lcallinlogon,                     { "Last Few Callers" list at logon? }
    yourinfoinlogon,                  { "Your Info" at logon? }
    offhooklocallogon,                { phone off-hook for local logons? }
    forcevoting,                      { manditory voting? }
    compressbases,                    { "compress" file/msg base numbers? }
    searchdup:boolean;                { search for dupes files when UL? }
    slogtype:byte;                    { log type: File/Printer/Both }
    stripclog:boolean;                { strip colors from SysOp log? }
    newapp,                           { send new user application to # }
    timeoutbell,                      { minutes before timeout beep }
    timeout:integer;                  { minutes before timeout }
    useems:boolean;                   { use EMS for overlay }
    usebios:boolean;                  { use BIOS for video output }
    cgasnow:boolean;                  { snow supression on }
    alertbeep:integer;                { time between alert beeps }

    filearcinfo:
        array[1..maxarcs] of filearcinforec;           { archive specs }
    filearccomment:
        array[1..3] of string[40];    { BBS comment files for archives }
    uldlratio,                        { use UL/DL ratios? }
    fileptratio:boolean;              { use auto file-pt compensation? }
    fileptcomp,                       { file point compensation ratio }
    fileptcompbasesize,               { file point base compensation size }
    ulrefund,                         { percent of time to refund on ULs }
    tosysopdir:byte;                  { SysOp file base }
    validateallfiles:boolean;         { validate files automatically? }
    maxintemp,                        { max K allowed in TEMP }
    minresume:integer;                { min K to allow resume-later }

    RES99:array[1..11] of byte;

    sysoppword:boolean;               { check for sysop password? }

    RES98:array[1..9] of byte;

    allstartmenu:string[8];           { logon menu to start users on }
    bulletprefix:string[8];           { default bulletins filename }

    timeallow,                        { time allowance }
    callallow,                        { call allowance }
    dlratio,                          { # ULs/# DLs ratios }
    dlkratio,                         { DLk/ULk ratios }
    postratio,                        { posts per call ratio }
    dloneday,                         { Max number of dload files in one day}
    dlkoneday:secrange;               { Max k downloaded in one day}

    lastdate:string[8];               { last system date }
    curwindow:byte;                   { type of SysOp window in use }
    istopwindow:boolean;              { is window at top of screen? }
    callernum:longint;                { system caller number }
    numusers:integer;                 { number of users }
  end;

(***************************************************************************)



VAR

   SecTable            : secrange;

   AddTimeLOCAL,
   AddTimeLONGD        : INTEGER;

   RGuserfile          : FILE OF RGuserrec;
   RGuser              : RGuserrec;
   RGUserFN            : STRING;

   Config              : ConfigRec;
   ConfigFile          : FILE OF ConfigRec;

   RealCFGName         : STRING;

IMPLEMENTATION

END.
