/* Sample REXX program demonstrating the data queue library functions */
/* This sample will create a non-keyed data queue, query the data     */
/* queue, send and receive one message, then delete the data queue.   */

arg dqname
if dqname = '' then do
  say 'A data queue name must be entered in AS/400 format.'
  say 'Example: TESTDQ QGPL/TESTQ'
  say
  exit
end

arg dqname

/* Load the data queues external utility functions */
Call RxFuncAdd 'CADQLoadFuncs', 'CADQUTIL', 'CADQLoadFuncs'
Call CADQLoadFuncs

/* Set translation on, peek (non-destructive read) off */
Call CADQSetMode ,1,0
Call ShowResult 'CADQSetMode'

/* Create a keyed data queue on the default system */
/* Max length=256, FIFO sequence, no force, *ALL authority, include sender */
/* Key length=5                                                            */
Call CADQCreate dqname,,256,,0,0,1,"Test Keyed Data Queue",5
Call ShowResult 'CADQCreate'

/* Query the new data queue */
Call CADQQuery dqname
Call ShowResult 'CADQQuery'

say '  Max length:' dq_maxlen
say '  Sequence:  ' dq_seq
say '  Force:     ' dq_force
say '  Sender:    ' dq_sender
say '  Text:      ' dq_text
say '  Key length:' dq_keylen
say

/* Clear the data queue */
Call CADQClear dqname
Call ShowResult 'CADQClear'

/* Send a message to the data queue */
Call CADQSend dqname,,"Data queue operation successful!","DQKey"
Call ShowResult 'CADQSend'

/* Receive the message from the data queue into REXX variable DQ_DATA */
Call CADQReceive dqname,,2,'DQ_DATA',256,'DQ_SNDR','DQKey','EQ','DQ_KEY',5
Call ShowResult 'CADQReceive'

/* Show the received queue message, sender ID, and key values */
say '  Key:   ' '"'dq_key'"'
say '  Sender:' '"'dq_sndr'"'
say '  Data:  ' '"'dq_data'"'
say

/* Delete the data queue */
Call CADQDelete dqname
Call ShowResult 'CADQDelete'

/* Unload all utility functions */
Call RxFuncDrop 'CADQLoadFuncs'
Call RxFuncDrop 'CADQCreate'
Call RxFuncDrop 'CADQDelete'
Call RxFuncDrop 'CADQClear'
Call RxFuncDrop 'CADQPut'
Call RxFuncDrop 'CADQSend'
Call RxFuncDrop 'CADQReceive'
Call RxFuncDrop 'CADQSetMode'
Call RxFuncDrop 'CADQGetMsg'
Call RxFuncDrop 'CADQQuery'
Call RxFuncDrop 'CADQStop'

exit

/* Procedure ShowResult: Show the result code from the utility call */
/* If a non-zero result is received, show all error messages */
ShowResult:
  parse arg rtn

  say rtn':' result
  if result <> 0 then do
    Call CADQGetMsg
    do while result <> ''
      say result
      Call CADQGetMsg
    end
  end
  say

return

