; ADDXDAT.LSP   copyright 1993, Anthony Hotchkiss

;;; ADDXDAT --  A function to create an xdata list
(defun addxdat (/ appname xdat more xdname xdtype xdval item)   
   (setq appname (getstring "\nApplication ID name: "))
   (setq xdat (list (cons 1002 "{")))
;;;  The major segment of the function is a while loop, which tests
;;;  that you want to add 'more' xdata, so we set 'more' to 't':
   (setq more t)
   (while more
;;;  The xdata is defined as an item name, an item type, and value:
      (setq xdname (getstring "\nItem name <exit>: "))
;;;  If the default 'exit' is used, the function bypasses the 'if' statement
      (if (/= xdname "")
         (progn
;;;  The 'item name' is added to the 'xdat' list with the correct
;;;  dxf code '1000'
            (setq xdname (cons 1000 xdname))
            (setq xdat (append xdat (list xdname)))
;;;  The 'item type' is forced to be String, Distance, Integer, or Real:
            (initget "String Distance Integer Real")
            (setq xdtype (getkword 
               "\nItem type String/Distance/Integer/Real: "))
;;;  The user now enters the 'item value.'
            (setq xdval (getstring "\nItem value: "))
;;;  The dotted pair of the dxf code and the item value is formed
;;;  depending on the item type using the (cond) function
            (setq item
               (cond
                  ((= xdtype "String") (cons 1000 xdval))
                  ((= xdtype "Distance") (cons 1041 (atof xdval)))
                  ((= xdtype "Integer") (cons 1070 (atoi xdval)))
                  ((= xdtype "Real") (cons 1040 (atof xdval)))
                  (t nil)
               ); cond
            ); setq
;;;  The dotted pair is now added to the list of 'xdat'
            (setq xdat (append xdat (list item)))
;;;  If an item name was given, we set 'more' to 't'
            (setq more t)
         ); progn
;;;  Or else, we set 'more' to nil, and the 'if' statement is completed
         (setq more nil)
      ); if
;;;  That also ends the 'while' loop:
   ); while
;;;  Finally, we add the closing "}" to the end of  'xdat,'
   (setq xdat (append xdat (list (cons 1002 "}"))))
;;;  and we add the (-3  ("application-name"..  to the front of 'xdat':
   (setq xdat (list -3 (cons appname xdat)))
); end of defun


