; TIP938A.LSP: DIAI.LSP    Dimensioning Circles and Arcs   
;                          (c)1993, Ken Leseberg

; Program used to add a diameter dimension to a circle.
; The arrow heads plus an internal line are inside the circle.

(defun C:DIAI (/ tmco pk p1a p1b p1 p2 p4 p5 p7 p9 ngl mngl rrad ipt srs str ht lcr loc dst xxx dly ccol tortho pkk)
   (setq tmco (getvar "cmdecho"))
   (setq ccol (getvar "cecolor"))
   (setq tortho (getvar "orthomode"))
   (command "color" "green")
   (setvar "cmdecho" 0)
   (setvar "orthomode" 0)
   (setq pkk (entsel "\nSelect arc or circle: ")
      pk (car (cdr pkk))
      p1a (osnap pk "nea")
      p2 (osnap p1a "cen")
      rrad (distance p1a p2)
   srs 0)
   (while (/= srs 3)
      (setq ipt (grread T)
         srs (car ipt) p7 (cadr ipt)
         ngl (angle p7 p2)
      p1b (polar p2 ngl rrad))
      (grdraw p1b p7 -1)
      (setq xxx 0)
      (setq dly (repeat 10 
      (setq xxx (+ xxx 1))))
      (grdraw p1b p7 -1)
   )
   (grdraw p1b p7 -1)
   (setq mngl (+ pi ngl)
      p1 (polar p2 mngl rrad)
      p4 (polar p1 ngl (* 0.18 (getvar "dimscale")))
      p5 (polar p1b mngl (* 0.18 (getvar "dimscale")))
   zw (* 0.06 (getvar "dimscale")))
   (setvar "ORTHOMODE" 1)
   (setq p9 (getpoint p7 "\nPick point to finish leader: "))
   (grdraw p1b p7 -1)
   (command "pline" p1b "w" 0 zw p5 "w" 0 0 p4 "w" zw 0 p1 p7 p9 "")
   (command "color" "11")
   (setq str (strcat "%%c" (rtos (* (getvar "dimlfac") (distance p1 p1b))))
      dst (* 1.0 (getvar "dimtxt") (getvar "dimscale"))
      ht (* (getvar "dimtxt") (getvar "dimscale"))
      lcr (polar p9 PI dst)
   loc (polar p9 0.0 dst))
   (if (< (car p9) (car p7))
      (command "text" "j" "mr" lcr ht 0 str)
      (command "text" "j" "ml" loc ht 0 str)
   )
   (setvar "ORTHOMODE" tortho)
   (setvar "cmdecho" tmco)
   (command "color" ccol)
   (prin1)
); end diai.lsp
