; TIP930.LSP: HELIX.LSP    Draw A Helix   (c)1993, Claude Fleury

(defun RADI (radian)
   (/ (* 180.0 radian)pi)
)
;
(defun c:HELIX ()
   (setq CMD (getvar "cmdecho"))
   (setvar "cmdecho" 0)
   (setq BLIP (getvar "blipmode"))
   (setvar "blipmode" 0)
   ;
   ;Data
   ;----
   (prompt"\nHELIX")
   (setq PITCH (getdist"\nPitch                   = "))
   (setq PITCH2 (getint"\nNumber of pitches <2>   = "))
   (cond ((null pitch2)(setq pitch2 2)))
   (setq RAD (getdist"\nRadius                 = "))
   (setq PREC (getint"\nDivisions points <100> = "))
   (cond ((null PREC)(setq PREC 100)))
   ;
   ;Execution
   ;---------
   (setq TOUR 0)
   (setq ANG1 (* 0.5 pi))           ;start angle
   (setq PT0 (getpoint "Start point (Center line) "))
   (setq ANG2 (/ (* 2.0 pi)PREC))
   (setq DISTY (/ PITCH PREC))
   (command "pline" PT0)
   (repeat PITCH2
      (repeat PREC
         (setq TOUR (+ 1 TOUR))
         (setq ANG3 (+ (* ANG2 TOUR) ANG1))
         (setq DISTY2 (* DISTY TOUR))
         (setq DISTX (* (cos ANG3) RAD))
         (setq PTY (polar PT0 (* 0.5 pi) DISTY2))
         (setq PTX (polar PTY 0 DISTX))
         (command PTX)
      )
   )
   (command "")
   ;
   ;Rotation
   ;--------
   (setq ANG (getangle PT0 "\nRotation Angle <90> = "))
   (cond ((null ANG)(setq ANG (/ pi 2.0))))
   (setq ANG (RADI ANG))
   (setq ANG (- ANG 90.0))
   (setq SS (ssget "L")) 
   (command "ROTATE" SS "" PT0 ANG)
   ;
   (setvar "cmdecho" CMD)
   (setvar "blipmode" BLIP)
   (prin1)
); end helix.lsp
