; TIP924.LSP: XTARC.LSP   Extend Arc    (c)1993, Jeff Clark
;   $25 Bonus Winner

(defun C:XTARC (/ arc sang eang rad delta arcln aa as amt
   amtrd end newang oldang newln newdelta diff)
   (setq arc (entget (car (entsel "\nPick arc: "))))
   (setq sang (cdr (assoc 50 arc)))
   (setq eang (cdr (assoc 51 arc)))
   (setq rad (cdr (assoc 40 arc)))
   (setq delta (/ (* (- eang sang) 180.0) pi))
   (if (< delta 0.0) (setq delta (+ 360.0 delta)))
   (setq arcln (/ (* (* rad pi) delta) 180.0))
   (print (strcat "Arc length = " (rtos arcln 2 4)))
   (initget 1 "T D")
   (setq aa (getkword "\nTotal or Distance to change <T or D>: "))
   (cond ((= aa "D")
         (initget 1 "A S")
         (setq as (getkword "\nAdd or Subtract <A or S>: "))
         (setq amtrd (* pi (/ (/ (* 57.2957795 (getreal "\nAmount to Add or Subtract: ")) rad) 180.0)))
         (initget 1 "S E")
         (setq end (getkword "\nChange the Startpoint or Endpoint <S or E>? "))
         (cond ((= end "S")
               (if (= as "A")
                  (setq newang (- sang amtrd))
               (setq newang (+ sang amtrd)))
               (setq newang (cons 50 newang))
               (setq oldang (assoc 50 arc))
               (setq arc (subst newang oldang arc))
            (entmod arc))
            ((= end "E")
               (if (= as "A")
                  (setq newang (+ eang amtrd))
               (setq newang (- eang amtrd)))
               (setq newang (cons 51 newang))
               (setq oldang (assoc 51 arc))
               (setq arc (subst newang oldang arc))
            (entmod arc))
         )
      )
      ((= aa "T")
         (initget 1 "S E")
         (setq end (getkword "\nChange Start or End point <S or E>: "))
         (if (= end "S")
            (setq pt1 (polar (cdr (assoc 10 arc)) sang rad))
         (setq pt1 (polar (cdr (assoc 10 arc)) eang rad)))
         (grdraw (polar pt1 3.926 8) (polar pt1 0.785 8) -1 1)
         (grdraw (polar pt1 5.497 8) (polar pt1 2.356 8) -1 1)
         (initget 7)
         (setq newdelta (/(* 57.2957795 (getreal "\nNew arc length: ")) rad)
         diff (* pi (/ (- delta newdelta) 180.0)))
         (cond ((= end "S")
               (setq newang (cons 50 (+ sang diff)))
               (setq oldang (assoc 50 arc))
               (setq arc (subst newang oldang arc))
            (entmod arc))
            ((= end "E")
               (setq newang (cons 51 (- eang diff)))
               (setq oldang (assoc 51 arc))
               (setq arc (subst newang oldang arc))
            (entmod arc))
         )
      )
   )
   (princ)
); end xtarc.lsp
