; TIP922.LSP: CONDUIT.LSP    Draw Conduit   (c)1993, Watson Kilbourne

; Draws armored conduit at any angle with user defined outside diameter
;

(defun c:CONDUIT
   (/ ce bm om sp ep od dx an nx nu pa pb pc p1 p2 p3 p4 p5 p6 p7 p8 p9 p0 xt)
   (setq ce (getvar "CMDECHO"))
   (setq bm (getvar "BLIPMODE"))
   (setq om (getvar "OSMODE"))
   (defun ne (ne)
      (setvar "CMDECHO" ce)
      (setvar "BLIPMODE" bm)
      (setvar "OSMODE" om)
      (princ "Function cancelled ")
      (princ)
   )
   (setq oe *error* *error* ne)
   (setvar "CMDECHO" 0)
   (while (= sp nil) (setq sp (getpoint "\nPick start point of conduit: ")))
   (while (= ep nil) (setq ep (getpoint "\nPick end point of conduit: ")))
   (setq od (getdist "\nPick or enter outside diameter of conduit <0.5>: "))
   (if (= od nil)
      (setq od 0.5)
   )
   (setvar "BLIPMODE" 0)
   (setvar "OSMODE" 0)
   (setq dx (distance sp ep)
      an (angle sp ep)
      nx (/ od 2)
      nu (/ dx nx)
      pa (polar sp an (/ od 10))
      pb (polar pa an (/ od 5))
      pc (polar sp (+ an (* pi 1.5)) (/ od 2))
      p1 (polar pa (+ an (* pi 1.5)) (/ od 2.5))
      p2 (polar p1 an (/ od 10))
      p3 (polar pb (+ an (* pi 1.5)) (/ od 2))
      p4 (polar p3 an (/ od 5))
      p5 (polar p2 an (/ od 2.5))
      p9 (polar sp (+ an (/ pi 2)) (/ od 2.5))
      p6 (polar p9 an (/ od 2.5))
      p7 (polar pb (+ an (/ pi 2)) (/ od 2))
      p8 (polar p7 (+ an pi) (/ od 5))
      p0 (polar p6 an (/ od 10))
   )
   (command "LINE" sp p1 pc p9 "")
   (repeat (fix nu)
      (command ".LINE" p1 p2 p3 p4 p5 p6 p7 p8 p9 p2 "" ".LINE" p6 p0 "")
      (setq sp (polar sp an nx)
         p1 (polar p1 an nx)
         p2 (polar p2 an nx)
         p3 (polar p3 an nx)
         p4 (polar p4 an nx)
         p5 (polar p5 an nx)
         p6 (polar p6 an nx)
         p7 (polar p7 an nx)
         p8 (polar p8 an nx)
         p9 (polar p9 an nx)
         p0 (polar p0 an nx)
      )
   )
   (setq xt (distance sp ep))
   (if (>= xt (/ od 5))
      (command ".LINE" p6 p7 p8 p9 p2 p1 "" ".LINE" p2 p3 p4 "")
   )
   (setvar "OSMODE" om)
   (setvar "CMDECHO" ce)
   (setvar "BLIPMODE" bm)
   (setq *error* oe oe nil)
   (princ)
); end conduit.lsp
