;TIP847B: TUBENDS.LSP (C)1993, CAREY T. WALDROP

(defun C:TUBENDS ()
  (COMMAND "LIMITS" "OFF")
  (setvar "flatland" 0)
  (graphscr)
  (setvar "cmdecho" 0)
  (setvar "splframe" 1)
  (setq p1 (getpoint "\ncenter of tube? "))(terpri)
  (setq nf (getstring "\nnumber of 3d faces? "))(terpri)
  (setq dia (getreal "\ndiameter of tube? "))(terpri)
  (setq length (getstring "\nlength of tube? "))(terpri)
  (setq L1 (atof length))
  (setq r (/ dia 2.0))
  (setq alpha (/ 360.0 (atof nf)))
  (setq ang (/ alpha 2.0))
  (setq PT1 (polar p1 (* pi (/ alpha 180.0)) r))
  (setq PT2 (list (car PT1) (cadr PT1) (- (caddr PT1) L1)))
  (setq PT4 (polar p1 0.0 r))
  (setq PT3 (list (car PT4) (cadr PT4) (- (caddr PT4) L1)))
  (setq PT5 (list (car p1) (cadr p1) (caddr PT1)))
  (setq PT6 (list (car p1) (cadr p1) (- (caddr PT1) L1)))
  (command "3dface" PT1 "i" PT2 "i" PT3 "i" PT4 "")
  (setq z1 (list (- (car p1) 2) (- (cadr p1) 2)))
  (setq z2 (list (+ (car p1) 2) (+ (cadr p1) 2)))
  (command "zoom" "w" z1 z2)
  (setq ss1 (ssget "L"))
  (command "rotate" ss1 "" p1 ang)
  (command "array" "L" "" "P" p1 nf 360.0 "Y")
  (command "3dface" PT4 "i" PT1 "i" PT5 "" "")
  (setq ss2 (ssget "L"))
  (command "rotate" ss2 "" p1 ang)
  (command "array" ss2 "" "P" p1 nf 360.0 "Y")
  (command "zoom" "p")
  (command "copy" ss2 "" PT5 PT6)
  (command "array" "L" "" "P" p1 nf 360.0 "Y")
  (COMMAND "LIMITS" "ON")
)
