
/*-----------------11-17-93 04:41pm-----------------
 This is the .Cfg structure. All CNMsg programs use
 some parts of this structure.
 --------------------------------------------------*/
struct _CFG {
   char archive[41],
        unarchive[41];
   int  b_zone,
        b_net,
        b_node,
        b_point;
   char b_domain[21];
   int  zone,
        net,
        node,
        point;
   char domain[21],
        SPARE[164];
   int  maximum,
        days;
   char uname[36],
        editor[21],
        origin[51];
   int  beep:1,
        UNUSED:15;
   char SPARE2[94];
};


/*-----------------10-29-93 03:29pm------------------
 This is the message file header. It tracks the last
 read values as well as storing information about the
 number of messages allowed, the last one read, the
 maximum messages to allow in the file and the number
 of days to keep a message in the file.

 CyberNetMessageHeaDeR.
 ---------------------------------------------------*/
struct _CNMHDR
{
   long  update;
   int   messages,
         lastread,
         maximum,
         days;
   char  tag[36],
         SPARE[76];
   long  startmark;
};


/*-----------------10-29-93 03:04pm--------------------------------------------
 This is a CyberNet format message. This structure is followed by the control
 data, the text, the trailer (SEEN-BY: and ^APATH: lines) and then the last 4
 bytes which are the offset in the file of the start of the header for the
 message. This means that to move backwards through the file you have two
 options, 1 would be to use the TO index file and skip backwards one record at
 a time, positioning to the offset that is in each record, 2 would be to read
 the last 4 bytes of the file and then seek to that offset and read the header
 there, the previous message's header can always be located by reading the 4
 bytes immediately preceding the current header. The last 4 bytes of the file
 header (startmark) MUST be 0 to indicate that there are no more messages prior
 to the header that immediately follows.

 CyberNetMessageMessageHeaDeR.
 -----------------------------------------------------------------------------*/
struct _CNMMHDR
{
   char  from[36],
         to[36],
         subj[36];
   long  wdate,
         adate;
   int   ozone,
         onet,
         onode,
         opoint,
         dzone,       /* 1: These 4 destination fields are only used when */
         dnet,        /* 2: the message is outbound NetMail */
         dnode,       /* 3: */
         dpoint;      /* 4: */
   char  odomain[21],
         ddomain[21]; /* ... as well as this one */
   int   replyto,
         nextreply,
         /*-----------------11-10-93 10:23pm-------------------
          Note: The next three fields should never be less than
                1 since there will always be a NULL byte that
                terminates each string. Therefore a length of
                < 2 is to be interpreted as an empty string.
          ----------------------------------------------------*/
         control,       /* length of the control data */
         length,        /* length of the message text */
         trailer;       /* anything from SEEN-BY: to the end */
   int   sent:1;        /* 16 bit flag word */
         deleted:1,
         unused:14;

   char  SPARE[70];
};


/*-----------------10-29-93 07:36pm-----------------
 This is the message TO index file structure. It may
 also be used as a general index. To jump to message
 x you would position to (x-1)*sizeof(TDX), read the
 offset and then position to that offest in the main
 .Msg file.
 --------------------------------------------------*/
struct _CNMTDX
{
   char  to[36];
   long  offset;
};


/*-----------------10-28-93 06:23pm---------------
 FidoNet Type-2 message packet header. Followed by
 multiple messages in _PMHDR format. End of packet
 is marked by a double NULL (2 ASCII 0's).

 PacketHeaDeR.
 ------------------------------------------------*/
struct _PHDR
{
   int   onode,
         dnode,
         year,
         month,      /* month # -1 */
         day,
         hour,
         minute,
         second,
         baudrate,   /* always set to 0 */
         packet_ver, /* set to 2 for this version */
         onet,
         dnet,
         product;    /* product code is 0 */
   char  password[8];/* for pickup (set to all 0's) */
   int   qmozone,    /* as per QMail */
         qmdzone,    /* as per QMail */
         BLANK,      /* extra unused bytes */
         cwvalid,    /* byte-swapped CapabilityWord (make 256) */
         prodcode,   /* product code (make 0) */
         cw,         /* CapabilityWord (make 1) */
         fdozone,    /* as per FD */
         fddzone,    /* as per FD */
         fdopoint,   /* as per FD */
         fddpoint;   /* as per FD */
   long  proddata;   /* 4 bytes - product specific data */
};


/*-----------------10-28-93 06:24pm------------------
 FidoNet packed message header, followed by unbounded
 text up to a NULL (ASCII 0). God, these need work.
 FidoNet really needs to update the packet header as
 well as the packet message header to allow for five
 point addressing.

 PackedMessageHeaDeR.
 ---------------------------------------------------*/
struct _PMHDR
{
   int   type,       /* message type (use 2) */
         onode,
         dnode,
         onet,
         dnet,
         attribute,
         cost;

         /*-----------------10-28-93 06:31pm-----------------
           Now (each NULL terminated) we have:
            Date
            To
            From
            Subj
            Text
         --------------------------------------------------*/
};

/*
   Dates are tricky since they may be in one of two formats. This is how to
   test for the type and what it will need to be treated as.

      If the first character is a digit then this is the format:

                  1         2
         12345678901234567890

         01 Jan 86  02:34:56

      Else it must be SEAdog format...

                  1         2
         12345678901234567890

         Mon  1 Jan 86 02:34

*/
