	       INCLUDE MODEL.INC
;
;---------------------------------------------------------------------------
;   Function:	void _bye_setname(s)
;
;   Parms:	int *s;  -> ptr to string buffer
;
;   Purpose:	This function copies a null terminated string up
;		to 64 characters in length. The string contains the
;		callers name for the caller currently on line.
;
;   Return:	void
;---------------------------------------------------------------------------
;
	       PUBLIC __bye_setname

__bye_setname  PROC

	       push bp			;standard 'C' function entry
	       mov  bp,sp
	       push ds
	       push es
	       push si
	       push di

	       mov  ah,21		;AH=21 for get name ptr
	       int  BYE_VECT		;ES:BX = name ptr buffer
	       mov  di,bx		;DI = BX
	     IF @datasize
	       lds  si,ARG1		;DS:SI = far ptr source string
	     ELSE
	       mov  si,ARG1		;DS:SI = near ptr source string
	     ENDIF

	       cld			;clear direction flag
setn_loop:     lodsb			;get a byte at DS:SI in AL
	       stosb			;store a byte at ES:DI
	       cmp  al,0		;end of the string yet?
	       jne  SHORT setn_loop	;no, keep looping

setn_end:      pop  di
	       pop  si
	       pop  es
	       pop  ds
	       mov  sp,bp		;standard 'C' exit
	       pop  bp
	       ret

__bye_setname  ENDP
	       END

