	       INCLUDE MODEL.INC
;
;---------------------------------------------------------------------------
;   Function:	void _bye_setbreak(flag)
;
;   Parms:  flag =
;
;	CTRL_NOBRK   = 0    remote ^C & ^S break disabled
;	CTRL_BRK     = 1    remote ^C & ^S break enabled
;	CTRL_NOTOUT  = 2    remote ^S timeout disabled
;	CTRL_TOUT    = 3    remote ^S timeout enabled
;	CTRL_NOTRAP  = 4    dont filter out ^C & ^S chars
;	CTRL_TRAP    = 5    filter on for  ^C & ^S chars
;
;   Purpose:	This sets the control/break pause flag for the
;		remote caller only! The local console still has
;		control over breaks/pauses.
;
;   Return:	void
;---------------------------------------------------------------------------
;
	       PUBLIC __bye_setbreak

__bye_setbreak PROC

	       push bp			;standard 'C' function entry
	       mov  bp,sp

	       mov  ax,ARG1		;ctrl-break state in AL
	       mov  ah,8		;AH=8 for set break mode
	       int  BYE_VECT

	       mov  sp,bp		;standard 'C' exit
	       pop  bp
	       ret

__bye_setbreak ENDP
	       END

