
 /************************************************************************
  * Buttons2.c                                                           *
  * Draw an array of software buttons and panels.                        *
  *                                                                      *
  *     Adrian Christie 1994                                             *
  *     AOL:AusarKam                                                     *
  *     Internet: ausarkam@aol.com                                       *
  *                                                                      *
  * This program is distributed in the hope that it will be useful,      *
  * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
  * MERCHANTABILITY or FITNESS FOR ANY PARTICULAR PURPOSE.               *
  *                                                                      *
  * Written for Microsoft QuickC, but can be adapted for Borland TurboC  *
  ************************************************************************/

  #include <stdio.h>
  #include <graph.h>
  #include <dos.h>
  #include "mouse.h"
  #include "buttons2.h"
  #include "panel.h"
  #include "colors.h"

  main()
  {
	 DefineScreen();
	 MouseInit(&Hold);

	 /* Demo of DrawPanel() function */
	 DrawPanel(100,15,440,450,GREY,YES,GREY,BLACK,0,YES);
	 DrawPanel(110,20,420,435,RED, NO, GREY,BLACK,0,YES);
	 DrawPanel(113,23,414,429,CYAN,NO, GREY,BLACK,0,YES);
	 DrawPanel(113,23,414,14,BLUE,NO, GREY,BLACK,0, YES);
	 DrawPanel(514,24,12,12,GREY,YES, GREY+BRIGHT,BLACK,1, YES);
	 DrawPanel(500,24,12,12,GREY,YES, GREY+BRIGHT,BLACK,1, YES);
	 DrawPanel(113,38,414,10,GREY+BRIGHT,NO,GREY+BRIGHT,BLACK,0,YES);
	 DrawPanel(114,50,412,20,GREY,YES,GREY+BRIGHT,BLACK,1,YES);
	 DrawPanel(124,53,80,14,CYAN+BRIGHT,NO,GREY+BRIGHT,BLACK,1,NO);
	 DrawPanel(214,53,80,14,CYAN+BRIGHT,NO,GREY+BRIGHT,BLACK,1,NO);
	 DrawPanel(191,54,12,12,GREEN,YES,GREY+BRIGHT,BLACK,2,YES);
	 DrawPanel(281,54,12,12,GREEN,YES,GREY+BRIGHT,BLACK,2,YES);
	 DrawPanel(310,54,12,12,GREY,YES,GREY+BRIGHT,BLACK,1,YES);
	 DrawPanel(335,54,12,12,GREY,YES,GREY+BRIGHT,BLACK,1,YES);
	 DrawPanel(360,54,12,12,GREY,YES,GREY+BRIGHT,BLACK,1,YES);
	 DrawPanel(385,54,12,12,GREY,YES,GREY+BRIGHT,BLACK,1,YES);
	 DrawPanel(410,54,12,12,GREY,YES,GREY+BRIGHT,BLACK,1,YES);
	 DrawPanel(435,54,12,12,GREY,YES,GREY+BRIGHT,BLACK,1,YES);
	 DrawPanel(460,54,12,12,GREY,YES,GREY+BRIGHT,BLACK,1,YES);
	 DrawPanel(485,54,30,12,GREY,YES,GREY+BRIGHT,BLACK,1,YES);
	 DrawPanel(114,73,140,340,RED, YES,GREY+BRIGHT,BLACK,0,YES);
	 DrawPanel(117,76,134,334,GREY,YES,GREY+BRIGHT,BLACK,0,YES);
	 DrawPanel(118,77,132,14, GREY+BRIGHT,YES,GREY+BRIGHT,BLACK,0,YES);
	 DrawPanel(123,99,103,305,BLUE, NO,GREY+BRIGHT,BLACK,1,YES);
	 DrawPanel(236,94,14,315, CYAN+BRIGHT,NO,GREY+BRIGHT,BLACK,0,YES);
	 DrawPanel(236,94,14,14,  GREEN,YES,GREY+BRIGHT,BLACK,2,YES);
	 DrawPanel(257,73,269,340,RED, YES,GREY+BRIGHT,BLACK,0,YES);
	 DrawPanel(260,76,263,334,GREY,YES,GREY+BRIGHT,BLACK,0,YES);

	 MouseShow(&Hold);

	 do
	   MouseCoord(&Hold);
	 while(Hold.MouseButton!=1);

	 MouseHide(&Hold);

	 /* Demo of calculator */
	 DrawPanel(40,40,285,170,CYAN,YES,GREY+BRIGHT,BLACK,2,YES);
	 DrawPanel(50,50,265,150,GREY,NO ,GREY+BRIGHT,BLACK,1,YES);
	 DrawPanel(55,55,253,30, GREY,NO ,GREY+BRIGHT,BLACK,1,YES);
	 DrawPanel(59,59,244,22,BLACK,NO ,GREY+BRIGHT,BLACK,0,YES);
	 DrawButton(55,94, 45,20, CYAN, 5,2, 4,2, YES,1,YES);
	 DrawButton(55,144,45,20, CYAN, 3,2, 4,2, YES,1,YES);
	 DrawButton(211,144,45,45,CYAN, 1,1, 0,0, YES,1,YES);
	 DrawButton(263,144,45,20,CYAN, 1,2, 4,2, YES,1,YES);

	 GetButtons();
  }

  void DefineScreen()
  {
	/*------------------------- set screen mode ----------------------------*/
	if(_setvideomode(_VRES16COLOR)==0){                     /* 16 color VGA */
	   printf("Can't set mode");
	   exit(1);
	}
	_setcolor(7);
	_rectangle(_GFILLINTERIOR,0,0, WID-1,HEI-1);
  }

 void DrawPanel(int xl,int yl,int w,int h,int c,int b,int bl,int br,int p,int f)
 {
	int xr,yr, cnt;

	/* lower right corner */
	xr=xl+w;
	yr=yl+h;

	/* draw box and fill */
	if(f==YES){
	   _setcolor(c);
	   _rectangle(_GFILLINTERIOR, xl,yl, xr,yr);
	}

	/* draw frame */
	if(f==YES){
	   _setcolor(BLACK);
	   xl=xl-1; yl=yl-1; xr=xr+1; yr=yr+1;
	   _rectangle(_GBORDER,xl,yl, xr,yr);
	   xl=xl+1; yl=yl+1; xr=xr-1; yr=yr-1;
	}

	/* draw shadow */
	if(b==YES){
	   for(cnt=0; cnt<p; cnt++){                                  /* raised */
		  _setcolor(bl);
		  _moveto(xr-w,yr);
		  _lineto(xl,yl);
		  _lineto(xr,yr-h);

		  _setcolor(br);
		  _lineto(xr,yr);
		  _lineto(xr-w,yr);

		  xr=xr-1; w=w-2; yr=yr-1;
		  xl=xl+1; yl=yl+1; h=h-2;
	   }
	}
	else
	{
	   for(cnt=0; cnt<p; cnt++){                                /* indented */
		  _setcolor(br);
		  _moveto(xr-w,yr);
		  _lineto(xl,yl);
		  _lineto(xr,yr-h);

		  _setcolor(bl);
		  _lineto(xr,yr);
		  _lineto(xr-w,yr);

		  xr=xr-1; w=w-2; yr=yr-1;
		  xl=xl+1; yl=yl+1; h=h-2;
	   }
	}
 }

  void DrawButton(int xl,int yt,int xw,int yh,int col,int n_o_x,int n_o_y,
				   int xspac,int yspac,int rais,int pix,int fram){

	 /*****************************
	  *   define some variables   *
	  *****************************/
	 xdist=xw+3+xspac;                            /*x distance between boxes*/
	 ydist=yh+3+yspac;                            /*y distance between boxes*/
	 x_reset=xl;                                    /*reset x to left margin*/
	 xright=xl+xw;                                      /*lower right corner*/
	 ybot=yt+yh;                                        /*lower right corner*/

	 /*************************************************
	 * draw all buttons & store coordinates in arrays *
	 **************************************************/
	 for( ;yaxis<n_o_y; ){
		for( ;xaxis<n_o_x; ){
		   _setcolor(col);
		   _rectangle(_GFILLINTERIOR,xl,yt, xright,ybot);
		   Shadow_1(xl,yt,xw,yh,YES);
		   XLeftCoord[cnt]=xl;
		   YTopCoord[cnt]=yt;
		   XRightCoord[cnt]=xright;
		   YBotCoord[cnt]=ybot;
		   ColorButton[cnt]=col;
		   cnt++;                                        /*increment counter*/
		   xl=xl+xdist;                               /*increment top x axis*/
		   xright=xright+xdist;                    /*increment bottom x axis*/
		   xaxis++;                              /*increment button position*/
		}
		xaxis=0, xl=x_reset;                               /*reset variables*/
		xright=xl+xw;
		yt=yt+ydist;                                  /*increment top y axis*/
		ybot=ybot+ydist;                           /*increment bottom y axis*/
		yaxis++;                               /*increment y button position*/
	 }
	 xaxis=0,yaxis=0;
  }

  void GetButtons(){

	 /***********************************************************************
	  * detect which button was selected & retrieve coordinates from arrays *
	  ***********************************************************************/
	 TotalButtons=cnt;

	 while (1)
	 {
	   MouseCoord(&Hold);                            /*get location of mouse*/
	   MouseShow(&Hold);                              /*turn on mouse cursor*/

	   if (Hold.MouseButton==1){
		 for(cnt=0;cnt<TotalButtons;cnt++){
		   if (Hold.MouseX> XLeftCoord[cnt]  &&
			   Hold.MouseX< XRightCoord[cnt] &&
			   Hold.MouseY> YTopCoord[cnt]   &&
			   Hold.MouseY< YBotCoord[cnt]   ){

			   MouseHide(&Hold);                     /*turn off mouse cursor*/

			   xw=XRightCoord[cnt]-XLeftCoord[cnt];
			   yh=YBotCoord[cnt]-YTopCoord[cnt];
			   Shadow_2(xw,yh,NO);

			   MouseShow(&Hold);

			   /*wait for mouse left button to be released*/
			   do{
				  MouseCoord(&Hold);
			   }
			   while(Hold.MouseButton==1);

			   MouseHide(&Hold);
			   Shadow_2(xw,yh,YES);
			   MouseShow(&Hold);
		   }
		 }
	   }
	   else if (Hold.MouseButton==2)
	   {
		 MouseHide(&Hold);
		 _setvideomode(_DEFAULTMODE);
		 exit(1);
	   }
	 }
  }

  void Shadow_1(int xleft,int ytop,int x_width,int y_height,int r)
  {
	/* frame button */
	_setcolor(0);
	_rectangle(_GBORDER,xleft-1,ytop-1, xright+1,ybot+1);

	if(r==YES){                                                     /*raised*/
	   _setcolor(15);
	   _moveto(xleft,ytop+y_height);
	   _lineto(xleft,ytop);
	   _lineto(xleft+x_width,ytop);
	   _setcolor(0);
	   _lineto(xright,ybot);
	   _lineto(xleft,ytop+y_height);
	}
	else                                                          /*indented*/
	{
	   _setcolor(0);
	   _moveto(xl,yt+y_height);
	   _lineto(xl,yt);
	   _lineto(xl+x_width,yt);
	   _setcolor(15);
	   _lineto(xright,ybot);
	   _lineto(xl,yt+y_height);
	}
  }

  void Shadow_2(int x_width,int y_height,int r)
  {
	if(r==YES){
	   _setcolor(15);
	   _moveto(XLeftCoord[cnt],YTopCoord[cnt]+y_height);
	   _lineto(XLeftCoord[cnt],YTopCoord[cnt]);
	   _lineto(XLeftCoord[cnt]+x_width,YTopCoord[cnt]);
	   _setcolor(0);
	   _lineto(XRightCoord[cnt],YBotCoord[cnt]);
	   _lineto(XLeftCoord[cnt],YTopCoord[cnt]+y_height);
	}
	else
	{
	   _setcolor(0);
	   _moveto(XLeftCoord[cnt],YTopCoord[cnt]+y_height);
	   _lineto(XLeftCoord[cnt],YTopCoord[cnt]);
	   _lineto(XLeftCoord[cnt]+x_width,YTopCoord[cnt]);
	   _setcolor(15);
	   _lineto(XRightCoord[cnt],YBotCoord[cnt]);
	   _lineto(XLeftCoord[cnt],YTopCoord[cnt]+y_height);
	}
  }

 void MouseInit(struct Mouse_data *M_ptr)
 {
	inregs.x.ax=0;
	int86(Mouse,&inregs,&outregs);
	M_ptr->MouseFlag=outregs.x.ax;

	if(Hold.MouseFlag==0)
	   exit(1);                                           /* no mouse found */
 }

 void MouseShow(struct Mouse_data *M_ptr)
 {
	inregs.x.ax=1;
	int86(Mouse,&inregs,&outregs);
 }

 void MouseHide(struct Mouse_data *M_ptr)
 {
	inregs.x.ax=2;
	int86(Mouse,&inregs,&outregs);
 }

 void MouseCoord(struct Mouse_data *M_ptr)
 {
	inregs.x.ax=3;
	int86(Mouse,&inregs,&outregs);
	M_ptr->MouseButton=outregs.x.bx;            /* which button was pressed */
	M_ptr->MouseX=outregs.x.cx;                         /* coordinate for x */
	M_ptr->MouseY=outregs.x.dx;                         /* coordinate for y */
 }

 void MouseCoordSet(struct Mouse_data *M_ptr)
 {
	inregs.x.ax=4;
	inregs.x.cx=M_ptr->MouseX;
	inregs.x.dx=M_ptr->MouseY;
	int86(Mouse,&inregs,&outregs);
 }

 void MouseReset(struct Mouse_data *M_ptr)
 {
	inregs.x.ax=4;
	inregs.x.cx=M_ptr->MouseX;
	inregs.x.dx=M_ptr->MouseY;
	int86(Mouse,&inregs,&outregs);
 }

 void MouseTimesPressed(struct Mouse_data *M_ptr)
 {
	inregs.x.ax=5;
	inregs.x.bx=M_ptr->MouseButton;
	int86(Mouse,&inregs,&outregs);
 }

 void MouseTimesReleased(struct Mouse_data *M_ptr)
 {
	inregs.x.ax=6;
	inregs.x.bx=M_ptr->MouseButton;
	int86(Mouse,&inregs,&outregs);
 }

 void Mouse_x_limit(struct Mouse_data *M_ptr)
 {
	inregs.x.ax=7;
	inregs.x.cx=M_ptr->MouseMinX;
	inregs.x.dx=M_ptr->MouseMaxX;
	int86(Mouse,&inregs,&outregs);
 }
 void Mouse_y_limit(struct Mouse_data *M_ptr)
 {
	inregs.x.ax=8;
	inregs.x.cx=M_ptr->MouseMinY;
	inregs.x.dx=M_ptr->MouseMaxY;
	int86(Mouse,&inregs,&outregs);
 }



